/*
 * Decompiled with CFR 0.152.
 */
package io.opencensus.trace.unsafe;

import io.opencensus.internal.Provider;
import io.opencensus.trace.ContextHandle;
import io.opencensus.trace.ContextManager;
import io.opencensus.trace.Span;
import io.opencensus.trace.unsafe.ContextManagerImpl;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;

public class ContextHandleUtils {
    private static final Logger LOGGER = Logger.getLogger(ContextHandleUtils.class.getName());
    private static final ContextManager CONTEXT_MANAGER = ContextHandleUtils.loadContextManager(ContextManager.class.getClassLoader());

    private ContextHandleUtils() {
    }

    private static ContextManager loadContextManager(@Nullable ClassLoader classLoader) {
        try {
            return Provider.createInstance(Class.forName("io.opentelemetry.opencensusshim.OpenTelemetryContextManager", true, classLoader), ContextManager.class);
        }
        catch (ClassNotFoundException e) {
            LOGGER.log(Level.FINE, "Couldn't load full implementation for OpenTelemetry context manager, now loading original implementation.", e);
            return new ContextManagerImpl();
        }
    }

    public static ContextHandle currentContext() {
        return CONTEXT_MANAGER.currentContext();
    }

    public static ContextHandle withValue(ContextHandle context, @Nullable Span span) {
        return CONTEXT_MANAGER.withValue(context, span);
    }

    public static Span getValue(ContextHandle context) {
        return CONTEXT_MANAGER.getValue(context);
    }
}

