/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.common.xmap;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.nuxeo.common.collections.PrimitiveArrays;
import org.nuxeo.common.xmap.AttributeValueVisitor;
import org.nuxeo.common.xmap.Context;
import org.nuxeo.common.xmap.DOMHelper;
import org.nuxeo.common.xmap.ElementValueVisitor;
import org.nuxeo.common.xmap.ElementVisitor;
import org.nuxeo.common.xmap.Path;
import org.nuxeo.common.xmap.XAccessor;
import org.nuxeo.common.xmap.XAnnotatedMember;
import org.nuxeo.common.xmap.XAnnotatedReference;
import org.nuxeo.common.xmap.XMLBuilder;
import org.nuxeo.common.xmap.XMap;
import org.nuxeo.common.xmap.annotation.XNodeList;
import org.w3c.dom.Element;

public class XAnnotatedList
extends XAnnotatedMember {
    protected static final ElementVisitor elementListVisitor = new ElementVisitor();
    protected static final ElementValueVisitor elementVisitor = new ElementValueVisitor();
    protected static final AttributeValueVisitor attributeVisitor = new AttributeValueVisitor();
    protected Class<?> componentType;
    protected boolean isNullByDefault;
    protected XAnnotatedReference merge;
    protected XAnnotatedReference remove;

    protected XAnnotatedList(XMap xmap, XAccessor setter) {
        super(xmap, setter);
    }

    public XAnnotatedList(XMap xmap, XAccessor setter, XNodeList anno) {
        super(xmap, setter);
        this.path = new Path(anno.value());
        this.trim = anno.trim();
        this.type = anno.type();
        this.componentType = anno.componentType();
        this.valueFactory = xmap.getValueFactory(this.componentType);
        this.xao = xmap.register(this.componentType);
        this.isNullByDefault = anno.nullByDefault();
    }

    public void setMerge(XAnnotatedReference merge) {
        this.merge = merge;
    }

    public void setRemove(XAnnotatedReference remove) {
        this.remove = remove;
    }

    @Override
    public void process(Context ctx, Element element, Object existing) {
        Object value;
        Object[] currentListValue;
        if (this.remove != null && Boolean.TRUE.equals(this.remove.getValue(ctx, element))) {
            this.setValue(ctx.getObject(), this.convertList(Collections.emptyList()));
            return;
        }
        ArrayList<Object> initList = new ArrayList<Object>();
        if (existing != null && (!this.hasValue(ctx, element) || this.merge == null || Boolean.TRUE.equals(this.merge.getValue(ctx, element))) && (currentListValue = this.getCurrentListValue(existing)) != null) {
            initList.addAll(Arrays.asList(currentListValue));
        }
        if ((value = this.getValue(ctx, element, initList)) != null) {
            this.setValue(ctx.getObject(), value);
        }
    }

    @Override
    public Object getValue(Context ctx, Element base) {
        return this.getValue(ctx, base, new ArrayList<Object>());
    }

    protected Object getValue(Context ctx, Element base, List<Object> values) {
        if (this.xao != null) {
            DOMHelper.visitNodes(ctx, this, base, this.path, elementListVisitor, values);
        } else if (this.path.attribute != null) {
            DOMHelper.visitNodes(ctx, this, base, this.path, attributeVisitor, values);
        } else {
            DOMHelper.visitNodes(ctx, this, base, this.path, elementVisitor, values);
        }
        return this.convertList(values);
    }

    protected Object convertList(List<Object> values) {
        if (this.isNullByDefault && values.isEmpty()) {
            return null;
        }
        if (this.type != ArrayList.class) {
            if (this.type.isArray()) {
                if (this.componentType.isPrimitive()) {
                    return PrimitiveArrays.toPrimitiveArray(values, this.componentType);
                }
                return values.toArray((Object[])Array.newInstance(this.componentType, values.size()));
            }
            try {
                Collection col = (Collection)this.type.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                col.addAll(values);
                return col;
            }
            catch (ReflectiveOperationException e) {
                throw new IllegalArgumentException(e);
            }
        }
        return values;
    }

    protected Object[] getCurrentListValue(Object instance) {
        Object v = this.accessor.getValue(instance);
        if (v != null) {
            Object[] objects = v instanceof Object[] ? (Object[])v : (v instanceof List ? ((List)v).toArray() : (v instanceof Collection ? ((Collection)v).toArray() : PrimitiveArrays.toObjectArray(v)));
            return objects;
        }
        return null;
    }

    @Override
    public void toXML(Object instance, Element parent) {
        block4: {
            Object[] objects = this.getCurrentListValue(instance);
            if (objects == null) break block4;
            if (this.xao == null) {
                for (Object o : objects) {
                    String value;
                    if (this.valueFactory == null || o instanceof Element || (value = this.valueFactory.serialize(null, o)) == null) continue;
                    Element e = XMLBuilder.addElement(parent, this.path);
                    XMLBuilder.fillField(e, value, this.path.attribute);
                }
            } else {
                for (Object o : objects) {
                    Element e = XMLBuilder.addElement(parent, this.path);
                    XMLBuilder.toXML(o, e, this.xao);
                }
            }
        }
    }
}

