/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.connect.update.standalone;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileTime;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.Environment;
import org.nuxeo.common.utils.ZipUtils;
import org.nuxeo.connect.update.AlreadyExistsPackageException;
import org.nuxeo.connect.update.LocalPackage;
import org.nuxeo.connect.update.PackageException;
import org.nuxeo.connect.update.PackageState;
import org.nuxeo.connect.update.PackageUpdateService;
import org.nuxeo.connect.update.standalone.LocalPackageImpl;

public class PackagePersistence {
    private static final Log log = LogFactory.getLog(PackagePersistence.class);
    protected final File root;
    protected final File store;
    protected final File temp;
    protected static final Random RANDOM = new SecureRandom();
    protected Map<String, PackageState> states;
    private PackageUpdateService service;

    public PackagePersistence(PackageUpdateService pus) throws IOException {
        Environment env = Environment.getDefault();
        this.root = env.getPath("nuxeo.mp.dir", "packages");
        if (!this.root.isAbsolute()) {
            throw new RuntimeException();
        }
        this.root.mkdirs();
        this.store = new File(this.root, "store");
        this.store.mkdirs();
        this.temp = new File(this.root, "tmp");
        this.temp.mkdirs();
        this.service = pus;
        this.states = this.loadStates();
    }

    public File getRoot() {
        return this.root;
    }

    public File getStore() {
        return this.store;
    }

    public synchronized Map<String, PackageState> getStates() {
        return new HashMap<String, PackageState>(this.states);
    }

    protected Map<String, PackageState> loadStates() throws IOException {
        HashMap<String, PackageState> result = new HashMap<String, PackageState>();
        File file = new File(this.root, ".packages");
        if (file.isFile()) {
            List<String> lines = FileUtils.readLines(file, StandardCharsets.UTF_8);
            for (String line : lines) {
                if ((line = line.trim()).length() == 0 || line.startsWith("#")) continue;
                int i = line.indexOf(61);
                String pkgId = line.substring(0, i).trim();
                String value = line.substring(i + 1).trim();
                PackageState state = PackageState.getByLabel(value);
                if (state == PackageState.UNKNOWN) {
                    try {
                        state = PackageState.getByValue(value);
                    }
                    catch (NumberFormatException e) {
                        state = PackageState.REMOTE;
                    }
                }
                result.put(pkgId, state);
            }
        }
        return result;
    }

    protected void writeStates() throws IOException {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, PackageState> entry : this.states.entrySet()) {
            sb.append(entry.getKey()).append('=').append((Object)entry.getValue()).append("\n");
        }
        File file = new File(this.root, ".packages");
        FileUtils.writeStringToFile(file, sb.toString(), StandardCharsets.UTF_8);
    }

    public LocalPackage getPackage(String id) throws PackageException {
        File file = new File(this.store, id);
        if (file.isDirectory()) {
            return new LocalPackageImpl(file, this.getState(id), this.service);
        }
        return null;
    }

    public synchronized LocalPackage addPackage(File file) throws PackageException {
        if (file.isDirectory()) {
            return this.addPackageFromDir(file);
        }
        if (file.isFile()) {
            File tmp = this.newTempDir(file.getName());
            try {
                ZipUtils.unzip(file, tmp);
                LocalPackage localPackage = this.addPackageFromDir(tmp);
                return localPackage;
            }
            catch (IOException e) {
                throw new PackageException("Failed to unzip package: " + file.getName());
            }
            finally {
                FileUtils.deleteQuietly(tmp);
            }
        }
        throw new PackageException("Not found: " + file);
    }

    protected LocalPackage addPackageFromDir(File file) throws PackageException {
        LocalPackageImpl pkg = new LocalPackageImpl(file, PackageState.DOWNLOADED, this.service);
        File dir = null;
        try {
            dir = new File(this.store, pkg.getId());
            if (dir.exists()) {
                LocalPackage oldpkg = this.getPackage(pkg.getId());
                if (!pkg.getVersion().isSnapshot()) {
                    throw new AlreadyExistsPackageException("Package " + pkg.getId() + " already exists");
                }
                if (oldpkg.getPackageState().isInstalled()) {
                    throw new AlreadyExistsPackageException("Package " + pkg.getId() + " is already installed");
                }
                log.info(String.format("Replacement of %s in local cache...", oldpkg));
                FileUtils.deleteQuietly(dir);
            }
            FileUtils.copyDirectory(file, dir);
            pkg.getData().setRoot(dir);
            this.updateState(pkg.getId(), pkg.state);
            return pkg;
        }
        catch (IOException e) {
            throw new PackageException(String.format("Failed to move %s to %s", file, dir), e);
        }
    }

    public synchronized PackageState getState(String packageId) {
        PackageState state = this.states.get(packageId);
        if (state == null) {
            return PackageState.REMOTE;
        }
        return state;
    }

    public LocalPackage getActivePackage(String name) throws PackageException {
        String pkgId = this.getActivePackageId(name);
        if (pkgId == null) {
            return null;
        }
        return this.getPackage(pkgId);
    }

    public synchronized String getActivePackageId(String name) throws PackageException {
        for (Map.Entry<String, PackageState> entry : this.states.entrySet()) {
            String pkgId = entry.getKey();
            if (!pkgId.startsWith(name) || !entry.getValue().isInstalled() || !this.getPackage(pkgId).getName().equals(name)) continue;
            return pkgId;
        }
        return null;
    }

    public synchronized List<LocalPackage> getPackages() throws PackageException {
        File[] list = this.store.listFiles();
        if (list != null) {
            ArrayList<LocalPackage> pkgs = new ArrayList<LocalPackage>(list.length);
            for (File file : list) {
                if (!file.isDirectory()) {
                    log.warn("Ignoring file '" + file.getName() + "' in package store");
                    continue;
                }
                pkgs.add(new LocalPackageImpl(file, this.getState(file.getName()), this.service));
            }
            return pkgs;
        }
        return new ArrayList<LocalPackage>();
    }

    public synchronized void removePackage(String id) throws PackageException {
        this.states.remove(id);
        try {
            this.writeStates();
        }
        catch (IOException e) {
            throw new PackageException("Failed to write package states", e);
        }
        File file = new File(this.store, id);
        FileUtils.deleteQuietly(file);
    }

    @Deprecated
    public synchronized void updateState(String id, int state) throws PackageException {
        this.states.put(id, PackageState.getByValue(state));
        try {
            this.writeStates();
        }
        catch (IOException e) {
            throw new PackageException("Failed to write package states", e);
        }
    }

    public synchronized void updateState(String id, PackageState state) throws PackageException {
        this.states.put(id, state);
        try {
            this.writeStates();
        }
        catch (IOException e) {
            throw new PackageException("Failed to write package states", e);
        }
    }

    public synchronized void reset() throws PackageException {
        String[] keys;
        for (String key : keys = this.states.keySet().toArray(new String[this.states.size()])) {
            this.states.put(key, PackageState.DOWNLOADED);
        }
        try {
            this.writeStates();
        }
        catch (IOException e) {
            throw new PackageException("Failed to write package states", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected File newTempDir(String id) {
        File tmp;
        File file = this.temp;
        synchronized (file) {
            while ((tmp = new File(this.temp, id + "-" + RANDOM.nextInt())).exists()) {
            }
            tmp.mkdirs();
        }
        return tmp;
    }

    public FileTime getInstallDate(String id) {
        File file = new File(this.store, id);
        if (file.isDirectory()) {
            Path path = file.toPath();
            try {
                FileTime lastModifiedTime = Files.readAttributes(path, BasicFileAttributes.class, new LinkOption[0]).lastModifiedTime();
                return lastModifiedTime;
            }
            catch (IOException e) {
                log.error(e);
            }
        }
        return null;
    }
}

