/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.launcher.config.backingservices;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.function.UnaryOperator;
import org.nuxeo.common.xmap.XMap;
import org.nuxeo.launcher.config.ConfigurationException;
import org.nuxeo.launcher.config.ConfigurationHolder;

public interface BackingChecker {
    public boolean accepts(ConfigurationHolder var1);

    public void check(ConfigurationHolder var1) throws ConfigurationException;

    default public <T> T getDescriptor(ConfigurationHolder configHolder, String configName, Class<T> klass) throws ConfigurationException {
        return this.getDescriptor(configHolder, configName, klass, UnaryOperator.identity());
    }

    default public <T> T getDescriptor(ConfigurationHolder configHolder, String configName, Class<T> klass, UnaryOperator<String> replacer) throws ConfigurationException {
        Path configPath = configHolder.getConfigurationPath().resolve(configName);
        if (Files.notExists(configPath, new LinkOption[0])) {
            throw new ConfigurationException("Configuration file: " + configPath + " for class: " + klass.getSimpleName() + "doesn't exist");
        }
        XMap xmap = new XMap();
        xmap.register(klass);
        try {
            Object[] nodes;
            String content = Files.readString(configPath, StandardCharsets.UTF_8);
            content = (String)replacer.apply(content);
            for (Object node : nodes = xmap.loadAll(new ByteArrayInputStream(content.getBytes()))) {
                if (node == null) continue;
                return (T)node;
            }
            throw new ConfigurationException("No configuration found for class: " + klass.getSimpleName() + " in file:" + configPath);
        }
        catch (IOException e) {
            throw new ConfigurationException("Unable to load the configuration for class:" + klass.getSimpleName() + " from file:" + configPath, e);
        }
    }
}

