/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.launcher.process;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.nuxeo.launcher.process.UnixProcessManager;

public class SolarisProcessManager
extends UnixProcessManager {
    protected static final String SOLARIS_11 = "5.11";
    protected static final String[] SOLARIS_11_PS = new String[]{"/usr/bin/ps", "auxww"};
    protected static final Pattern PS_OUTPUT_LINE = Pattern.compile("^[^\\s]+\\s+([0-9]+)\\s+[0-9.\\s]+[^\\s]+\\s+[^\\s]+\\s+[^\\s]+\\s+[^\\s]+\\s+(.*)$");
    protected String solarisVersion;

    protected SolarisProcessManager(Pattern processPattern, String solarisVersion) {
        super(processPattern);
        this.solarisVersion = solarisVersion;
    }

    @Override
    protected String[] psCommand() {
        if (SOLARIS_11.equals(this.solarisVersion)) {
            return SOLARIS_11_PS;
        }
        return null;
    }

    @Override
    protected Matcher lineMatcher(String line) {
        return PS_OUTPUT_LINE.matcher(line);
    }

    @Override
    public Optional<Long> findPid() throws IOException {
        if (SOLARIS_11.equals(this.solarisVersion)) {
            return super.findPid();
        }
        throw new RuntimeException("Unsupported Solaris version: " + this.solarisVersion);
    }

    protected static String getSolarisVersion() {
        List<Object> lines;
        try {
            lines = SolarisProcessManager.execute("/usr/bin/uname", "-r");
        }
        catch (IOException e) {
            lines = Collections.emptyList();
        }
        return lines.isEmpty() ? "?" : ((String)lines.get(0)).trim();
    }
}

