/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.deploy;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.collections.ListenerList;
import org.nuxeo.runtime.deploy.ConfigurationChangedListener;
import org.nuxeo.runtime.deploy.FileChangeListener;
import org.nuxeo.runtime.deploy.FileChangeNotifier;
import org.nuxeo.runtime.model.RuntimeContext;

public class ConfigurationDeployer
implements FileChangeListener {
    private static final Log log = LogFactory.getLog(ConfigurationDeployer.class);
    protected final Map<String, Entry> urls;
    protected final FileChangeNotifier notifier;
    protected final ListenerList listeners = new ListenerList();

    public ConfigurationDeployer() {
        this(null);
    }

    public ConfigurationDeployer(FileChangeNotifier notifier) {
        this.notifier = notifier;
        this.urls = new HashMap<String, Entry>();
        if (notifier != null) {
            notifier.addListener(this);
        }
    }

    public void deploy(RuntimeContext ctx, URL url, boolean trackChanges) throws IOException {
        File watchFile = null;
        if (trackChanges) {
            try {
                String str = url.toExternalForm();
                if (str.startsWith("file:")) {
                    watchFile = new File(url.toURI());
                } else if (str.startsWith("jar:file:")) {
                    int p = str.lastIndexOf(33);
                    str = p > -1 ? str.substring(4, p) : str.substring(4);
                    watchFile = new File(new URI(str));
                }
            }
            catch (URISyntaxException e) {
                log.error(e);
                watchFile = null;
            }
        }
        this._deploy(ctx, url, watchFile, trackChanges);
    }

    public void undeploy(URL url) throws IOException {
        Entry entry = this.urls.remove(url.toExternalForm());
        if (entry != null) {
            this._undeploy(entry);
        }
    }

    public synchronized void _undeploy(Entry entry) throws IOException {
        try {
            entry.ctx.undeploy(entry.url);
        }
        finally {
            if (this.notifier != null && entry.watchFile != null) {
                this.notifier.unwatch(entry.url.toExternalForm(), entry.watchFile);
            }
        }
    }

    public void deploy(RuntimeContext ctx, File file, boolean trackChanges) throws IOException {
        this._deploy(ctx, file.getCanonicalFile().toURI().toURL(), file, trackChanges);
    }

    public void undeploy(File file) throws IOException {
        this.undeploy(file.getCanonicalFile().toURI().toURL());
    }

    protected synchronized void _deploy(RuntimeContext ctx, URL url, File watchFile, boolean trackChanges) throws IOException {
        String id = url.toExternalForm();
        Entry entry = new Entry(ctx, url, watchFile);
        ctx.deploy(url);
        this.urls.put(id, entry);
        if (trackChanges && this.notifier != null && watchFile != null) {
            this.notifier.watch(id, watchFile);
        }
    }

    @Override
    public void fileChanged(FileChangeNotifier.FileEntry entry, long now) {
        Entry e = this.urls.get(entry.id);
        if (e != null) {
            try {
                e.ctx.undeploy(e.url);
                e.ctx.deploy(e.url);
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
            finally {
                this.fireConfigurationChanged(e);
            }
        }
    }

    public void addConfigurationChangedListener(ConfigurationChangedListener listener) {
        this.listeners.add(listener);
    }

    public void removeConfigurationChangedListener(ConfigurationChangedListener listener) {
        this.listeners.remove(listener);
    }

    public void fireConfigurationChanged(Entry entry) {
        for (Object obj : this.listeners.getListenersCopy()) {
            ((ConfigurationChangedListener)obj).configurationChanged(entry);
        }
    }

    public static class Entry {
        final RuntimeContext ctx;
        final URL url;
        File watchFile;

        Entry(RuntimeContext ctx, URL config, File watchFile) throws IOException {
            this.url = config;
            this.ctx = ctx;
            if (watchFile != null) {
                this.watchFile = watchFile.getCanonicalFile();
            }
        }

        public RuntimeContext getContext() {
            return this.ctx;
        }

        public File getWatchFile() {
            return this.watchFile;
        }

        public URL getUrl() {
            return this.url;
        }

        public String toString() {
            return this.url.toExternalForm();
        }
    }
}

