/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.osgi;

import java.util.LinkedList;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuxeo.runtime.osgi.OSGiRuntimeService;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.SynchronousBundleListener;

public class OSGiComponentLoader
implements SynchronousBundleListener {
    private static final Logger log = LogManager.getLogger(OSGiComponentLoader.class);
    private final OSGiRuntimeService runtime;

    public OSGiComponentLoader(OSGiRuntimeService runtime) {
        this.runtime = runtime;
        this.install();
    }

    public void install() {
        BundleContext ctx = this.runtime.getBundleContext();
        ctx.addBundleListener(this);
        Bundle[] bundles = ctx.getBundles();
        int mask = 40;
        for (Bundle bundle : bundles) {
            String name = bundle.getSymbolicName();
            this.runtime.bundles.put(name, bundle);
            int state = bundle.getState();
            log.debug("Install bundle: {} {}", () -> name, () -> OSGiComponentLoader.bundleStateAsString(state));
            if ((state & mask) != 0) {
                if (OSGiRuntimeService.getComponentsList(bundle) != null) {
                    log.debug("Install bundle: {} component list: {}", (Object)name, (Object)OSGiRuntimeService.getComponentsList(bundle));
                    try {
                        this.runtime.createContext(bundle);
                    }
                    catch (RuntimeException e) {
                        log.error(e, (Throwable)e);
                    }
                    continue;
                }
                log.debug("Install bundle: {} has no components", (Object)name);
                continue;
            }
            log.debug("Install bundle: {} is not STARTING or ACTIVE, so no context was created", (Object)name);
        }
    }

    public void uninstall() {
        this.runtime.getBundleContext().removeBundleListener(this);
    }

    @Override
    public void bundleChanged(BundleEvent event) {
        String name = event.getBundle().getSymbolicName();
        int type = event.getType();
        log.trace("Bundle changed: {} {}", () -> name, () -> OSGiComponentLoader.bundleEventAsString(type));
        try {
            Bundle bundle = event.getBundle();
            String componentsList = OSGiRuntimeService.getComponentsList(bundle);
            switch (type) {
                case 1: {
                    this.runtime.bundles.put(bundle.getSymbolicName(), bundle);
                    break;
                }
                case 16: {
                    this.runtime.bundles.remove(bundle.getSymbolicName());
                    break;
                }
                case 128: 
                case 512: {
                    if (componentsList != null) {
                        log.trace("Bundle changed: {} STARTING with components: ", (Object)name, (Object)componentsList);
                        this.runtime.createContext(bundle);
                        break;
                    }
                    log.trace("Bundle changed: {} STARTING with no components", (Object)name);
                    break;
                }
                case 4: 
                case 64: {
                    if (componentsList != null) {
                        log.trace("Bundle changed: {} STOPPING with components: ", (Object)name, (Object)componentsList);
                        this.runtime.destroyContext(bundle);
                        break;
                    }
                    log.trace("Bundle changed: {} STOPPING with no components", (Object)name);
                }
            }
        }
        catch (RuntimeException e) {
            log.error(e, (Throwable)e);
        }
    }

    public static String bundleStateAsString(int state) {
        LinkedList<String> list = new LinkedList<String>();
        if ((state & 1) != 0) {
            list.add("UNINSTALLED");
        }
        if ((state & 2) != 0) {
            list.add("INSTALLED");
        }
        if ((state & 4) != 0) {
            list.add("RESOLVED");
        }
        if ((state & 8) != 0) {
            list.add("STARTING");
        }
        if ((state & 0x10) != 0) {
            list.add("STOPPING");
        }
        if ((state & 0x20) != 0) {
            list.add("ACTIVE");
        }
        return "[" + String.join((CharSequence)",", list) + "]";
    }

    public static String bundleEventAsString(int eventType) {
        switch (eventType) {
            case 1: {
                return "INSTALLED";
            }
            case 2: {
                return "STARTED";
            }
            case 128: {
                return "STARTING";
            }
            case 4: {
                return "STOPPED";
            }
            case 16: {
                return "UNINSTALLED";
            }
            case 8: {
                return "UPDATED";
            }
            case 512: {
                return "LAZY_ACTIVATION";
            }
            case 32: {
                return "RESOLVED";
            }
            case 64: {
                return "UNRESOLVED";
            }
            case 256: {
                return "STOPPING";
            }
        }
        return "UNKNOWN_OSGI_EVENT_TYPE_" + eventType;
    }
}

