/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.pb.tools;

import java.math.BigInteger;
import java.util.Collection;
import org.sat4j.core.Vec;
import org.sat4j.core.VecInt;
import org.sat4j.pb.IPBSolver;
import org.sat4j.pb.OptToPBSATAdapter;
import org.sat4j.pb.PBSolverDecorator;
import org.sat4j.pb.tools.DependencyHelper;
import org.sat4j.pb.tools.LexicoDecoratorPB;
import org.sat4j.pb.tools.WeightedObject;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LexicoHelper<T, C>
extends DependencyHelper<T, C> {
    private final LexicoDecoratorPB lexico = (LexicoDecoratorPB)((PBSolverDecorator)this.getSolver()).decorated();

    public LexicoHelper(IPBSolver solver) {
        super(new OptToPBSATAdapter(new LexicoDecoratorPB(solver)));
    }

    public LexicoHelper(IPBSolver solver, boolean explanationEnabled, boolean canonicalOptFunctionEnabled) {
        super(new OptToPBSATAdapter(new LexicoDecoratorPB(solver)), explanationEnabled, canonicalOptFunctionEnabled);
    }

    public LexicoHelper(IPBSolver solver, boolean explanationEnabled) {
        super(new OptToPBSATAdapter(new LexicoDecoratorPB(solver)), explanationEnabled);
    }

    public void addCriterion(Collection<T> things) {
        VecInt literals = new VecInt(things.size());
        for (T thing : things) {
            literals.push(this.getIntValue(thing));
        }
        this.lexico.addCriterion(literals);
    }

    public void addWeightedCriterion(Collection<WeightedObject<T>> things) {
        VecInt literals = new VecInt(things.size());
        Vec<BigInteger> coefs = new Vec<BigInteger>(things.size());
        for (WeightedObject<T> wo : things) {
            literals.push(this.getIntValue(wo.thing));
            coefs.push(wo.getWeight());
        }
        this.lexico.addCriterion(literals, coefs);
    }

    public boolean isOptimal() {
        return ((OptToPBSATAdapter)this.getSolver()).isOptimal();
    }
}

