/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.launcher.gui;

import java.awt.Dimension;
import java.awt.HeadlessException;
import java.awt.Toolkit;
import java.io.File;
import java.util.HashMap;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.swing.SwingUtilities;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.launcher.NuxeoLauncher;
import org.nuxeo.launcher.config.ConfigurationGenerator;
import org.nuxeo.launcher.daemon.DaemonThreadFactory;
import org.nuxeo.launcher.gui.ColoredTextPane;
import org.nuxeo.launcher.gui.NuxeoFrame;
import org.nuxeo.launcher.gui.logs.LogsHandler;
import org.nuxeo.launcher.gui.logs.LogsSource;
import org.nuxeo.launcher.gui.logs.LogsSourceThread;

public class NuxeoLauncherGUI {
    static final Log log = LogFactory.getLog(NuxeoLauncherGUI.class);
    private final ExecutorService executor = Executors.newFixedThreadPool(5, new DaemonThreadFactory("NuxeoLauncherGUITask"));
    protected NuxeoLauncher launcher;
    protected NuxeoFrame nuxeoFrame;
    private HashMap<String, LogsSourceThread> logsMap = new HashMap();

    public NuxeoLauncherGUI(NuxeoLauncher launcher) {
        this.launcher = launcher;
    }

    private void initFrame(final NuxeoLauncherGUI controller) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    NuxeoLauncherGUI.this.nuxeoFrame = new NuxeoFrame(controller);
                    NuxeoLauncherGUI.this.nuxeoFrame.pack();
                    Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
                    NuxeoLauncherGUI.this.nuxeoFrame.setLocation(screenSize.width / 2 - NuxeoLauncherGUI.this.nuxeoFrame.getWidth() / 2, screenSize.height / 2 - NuxeoLauncherGUI.this.nuxeoFrame.getHeight() / 2);
                    NuxeoLauncherGUI.this.nuxeoFrame.setVisible(true);
                }
                catch (HeadlessException e) {
                    log.error((Object)e);
                }
            }
        });
    }

    public String execute() {
        this.initFrame(this);
        String command = this.launcher.getCommand();
        if (command != null) {
            if ("start".equalsIgnoreCase(command)) {
                this.start();
            } else if ("stop".equalsIgnoreCase(command)) {
                this.stop();
            } else {
                return command;
            }
        }
        return null;
    }

    public void initLogsManagement(String logFile, ColoredTextPane textArea) {
        LogsSource logsSource = new LogsSource(new File(logFile));
        logsSource.addObserver(new LogsHandler(textArea));
        LogsSourceThread logsSourceThread = new LogsSourceThread(logsSource);
        logsSourceThread.setDaemon(true);
        this.executor.execute(logsSourceThread);
        this.logsMap.put(logFile, logsSourceThread);
    }

    public void stop() {
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                NuxeoLauncherGUI.this.launcher.stop();
                NuxeoLauncherGUI.this.updateServerStatus();
            }
        });
        this.waitForFrameLoaded();
        this.nuxeoFrame.mainButton.setText(NuxeoLauncherGUI.getMessage("mainbutton.stop.inprogress"));
    }

    public void updateServerStatus() {
        this.waitForFrameLoaded();
        this.nuxeoFrame.updateMainButton();
        this.nuxeoFrame.updateSummary();
    }

    public void waitForFrameLoaded() {
        while (this.nuxeoFrame == null) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                log.error((Object)e);
            }
        }
    }

    public void start() {
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                NuxeoLauncherGUI.this.launcher.doStartAndWait();
                NuxeoLauncherGUI.this.updateServerStatus();
            }
        });
        this.waitForFrameLoaded();
        this.nuxeoFrame.mainButton.setText(NuxeoLauncherGUI.getMessage("mainbutton.start.inprogress"));
    }

    public void notifyLogsObserver(String logFile, boolean isActive) {
        LogsSourceThread logsSourceThread = this.logsMap.get(logFile);
        if (isActive) {
            logsSourceThread.getSource().resume();
        } else {
            logsSourceThread.getSource().pause();
        }
    }

    public ConfigurationGenerator getConfigurationGenerator() {
        return this.launcher.getConfigurationGenerator();
    }

    public static String getMessage(String key) {
        String message;
        try {
            message = ResourceBundle.getBundle("i18n/messages").getString(key);
        }
        catch (MissingResourceException e) {
            log.error((Object)e);
            message = NuxeoLauncherGUI.getMessage("missing.translation") + key;
        }
        return message;
    }
}

