/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.launcher;

import java.io.File;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.artofsolving.jodconverter.process.MacProcessManager;
import org.artofsolving.jodconverter.process.ProcessManager;
import org.artofsolving.jodconverter.process.PureJavaProcessManager;
import org.artofsolving.jodconverter.process.UnixProcessManager;
import org.artofsolving.jodconverter.process.WindowsProcessManager;
import org.artofsolving.jodconverter.util.PlatformUtils;
import org.nuxeo.launcher.NuxeoJBossLauncher;
import org.nuxeo.launcher.NuxeoJettyLauncher;
import org.nuxeo.launcher.NuxeoTomcatLauncher;
import org.nuxeo.launcher.config.ConfigurationException;
import org.nuxeo.launcher.config.ConfigurationGenerator;
import org.nuxeo.launcher.daemon.DaemonThreadFactory;
import org.nuxeo.launcher.gui.NuxeoLauncherGUI;
import org.nuxeo.launcher.monitoring.StatusServletClient;
import org.nuxeo.log4j.Log4JHelper;
import org.nuxeo.log4j.ThreadedStreamGobbler;

public abstract class NuxeoLauncher {
    static final Log log = LogFactory.getLog(NuxeoLauncher.class);
    public static final long DEFAULT_RETRY_TIMEOUT = 120000L;
    public static final long DEFAULT_RETRY_INTERVAL = 250L;
    private static final String JAVA_OPTS_PROPERTY = "launcher.java.opts";
    private static final String JAVA_OPTS_DEFAULT = "-Xms512m -Xmx1024m -XX:MaxPermSize=512m";
    private static final String OVERRIDE_JAVA_TMPDIR_PARAM = "launcher.override.java.tmpdir";
    protected boolean overrideJavaTmpDir;
    private static final String START_MAX_WAIT_PARAM = "launcher.start.max.wait";
    private static final String START_MAX_WAIT_DEFAULT = "300";
    private static final String START_MAX_WAIT_JBOSS_DEFAULT = "900";
    private static final int STOP_MAX_WAIT = 10;
    private static final int STOP_NB_TRY = 5;
    private static final int STOP_SECONDS_BEFORE_NEXT_TRY = 2;
    private static final String PARAM_NUXEO_URL = "nuxeo.url";
    private static final String INSTALLER_CLASS = "org.nuxeo.ecm.admin.offline.update.Main";
    protected ConfigurationGenerator configurationGenerator;
    protected ProcessManager processManager;
    protected Process nuxeoProcess;
    private String processRegex;
    protected String pid;
    private ExecutorService executor = Executors.newSingleThreadExecutor(new DaemonThreadFactory("NuxeoProcessThread", false));
    private ShutdownThread shutdownHook;
    protected String[] params;
    protected String command;
    private boolean useGui = false;
    private boolean reloadConfiguration = false;
    private int status = 4;
    private int errorValue = 0;
    private StatusServletClient statusServletClient;
    private boolean quiet = false;
    private static Map<String, NuxeoLauncherGUI> guis;

    public final ConfigurationGenerator getConfigurationGenerator() {
        return this.configurationGenerator;
    }

    public String getCommand() {
        return this.command;
    }

    public boolean isUsingGui() {
        return this.useGui;
    }

    public boolean isQuiet() {
        return this.quiet;
    }

    public NuxeoLauncherGUI getGUI() {
        if (guis == null) {
            return null;
        }
        return guis.get(this.configurationGenerator.getNuxeoConf().toString());
    }

    public void setGUI(NuxeoLauncherGUI gui) {
        if (guis == null) {
            guis = new HashMap<String, NuxeoLauncherGUI>();
        }
        guis.put(this.configurationGenerator.getNuxeoConf().toString(), gui);
    }

    public NuxeoLauncher(ConfigurationGenerator configurationGenerator) {
        this.configurationGenerator = configurationGenerator;
        this.processManager = this.getOSProcessManager();
        this.processRegex = Pattern.quote(configurationGenerator.getNuxeoConf().getPath()) + ".*" + Pattern.quote(this.getServerPrint());
        if (PlatformUtils.isMac()) {
            System.setProperty("com.apple.mrj.application.apple.menu.about.name", "NuxeoCtl");
        }
    }

    private ProcessManager getOSProcessManager() {
        if (PlatformUtils.isLinux()) {
            UnixProcessManager unixProcessManager = new UnixProcessManager();
            return unixProcessManager;
        }
        if (PlatformUtils.isMac()) {
            return new MacProcessManager();
        }
        if (PlatformUtils.isWindows()) {
            WindowsProcessManager windowsProcessManager = new WindowsProcessManager();
            return windowsProcessManager.isUsable() ? windowsProcessManager : new PureJavaProcessManager();
        }
        return new PureJavaProcessManager();
    }

    protected void start(boolean logProcessOutput) throws IOException, InterruptedException {
        ArrayList<String> startCommand = new ArrayList<String>();
        startCommand.add(this.getJavaExecutable().getPath());
        startCommand.addAll(Arrays.asList(this.getJavaOptsProperty().split(" ")));
        startCommand.add("-cp");
        startCommand.add(this.getClassPath());
        startCommand.addAll(this.getNuxeoProperties());
        startCommand.addAll(this.getServerProperties());
        this.setServerStartCommand(startCommand);
        for (String param : this.params) {
            startCommand.add(param);
        }
        ProcessBuilder pb = new ProcessBuilder(this.getOSCommand(startCommand));
        pb.directory(this.configurationGenerator.getNuxeoHome());
        log.debug((Object)("Server command: " + pb.command()));
        this.nuxeoProcess = pb.start();
        this.logProcessStreams(this.nuxeoProcess, logProcessOutput);
        Thread.sleep(1000L);
        if (this.getPid() != null) {
            log.info((Object)("Server started with process ID " + this.pid + "."));
        } else {
            log.info((Object)"Sent server start command but could not get process ID.");
        }
    }

    protected String getJavaOptsProperty() {
        String[] properties;
        String ret = System.getProperty(JAVA_OPTS_PROPERTY, JAVA_OPTS_DEFAULT);
        for (String property : properties = new String[]{"nuxeo.home.dir", "nuxeo.log.dir", "nuxeo.data.dir", "nuxeo.tmp.dir"}) {
            String value = this.configurationGenerator.getUserConfig().getProperty(property);
            if (value == null || value.isEmpty()) continue;
            ret = ret.replace("${" + property + "}", value);
        }
        return ret;
    }

    public void checkNoRunningServer() throws IllegalStateException {
        try {
            String existingPid = this.getPid();
            if (existingPid != null) {
                this.errorValue = 0;
                throw new IllegalStateException("A server is already running with process ID " + existingPid);
            }
        }
        catch (IOException e) {
            log.warn((Object)("Could not check existing process" + e.getMessage()));
        }
    }

    public void logProcessStreams(Process process, boolean logProcessOutput) {
        new ThreadedStreamGobbler(process.getInputStream(), logProcessOutput ? 3 : 7).start();
        new ThreadedStreamGobbler(process.getErrorStream(), logProcessOutput ? 5 : 7).start();
    }

    protected abstract String getServerPrint();

    private List<String> getOSCommand(List<String> roughCommand) {
        String linearizedCommand = new String();
        ArrayList<String> osCommand = new ArrayList<String>();
        if (PlatformUtils.isLinux() || PlatformUtils.isMac()) {
            for (String commandToken : roughCommand) {
                if (commandToken.contains(" ")) {
                    commandToken = commandToken.replaceAll(" ", "\\\\ ");
                }
                linearizedCommand = linearizedCommand + " " + commandToken;
            }
            osCommand.add("/bin/sh");
            osCommand.add("-c");
            osCommand.add(linearizedCommand);
            return osCommand;
        }
        if (PlatformUtils.isWindows()) {
            return roughCommand;
        }
        return roughCommand;
    }

    protected abstract Collection<? extends String> getServerProperties();

    protected abstract void setServerStartCommand(List<String> var1);

    private File getJavaExecutable() {
        File javaExec = new File(System.getProperty("java.home"), "bin" + File.separator + "java");
        return javaExec;
    }

    protected abstract String getClassPath();

    protected Collection<? extends String> getNuxeoProperties() {
        ArrayList<String> nuxeoProperties = new ArrayList<String>();
        nuxeoProperties.add("-Dnuxeo.home=" + this.configurationGenerator.getNuxeoHome().getPath());
        nuxeoProperties.add("-Dnuxeo.conf=" + this.configurationGenerator.getNuxeoConf().getPath());
        nuxeoProperties.add(this.getNuxeoProperty("nuxeo.log.dir"));
        nuxeoProperties.add(this.getNuxeoProperty("nuxeo.data.dir"));
        nuxeoProperties.add(this.getNuxeoProperty("nuxeo.tmp.dir"));
        if (this.overrideJavaTmpDir) {
            nuxeoProperties.add("-Djava.io.tmpdir=" + this.configurationGenerator.getUserConfig().getProperty("nuxeo.tmp.dir"));
        }
        return nuxeoProperties;
    }

    private String getNuxeoProperty(String property) {
        return "-D" + property + "=" + this.configurationGenerator.getUserConfig().getProperty(property);
    }

    protected String addToClassPath(String cp, String filename) {
        File classPathEntry = new File(this.configurationGenerator.getNuxeoHome(), filename);
        if (!classPathEntry.exists()) {
            throw new RuntimeException("Tried to add inexistent classpath entry: " + classPathEntry);
        }
        cp = cp + System.getProperty("path.separator") + classPathEntry.getPath();
        return cp;
    }

    public static void main(String[] args) throws ConfigurationException {
        NuxeoLauncher launcher = NuxeoLauncher.createLauncher(args);
        if (launcher.useGui && launcher.getGUI() == null) {
            launcher.setGUI(new NuxeoLauncherGUI(launcher));
        }
        NuxeoLauncher.launch(launcher);
    }

    public static void launch(final NuxeoLauncher launcher) {
        int exitStatus = 0;
        boolean commandSucceeded = true;
        if (launcher.command != null) {
            if ("help".equalsIgnoreCase(launcher.command)) {
                NuxeoLauncher.printHelp();
            } else if ("status".equalsIgnoreCase(launcher.command)) {
                log.info((Object)launcher.status());
                if (launcher.isStarted()) {
                    log.info((Object)launcher.getStartupSummary());
                }
                exitStatus = launcher.status;
            } else if ("startbg".equalsIgnoreCase(launcher.command)) {
                commandSucceeded = launcher.doStart();
            } else if ("start".equalsIgnoreCase(launcher.command)) {
                if (launcher.useGui) {
                    launcher.getGUI().start();
                } else {
                    commandSucceeded = launcher.doStartAndWait();
                }
            } else if ("console".equalsIgnoreCase(launcher.command)) {
                launcher.executor.execute(new Runnable(){

                    @Override
                    public void run() {
                        launcher.addShutdownHook();
                        if (!launcher.doStart(true)) {
                            launcher.removeShutdownHook();
                            System.exit(1);
                        }
                    }
                });
            } else if ("stop".equalsIgnoreCase(launcher.command)) {
                if (launcher.useGui) {
                    launcher.getGUI().stop();
                } else {
                    launcher.stop();
                }
            } else if ("restartbg".equalsIgnoreCase(launcher.command)) {
                launcher.stop();
                commandSucceeded = launcher.doStart();
            } else if ("restart".equalsIgnoreCase(launcher.command)) {
                launcher.stop();
                commandSucceeded = launcher.doStartAndWait();
            } else if ("wizard".equalsIgnoreCase(launcher.command)) {
                commandSucceeded = launcher.startWizard();
            } else if ("configure".equalsIgnoreCase(launcher.command)) {
                try {
                    launcher.configure();
                }
                catch (ConfigurationException e) {
                    log.error((Object)e);
                    commandSucceeded = false;
                }
            } else if ("pack".equalsIgnoreCase(launcher.command)) {
                exitStatus = 3;
            } else {
                NuxeoLauncher.printHelp();
                commandSucceeded = false;
            }
        }
        if (!commandSucceeded) {
            exitStatus = launcher.errorValue;
        }
        if (exitStatus != 0) {
            System.exit(exitStatus);
        }
    }

    private boolean startWizard() {
        if (!this.configurationGenerator.getServerConfigurator().isWizardAvailable()) {
            log.error((Object)"Sorry, the wizard is not available within that server.");
            return false;
        }
        if (this.isRunning()) {
            log.error((Object)"Server already running. Please stop it before calling \"wizard\" command or use the Admin Center instead of the wizard.");
            return false;
        }
        if (this.reloadConfiguration) {
            this.configurationGenerator = new ConfigurationGenerator();
            this.configurationGenerator.init();
            this.reloadConfiguration = false;
        }
        this.configurationGenerator.getUserConfig().setProperty("nuxeo.wizard.done", "false");
        return this.doStart();
    }

    public boolean doStartAndWait() {
        return this.doStartAndWait(false);
    }

    public void stop() {
        this.stop(false);
    }

    public boolean doStart() {
        return this.doStart(false);
    }

    public boolean doStartAndWait(boolean logProcessOutput) {
        boolean commandSucceeded = false;
        if (this.doStart(logProcessOutput)) {
            this.addShutdownHook();
            if (!this.configurationGenerator.isWizardRequired() && !this.waitForEffectiveStart()) {
                this.removeShutdownHook();
                this.stop(logProcessOutput);
            } else {
                this.removeShutdownHook();
                commandSucceeded = true;
            }
        }
        return commandSucceeded;
    }

    protected void removeShutdownHook() {
        log.debug((Object)"Remove shutdown hook");
        try {
            Runtime.getRuntime().removeShutdownHook(this.shutdownHook);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    protected boolean waitForEffectiveStart() {
        long startTime = new Date().getTime();
        int startMaxWait = Integer.parseInt(this.configurationGenerator.getUserConfig().getProperty(START_MAX_WAIT_PARAM, this.getDefaultMaxWait()));
        log.debug((Object)("Will wait for effective start during " + startMaxWait + " seconds."));
        StringBuilder startSummary = new StringBuilder();
        String newLine = System.getProperty("line.separator");
        boolean isReady = false;
        int count = 0;
        do {
            try {
                isReady = this.statusServletClient.init();
            }
            catch (SocketTimeoutException e) {
                if (!this.quiet) {
                    System.out.print(".");
                }
                ++count;
            }
        } while (!isReady && count < startMaxWait && this.isRunning());
        isReady = false;
        do {
            isReady = this.isStarted();
            if (this.quiet) continue;
            System.out.print(".");
        } while (!isReady && ++count < startMaxWait && this.isRunning());
        if (isReady) {
            startSummary.append(newLine + this.getStartupSummary());
            long duration = (new Date().getTime() - startTime) / 1000L;
            startSummary.append("Started in " + String.format("%dmin%02ds", new Long(duration / 60L), new Long(duration % 60L)));
            if (this.wasStartupFine()) {
                if (!this.quiet) {
                    System.out.println(startSummary);
                }
            } else {
                System.err.println(startSummary);
            }
            return true;
        }
        if (count == startMaxWait) {
            if (!this.quiet) {
                System.out.println();
            }
            log.error((Object)"Starting process is taking too long - giving up.");
        }
        return false;
    }

    public boolean wasStartupFine() {
        return this.statusServletClient.isStartupFine();
    }

    public String getStartupSummary() {
        try {
            return this.statusServletClient.getStartupSummary();
        }
        catch (SocketTimeoutException e) {
            log.warn((Object)"Failed to contact Nuxeo for getting startup summary", (Throwable)e);
            return "";
        }
    }

    public boolean doStart(boolean logProcessOutput) {
        this.errorValue = 0;
        boolean serverStarted = false;
        try {
            if (this.reloadConfiguration) {
                this.configurationGenerator = new ConfigurationGenerator();
                this.configurationGenerator.init();
            } else {
                this.reloadConfiguration = true;
            }
            this.checkNoRunningServer();
            this.configure();
            if (this.configurationGenerator.isWizardRequired()) {
                if (!this.configurationGenerator.isForceGeneration()) {
                    log.error((Object)"Cannot start setup wizard with nuxeo.force.generation=false. Either set it to true or once, either set nuxeo.wizard.done=true to skip the wizard.");
                    this.errorValue = 6;
                    return false;
                }
                String paramsStr = "";
                for (String param : this.params) {
                    paramsStr = paramsStr + " " + param;
                }
                System.setProperty("wizard.restart.params", paramsStr);
                this.configurationGenerator.prepareWizardStart();
            } else {
                this.configurationGenerator.cleanupPostWizard();
            }
            log.debug((Object)"Check if install in progress...");
            if ((PlatformUtils.isWindows() || "true".equalsIgnoreCase(this.configurationGenerator.getUserConfig().getProperty("org.nuxeo.fake.vindoz", "false"))) && this.configurationGenerator.isInstallInProgress()) {
                log.debug((Object)"Install in progress...");
                this.install();
            }
            this.start(logProcessOutput);
            serverStarted = this.isRunning();
            if (this.pid != null) {
                File pidFile = new File(this.configurationGenerator.getPidDir(), "nuxeo.pid");
                FileWriter writer = new FileWriter(pidFile);
                writer.write(this.pid);
                writer.close();
            }
        }
        catch (ConfigurationException e) {
            this.errorValue = 6;
            log.error((Object)"Could not run configuration", (Throwable)e);
        }
        catch (IOException e) {
            this.errorValue = 1;
            log.error((Object)"Could not start process", (Throwable)e);
        }
        catch (InterruptedException e) {
            this.errorValue = 1;
            log.error((Object)"Could not start process", (Throwable)e);
        }
        catch (IllegalStateException e) {
            log.error((Object)e.getMessage());
        }
        return serverStarted;
    }

    private void install() throws IOException, InterruptedException {
        ArrayList<String> startCommand = new ArrayList<String>();
        startCommand.add(this.getJavaExecutable().getPath());
        startCommand.addAll(Arrays.asList(this.getJavaOptsProperty().split(" ")));
        startCommand.add("-cp");
        File tmpDir = File.createTempFile("install", null);
        startCommand.add(this.getInstallClassPath(tmpDir));
        startCommand.addAll(this.getNuxeoProperties());
        startCommand.add("-Dnuxeo.runtime.home=" + this.configurationGenerator.getRuntimeHome().getPath());
        startCommand.add(INSTALLER_CLASS);
        startCommand.add(tmpDir.getPath());
        startCommand.add(this.configurationGenerator.getInstallFile().getPath());
        ProcessBuilder pb = new ProcessBuilder(this.getOSCommand(startCommand));
        pb.directory(this.configurationGenerator.getNuxeoHome());
        log.debug((Object)("Install command: " + pb.command()));
        Process installProcess = pb.start();
        this.logProcessStreams(installProcess, false);
        Thread.sleep(1000L);
        installProcess.waitFor();
    }

    private String getInstallClassPath(File tmpDir) throws IOException {
        String cp = ".";
        tmpDir.delete();
        tmpDir.mkdirs();
        File baseDir = new File(this.configurationGenerator.getRuntimeHome(), "bundles");
        String[] filenames = new String[]{"nuxeo-runtime-osgi", "nuxeo-runtime", "nuxeo-common", "nuxeo-connect-update", "nuxeo-connect-client", "nuxeo-connect-offline-update", "nuxeo-connect-client-wrapper", "nuxeo-runtime-reload"};
        cp = this.getTempClassPath(tmpDir, cp, baseDir, filenames);
        baseDir = this.configurationGenerator.getServerConfigurator().getNuxeoLibDir();
        filenames = new String[]{"commons-io", "groovy-all", "osgi-core", "xercesImpl"};
        cp = this.getTempClassPath(tmpDir, cp, baseDir, filenames);
        baseDir = this.configurationGenerator.getServerConfigurator().getServerLibDir();
        filenames = new String[]{"commons-logging", "log4j"};
        cp = this.getTempClassPath(tmpDir, cp, baseDir, filenames);
        return cp;
    }

    private String getTempClassPath(File tmpDir, String classpath, File baseDir, String[] filenames) throws IOException {
        File targetDir = new File(tmpDir, baseDir.getName());
        targetDir.mkdirs();
        for (final String filePattern : filenames) {
            File[] files = baseDir.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File basedir, String filename) {
                    return filename.matches(filePattern + "-[0-9].*\\.jar");
                }
            });
            FileUtils.copyFileToDirectory((File)files[0], (File)targetDir);
            File classPathEntry = new File(targetDir, files[0].getName());
            classpath = classpath + System.getProperty("path.separator") + classPathEntry.getPath();
        }
        return classpath;
    }

    protected void addShutdownHook() {
        log.debug((Object)"Add shutdown hook");
        this.shutdownHook = new ShutdownThread(this);
        Runtime.getRuntime().addShutdownHook(this.shutdownHook);
    }

    public void stop(boolean logProcessOutput) {
        try {
            if (!(this.processManager instanceof PureJavaProcessManager) && this.getPid() == null) {
                log.info((Object)"Server is not running.");
                return;
            }
            if (!this.quiet) {
                System.out.print("Stopping server...");
            }
            int nbTry = 0;
            boolean retry = false;
            do {
                ArrayList<String> stopCommand = new ArrayList<String>();
                stopCommand.add(this.getJavaExecutable().getPath());
                stopCommand.add("-cp");
                stopCommand.add(this.getClassPath());
                stopCommand.addAll(this.getNuxeoProperties());
                stopCommand.addAll(this.getServerProperties());
                this.setServerStopCommand(stopCommand);
                for (String param : this.params) {
                    stopCommand.add(param);
                }
                ProcessBuilder pb = new ProcessBuilder(this.getOSCommand(stopCommand));
                pb.directory(this.configurationGenerator.getNuxeoHome());
                log.debug((Object)("Server command: " + pb.command()));
                try {
                    Process stopProcess = pb.start();
                    this.logProcessStreams(stopProcess, logProcessOutput);
                    stopProcess.waitFor();
                    boolean wait = true;
                    while (wait) {
                        try {
                            if (stopProcess.exitValue() == 0) {
                                retry = false;
                            } else {
                                boolean bl = retry = ++nbTry < 5;
                                if (!this.quiet) {
                                    System.out.print(".");
                                }
                                Thread.sleep(2000L);
                            }
                            wait = false;
                        }
                        catch (IllegalThreadStateException e) {
                            wait = true;
                            if (!this.quiet) {
                                System.out.print(".");
                            }
                            Thread.sleep(1000L);
                        }
                    }
                    if (this.processManager instanceof PureJavaProcessManager) {
                        log.info((Object)"Can't check server status on your OS.");
                        return;
                    }
                    for (int i = 0; !retry && this.getPid() != null && i < 10; ++i) {
                        if (!this.quiet) {
                            System.out.print(".");
                        }
                        Thread.sleep(1000L);
                    }
                }
                catch (InterruptedException e) {
                    log.error((Object)e);
                }
            } while (retry);
            if (this.getPid() == null) {
                log.info((Object)"Server stopped.");
            } else {
                log.info((Object)("No answer from server, try to kill process " + this.pid + "..."));
                this.processManager.kill(this.nuxeoProcess, this.pid);
                if (this.getPid() == null) {
                    log.info((Object)"Server forcibly stopped.");
                }
            }
        }
        catch (IOException e) {
            log.error((Object)"Could not manage process!", (Throwable)e);
        }
    }

    protected abstract void setServerStopCommand(List<String> var1);

    private String getPid() throws IOException {
        this.pid = this.processManager.findPid(this.processRegex);
        log.debug((Object)("regexp: " + this.processRegex + " pid:" + this.pid));
        return this.pid;
    }

    public void configure() throws ConfigurationException {
        this.configurationGenerator.verifyInstallation();
        this.configurationGenerator.run();
        this.overrideJavaTmpDir = Boolean.parseBoolean(this.configurationGenerator.getUserConfig().getProperty(OVERRIDE_JAVA_TMPDIR_PARAM, "true"));
    }

    private String getDefaultMaxWait() {
        return this.configurationGenerator.isJBoss ? START_MAX_WAIT_JBOSS_DEFAULT : START_MAX_WAIT_DEFAULT;
    }

    public String status() {
        if (this.processManager instanceof PureJavaProcessManager) {
            this.status = 4;
            return "Can't check server status on your OS.";
        }
        try {
            if (this.getPid() == null) {
                this.status = 3;
                return "Server is not running.";
            }
            this.status = 0;
            return "Server is running with process ID " + this.getPid() + ".";
        }
        catch (IOException e) {
            this.status = 4;
            return "Could not check existing process (" + e.getMessage() + ").";
        }
    }

    public int getStatus() {
        return this.status;
    }

    public int getErrorValue() {
        return this.errorValue;
    }

    public static NuxeoLauncher createLauncher(String[] args) throws ConfigurationException {
        NuxeoLauncher launcher;
        ConfigurationGenerator configurationGenerator = new ConfigurationGenerator();
        if (configurationGenerator.isJBoss) {
            launcher = new NuxeoJBossLauncher(configurationGenerator);
        } else if (configurationGenerator.isJetty) {
            launcher = new NuxeoJettyLauncher(configurationGenerator);
        } else if (configurationGenerator.isTomcat) {
            launcher = new NuxeoTomcatLauncher(configurationGenerator);
        } else {
            throw new ConfigurationException("Unknown server !");
        }
        super.setArgs(args);
        configurationGenerator.init();
        launcher.statusServletClient = new StatusServletClient(configurationGenerator);
        return launcher;
    }

    private void setArgs(String[] args) {
        if ((args = this.readOptions(args)).length == 0) {
            NuxeoLauncher.printHelp();
            System.exit(2);
        }
        this.command = args[0];
        int firstParamToKeep = 1;
        if ("gui".equalsIgnoreCase(this.command) || "nogui".equalsIgnoreCase(this.command)) {
            this.useGui = "gui".equalsIgnoreCase(this.command);
            this.command = args.length > 1 ? args[1] : null;
            firstParamToKeep = 2;
        }
        this.params = firstParamToKeep > args.length ? new String[]{} : Arrays.copyOfRange(args, firstParamToKeep, args.length);
    }

    protected String[] readOptions(String[] args) {
        int nbOptions = 0;
        for (String arg : args) {
            if (!arg.startsWith("-") && !arg.startsWith("--")) break;
            ++nbOptions;
            if ("-d".equalsIgnoreCase(arg) || "--debug".equalsIgnoreCase(arg)) {
                this.setDebug(true);
                continue;
            }
            if ("-q".equalsIgnoreCase(arg) || "--quiet".equalsIgnoreCase(arg)) {
                this.setQuiet();
                continue;
            }
            log.error((Object)("Unknown option " + arg));
        }
        return Arrays.copyOfRange(args, nbOptions, args.length);
    }

    protected void setQuiet() {
        this.quiet = true;
        Log4JHelper.setQuiet((String)"CONSOLE");
    }

    protected void setDebug(boolean activateDebug) {
        Log4JHelper.setDebug((String)"org.nuxeo.launcher", (boolean)activateDebug);
    }

    public static void printHelp() {
        log.error((Object)"\nnuxeoctl usage:\n\tnuxeoctl [options] [gui|nogui] [help|start|stop|restart|configure|wizard|console|status|startbg|restartbg|pack] [additional parameters]");
        log.error((Object)"\njava usage:\n\tjava [-Dlauncher.java.opts=\"JVM options\"] [-Dnuxeo.home=\"/path/to/nuxeo\"] [-Dnuxeo.conf=\"/path/to/nuxeo.conf\"] [-Djvmcheck=nofail] -jar \"path/to/nuxeo-launcher.jar\" \\ \n\t\t[options] [gui] [help|start|stop|restart|configure|wizard|console|status|startbg|restartbg|pack] [additional parameters]");
        log.error((Object)"\n\t Java parameters:");
        log.error((Object)"\t\t launcher.java.opts\tParameters for the server JVM (default are -Xms512m -Xmx1024m -XX:MaxPermSize=512m).");
        log.error((Object)"\t\t nuxeo.home\t\tNuxeo server root path (default is parent of called script).");
        log.error((Object)"\t\t nuxeo.conf\t\tPath to nuxeo.conf file (default is $NUXEO_HOME/bin/nuxeo.conf).");
        log.error((Object)"\t\t jvmcheck\t\tWill continue execution if equals to \"nofail\", else will exit.");
        log.error((Object)"\n\t Options:");
        log.error((Object)"\t\t -d, --debug\t\tActivate Launcher DEBUG logs.");
        log.error((Object)"\t\t -q, --quiet\t\tActivate quiet mode.");
        log.error((Object)"\n\t GUI options:");
        log.error((Object)"\t\t gui\t\t\tLauncher with a graphical user interface (default is headless/console mode except under Windows).");
        log.error((Object)"\t\t nogui\t\t\tDeactivate gui option which is set by default under Windows.");
        log.error((Object)"\n\t Commands:");
        log.error((Object)"\t\t help\t\t\tPrint this message.");
        log.error((Object)"\t\t start\t\t\tStart Nuxeo server in background, waiting for effective start. Useful for batch executions requiring the server being immediately available after the script returned.");
        log.error((Object)"\t\t stop\t\t\tStop any Nuxeo server started with the same nuxeo.conf file.");
        log.error((Object)"\t\t restart\t\tRestart Nuxeo server.");
        log.error((Object)"\t\t configure\t\tConfigure Nuxeo server with parameters from nuxeo.conf.");
        log.error((Object)"\t\t wizard\t\t\tEnable the wizard (force the wizard to be played again in case the wizard configuration has already been done).");
        log.error((Object)"\t\t console\t\tStart Nuxeo server in a console mode. Ctrl-C will stop it.");
        log.error((Object)"\t\t status\t\t\tPrint server status (running or not).");
        log.error((Object)"\t\t startbg\t\tStart Nuxeo server in background, without waiting for effective start. Useful for starting Nuxeo as a service.");
        log.error((Object)"\t\t restartbg\t\tRestart Nuxeo server with a call to \"startbg\" after \"stop\".");
        log.error((Object)"\t\t pack\t\t\tNot implemented. Use \"pack\" Shell script.");
        log.error((Object)"\n\t Additional parameters: All parameters following a command are passed to the java process when executing the command.");
    }

    public boolean isRunning() {
        if (this.nuxeoProcess != null) {
            try {
                this.nuxeoProcess.exitValue();
                this.nuxeoProcess = null;
            }
            catch (IllegalThreadStateException exception) {
                return true;
            }
        }
        try {
            return this.getPid() != null;
        }
        catch (IOException e) {
            log.error((Object)e);
            return false;
        }
    }

    public boolean isStarted() {
        boolean isStarted;
        if (this.configurationGenerator.isWizardRequired()) {
            isStarted = this.isRunning();
        } else {
            try {
                isStarted = this.isRunning() && this.statusServletClient.isStarted();
            }
            catch (SocketTimeoutException e) {
                isStarted = false;
            }
        }
        return isStarted;
    }

    public File getLogFile() {
        return new File(this.configurationGenerator.getLogDir(), "server.log");
    }

    public String getURL() {
        return this.configurationGenerator.getUserConfig().getProperty(PARAM_NUXEO_URL);
    }

    protected class ShutdownThread
    extends Thread {
        private NuxeoLauncher launcher;

        public ShutdownThread(NuxeoLauncher launcher) {
            this.launcher = launcher;
        }

        @Override
        public void run() {
            log.debug((Object)"Shutting down...");
            this.launcher.stop();
            log.debug((Object)"Shutdown complete.");
        }
    }
}

