/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.launcher.monitoring;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.SocketTimeoutException;
import java.net.URL;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.launcher.config.ConfigurationGenerator;

public class StatusServletClient {
    private static final Log log = LogFactory.getLog(StatusServletClient.class);
    protected static final String URL_PATTERN = "runningstatus";
    protected static final String POST_PARAM = "info";
    protected static final String POST_PARAM_STARTED = "started";
    protected static final String POST_PARAM_SUMMARY = "summary";
    private static final int TIMEOUT = 1000;
    private static final int SUMMARY_TIMEOUT = 2000;
    private URL url;
    private HttpURLConnection server;
    private int timeout;
    private boolean startupFine = false;
    private String key;

    public void setKey(String key) {
        this.key = key;
    }

    public StatusServletClient(ConfigurationGenerator configurationGenerator) {
        String servletURL = configurationGenerator.getUserConfig().getProperty("nuxeo.loopback.url") + "/" + URL_PATTERN;
        try {
            this.url = new URL(servletURL);
        }
        catch (MalformedURLException e) {
            log.error((Object)("Malformed URL: " + servletURL), (Throwable)e);
        }
    }

    public boolean isStarted() throws SocketTimeoutException {
        this.timeout = 1000;
        return this.post(POST_PARAM, POST_PARAM_STARTED);
    }

    private boolean post(String postParam, String postParamStarted) throws SocketTimeoutException {
        return this.post(postParam, postParamStarted, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean init() throws SocketTimeoutException {
        try {
            this.timeout = 1000;
            this.connect("GET");
        }
        catch (SocketTimeoutException e) {
            throw e;
        }
        catch (IOException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            this.disconnect();
        }
        return true;
    }

    protected synchronized void disconnect() {
        if (this.server != null) {
            this.server.disconnect();
            this.server = null;
        }
        this.notifyAll();
    }

    protected synchronized void connect(String method) throws IOException {
        while (this.server != null) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        this.server = (HttpURLConnection)this.url.openConnection();
        this.server.setConnectTimeout(this.timeout);
        this.server.setReadTimeout(this.timeout);
        this.server.setDoInput(true);
        this.server.setDoOutput(true);
        this.server.setRequestMethod(method);
        this.server.setRequestProperty("Content-type", "application/x-www-form-urlencoded");
        this.server.connect();
    }

    public String getStartupSummary() throws SocketTimeoutException {
        this.timeout = 2000;
        StringBuilder sb = new StringBuilder();
        this.startupFine = this.post(POST_PARAM, POST_PARAM_SUMMARY, sb);
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean post(String param, String value, StringBuilder response) throws SocketTimeoutException {
        String post = param + "=" + value;
        post = post + "&key=" + this.key;
        try {
            this.connect("POST");
            BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(this.server.getOutputStream()));
            bw.write(post, 0, post.length());
            bw.close();
            boolean bl = this.getResponse(response);
            return bl;
        }
        catch (SocketTimeoutException e) {
            throw e;
        }
        catch (IOException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            this.disconnect();
        }
    }

    protected boolean getResponse(StringBuilder response) throws IOException {
        boolean answer;
        BufferedReader s = null;
        try {
            String line;
            s = new BufferedReader(new InputStreamReader(this.server.getInputStream()));
            answer = Boolean.parseBoolean(s.readLine());
            while ((line = s.readLine()) != null) {
                if (response == null) continue;
                response.append(line + "\n");
            }
        }
        catch (IOException e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(s);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Reader)s);
        return answer;
    }

    public boolean isStartupFine() {
        return this.startupFine;
    }
}

