/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.launcher;

import java.io.File;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.MissingArgumentException;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.apache.commons.cli.UnrecognizedOptionException;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.text.StrSubstitutor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.artofsolving.jodconverter.process.MacProcessManager;
import org.artofsolving.jodconverter.process.ProcessManager;
import org.artofsolving.jodconverter.process.PureJavaProcessManager;
import org.artofsolving.jodconverter.process.UnixProcessManager;
import org.artofsolving.jodconverter.process.WindowsProcessManager;
import org.artofsolving.jodconverter.util.PlatformUtils;
import org.json.JSONException;
import org.json.XML;
import org.nuxeo.connect.identity.LogicalInstanceIdentifier;
import org.nuxeo.connect.update.LocalPackage;
import org.nuxeo.connect.update.Package;
import org.nuxeo.connect.update.PackageException;
import org.nuxeo.connect.update.PackageState;
import org.nuxeo.connect.update.Version;
import org.nuxeo.launcher.NuxeoJBossLauncher;
import org.nuxeo.launcher.NuxeoJettyLauncher;
import org.nuxeo.launcher.NuxeoTomcatLauncher;
import org.nuxeo.launcher.config.ConfigurationException;
import org.nuxeo.launcher.config.ConfigurationGenerator;
import org.nuxeo.launcher.connect.ConnectBroker;
import org.nuxeo.launcher.daemon.DaemonThreadFactory;
import org.nuxeo.launcher.gui.NuxeoLauncherGUI;
import org.nuxeo.launcher.info.CommandInfo;
import org.nuxeo.launcher.info.CommandSetInfo;
import org.nuxeo.launcher.info.ConfigurationInfo;
import org.nuxeo.launcher.info.DistributionInfo;
import org.nuxeo.launcher.info.InstanceInfo;
import org.nuxeo.launcher.info.KeyValueInfo;
import org.nuxeo.launcher.info.MessageInfo;
import org.nuxeo.launcher.info.PackageInfo;
import org.nuxeo.launcher.monitoring.StatusServletClient;
import org.nuxeo.log4j.Log4JHelper;
import org.nuxeo.log4j.ThreadedStreamGobbler;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public abstract class NuxeoLauncher {
    protected static final String OPTION_NODEPS = "nodeps";
    private static final String OPTION_NODEPS_DESC = "Ignore package dependencies and constraints.";
    protected static final String OPTION_GUI = "gui";
    private static final String OPTION_GUI_DESC = "Use graphical user interface (default depends on OS).";
    protected static final String OPTION_JSON = "json";
    private static final String OPTION_JSON_DESC = "Output JSON for mp-commands.";
    protected static final String OPTION_XML = "xml";
    private static final String OPTION_XML_DESC = "Output XML for mp-commands.";
    protected static final String OPTION_DEBUG = "debug";
    private static final String OPTION_DEBUG_DESC = "Activate debug messages. See 'category' option.";
    protected static final String OPTION_DEBUG_CATEGORY = "dc";
    private static final String OPTION_DEBUG_CATEGORY_DESC = "Comma separated root categories for 'debug' option (default: \"org.nuxeo.launcher\").";
    protected static final String OPTION_QUIET = "quiet";
    private static final String OPTION_QUIET_DESC = "Suppress information messages.";
    protected static final String OPTION_HELP = "help";
    private static final String OPTION_HELP_DESC = "Show detailed help.";
    protected static final String OPTION_RELAX = "relax";
    private static final String OPTION_RELAX_DESC = "Allow relax constraint on current platform (default: ask).";
    protected static final String OPTION_ACCEPT = "accept";
    private static final String OPTION_ACCEPT_DESC = "Accept, refuse or ask confirmation for all changes (default: ask).";
    protected static final String OPTION_SNAPSHOT = "snapshot";
    private static final String OPTION_SNAPSHOT_DESC = "Allow use of SNAPSHOT Marketplace packages.";
    protected static final String OPTION_FORCE = "force";
    private static final String OPTION_FORCE_DESC = "Force option can be used on start command to return an error if a server is already running.";
    protected static final String OPTION_HIDE_DEPRECATION = "hide-deprecation-warnings";
    protected static final String OPTION_HIDE_DEPRECATION_DESC = "Hide deprecation warnings. Not advised on production platforms.";
    private static final String DEFAULT_NUXEO_CONTEXT_PATH = "/nuxeo";
    static final Log log;
    private static Options launcherOptions;
    private static final String JAVA_OPTS_PROPERTY = "launcher.java.opts";
    private static final String JAVA_OPTS_DEFAULT = "-Xms512m -Xmx1024m -XX:MaxPermSize=512m";
    private static final String OVERRIDE_JAVA_TMPDIR_PARAM = "launcher.override.java.tmpdir";
    protected boolean overrideJavaTmpDir;
    private static final String START_MAX_WAIT_PARAM = "launcher.start.max.wait";
    private static final String STOP_MAX_WAIT_PARAM = "launcher.stop.max.wait";
    private static final String START_MAX_WAIT_DEFAULT = "300";
    private static final String START_MAX_WAIT_JBOSS_DEFAULT = "900";
    private static final String STOP_MAX_WAIT_DEFAULT = "60";
    private static final int STOP_NB_TRY = 5;
    private static final int STOP_SECONDS_BEFORE_NEXT_TRY = 2;
    private static final long STREAM_MAX_WAIT = 3000L;
    private static final String PACK_JBOSS_CLASS = "org.nuxeo.runtime.deployment.preprocessor.PackZip";
    private static final String PACK_TOMCAT_CLASS = "org.nuxeo.runtime.deployment.preprocessor.PackWar";
    private static final String PARAM_UPDATECENTER_DISABLED = "nuxeo.updatecenter.disabled";
    private static final String[] COMMANDS_NO_GUI;
    private static final String[] COMMANDS_NO_RUNNING_SERVER;
    public static final int STATUS_CODE_ON = 0;
    public static final int STATUS_CODE_OFF = 3;
    public static final int STATUS_CODE_UNKNOWN = 4;
    public static final int EXIT_CODE_OK = 0;
    public static final int EXIT_CODE_ERROR = 1;
    public static final int EXIT_CODE_INVALID = 2;
    public static final int EXIT_CODE_UNIMPLEMENTED = 3;
    public static final int EXIT_CODE_UNAUTHORIZED = 4;
    public static final int EXIT_CODE_NOT_INSTALLED = 5;
    public static final int EXIT_CODE_NOT_CONFIGURED = 6;
    public static final int EXIT_CODE_NOT_RUNNING = 7;
    protected ConfigurationGenerator configurationGenerator;
    protected ProcessManager processManager;
    protected Process nuxeoProcess;
    private String processRegex;
    protected String pid;
    private ExecutorService executor = Executors.newSingleThreadExecutor(new DaemonThreadFactory("NuxeoProcessThread", false));
    private ShutdownThread shutdownHook;
    protected static String[] params;
    protected String command;
    public CommandSetInfo cset = new CommandSetInfo();
    private boolean useGui = false;
    private boolean reloadConfiguration = false;
    private int status = 4;
    private int errorValue = 0;
    private StatusServletClient statusServletClient;
    private static boolean quiet;
    private static boolean debug;
    private static boolean force;
    private boolean xmlOutput = false;
    private boolean jsonOutput = false;
    private ConnectBroker connectBroker = null;
    private CommandLine cmdLine;
    private static Map<String, NuxeoLauncherGUI> guis;

    public final ConfigurationGenerator getConfigurationGenerator() {
        return this.configurationGenerator;
    }

    public String getCommand() {
        return this.command;
    }

    public boolean isUsingGui() {
        return this.useGui;
    }

    public boolean isQuiet() {
        return quiet;
    }

    public NuxeoLauncherGUI getGUI() {
        if (guis == null) {
            return null;
        }
        return guis.get(this.configurationGenerator.getNuxeoConf().toString());
    }

    public void setGUI(NuxeoLauncherGUI gui) {
        if (guis == null) {
            guis = new HashMap<String, NuxeoLauncherGUI>();
        }
        guis.put(this.configurationGenerator.getNuxeoConf().toString(), gui);
    }

    public NuxeoLauncher(ConfigurationGenerator configurationGenerator) {
        this.configurationGenerator = configurationGenerator;
        this.init();
    }

    public void init() {
        if (!this.configurationGenerator.init(true)) {
            throw new IllegalStateException("Initialization failed");
        }
        this.statusServletClient = new StatusServletClient(this.configurationGenerator);
        this.statusServletClient.setKey(this.configurationGenerator.getUserConfig().getProperty("server.status.key"));
        this.processManager = this.getOSProcessManager();
        this.processRegex = "^(?!/bin/sh).*" + Pattern.quote(this.configurationGenerator.getNuxeoConf().getPath()) + ".*" + Pattern.quote(this.getServerPrint()) + ".*$";
        if (PlatformUtils.isMac()) {
            System.setProperty("com.apple.mrj.application.apple.menu.about.name", "NuxeoCtl");
        }
    }

    private ProcessManager getOSProcessManager() {
        if (PlatformUtils.isLinux() || this.isAix()) {
            UnixProcessManager unixProcessManager = new UnixProcessManager();
            return unixProcessManager;
        }
        if (PlatformUtils.isMac()) {
            return new MacProcessManager();
        }
        if (this.isSolaris()) {
            return new SolarisProcessManager();
        }
        if (PlatformUtils.isWindows()) {
            WindowsProcessManager windowsProcessManager = new WindowsProcessManager();
            return windowsProcessManager.isUsable() ? windowsProcessManager : new PureJavaProcessManager();
        }
        return new PureJavaProcessManager();
    }

    private boolean isAix() {
        return System.getProperty("os.name").toLowerCase().startsWith("aix");
    }

    private boolean isSolaris() {
        return System.getProperty("os.name").toLowerCase().startsWith("sunos");
    }

    protected void start(boolean logProcessOutput) throws IOException, InterruptedException {
        ArrayList<String> startCommand = new ArrayList<String>();
        startCommand.add(this.getJavaExecutable().getPath());
        startCommand.addAll(Arrays.asList(this.getJavaOptsProperty().split(" ")));
        startCommand.add("-cp");
        startCommand.add(this.getClassPath());
        startCommand.addAll(this.getNuxeoProperties());
        startCommand.addAll(this.getServerProperties());
        this.setServerStartCommand(startCommand);
        for (String param : params) {
            startCommand.add(param);
        }
        ProcessBuilder pb = new ProcessBuilder(this.getOSCommand(startCommand));
        pb.directory(this.configurationGenerator.getNuxeoHome());
        log.debug((Object)("Server command: " + pb.command()));
        this.nuxeoProcess = pb.start();
        Thread.sleep(1000L);
        boolean processExited = false;
        try {
            int exitValue = this.nuxeoProcess.exitValue();
            if (exitValue != 0) {
                log.error((Object)String.format("Server start failed (%d).", exitValue));
            }
            processExited = true;
        }
        catch (IllegalThreadStateException e) {
            // empty catch block
        }
        this.logProcessStreams(this.nuxeoProcess, processExited || logProcessOutput);
        if (!processExited) {
            if (this.getPid() != null) {
                log.warn((Object)("Server started with process ID " + this.pid + "."));
            } else {
                log.warn((Object)"Sent server start command but could not get process ID.");
            }
        }
    }

    protected String getJavaOptsProperty() {
        String ret = System.getProperty(JAVA_OPTS_PROPERTY, JAVA_OPTS_DEFAULT);
        ret = StrSubstitutor.replace((Object)ret, (Properties)this.configurationGenerator.getUserConfig());
        return ret;
    }

    public void checkNoRunningServer() throws IllegalStateException {
        try {
            String existingPid = this.getPid();
            if (existingPid != null) {
                this.errorValue = 0;
                throw new IllegalStateException("A server is running with process ID " + existingPid);
            }
        }
        catch (IOException e) {
            log.warn((Object)("Could not check existing process: " + e.getMessage()));
        }
    }

    public ArrayList<ThreadedStreamGobbler> logProcessStreams(Process process, boolean logProcessOutput) {
        ThreadedStreamGobbler errorSG;
        ThreadedStreamGobbler inputSG;
        ArrayList<ThreadedStreamGobbler> sgArray = new ArrayList<ThreadedStreamGobbler>();
        if (logProcessOutput) {
            inputSG = new ThreadedStreamGobbler(process.getInputStream(), (OutputStream)System.out);
            errorSG = new ThreadedStreamGobbler(process.getErrorStream(), (OutputStream)System.err);
        } else {
            inputSG = new ThreadedStreamGobbler(process.getInputStream(), 7);
            errorSG = new ThreadedStreamGobbler(process.getErrorStream(), 7);
        }
        inputSG.start();
        errorSG.start();
        sgArray.add(inputSG);
        sgArray.add(errorSG);
        return sgArray;
    }

    protected abstract String getServerPrint();

    private List<String> getOSCommand(List<String> roughCommand) {
        String linearizedCommand = new String();
        ArrayList<String> osCommand = new ArrayList<String>();
        if (PlatformUtils.isLinux() || PlatformUtils.isMac()) {
            for (String commandToken : roughCommand) {
                if (commandToken.contains(" ")) {
                    commandToken = commandToken.replaceAll(" ", "\\\\ ");
                }
                linearizedCommand = linearizedCommand + " " + commandToken;
            }
            osCommand.add("/bin/sh");
            osCommand.add("-c");
            osCommand.add(linearizedCommand);
            return osCommand;
        }
        if (PlatformUtils.isWindows()) {
            return roughCommand;
        }
        return roughCommand;
    }

    protected abstract Collection<? extends String> getServerProperties();

    protected abstract void setServerStartCommand(List<String> var1);

    private File getJavaExecutable() {
        File javaExec = new File(System.getProperty("java.home"), "bin" + File.separator + "java");
        return javaExec;
    }

    protected abstract String getClassPath();

    protected abstract String getShutdownClassPath();

    protected Collection<? extends String> getNuxeoProperties() {
        ArrayList<String> nuxeoProperties = new ArrayList<String>();
        nuxeoProperties.add(String.format("-D%s=%s", "nuxeo.home", this.configurationGenerator.getNuxeoHome().getPath()));
        nuxeoProperties.add(String.format("-D%s=%s", "nuxeo.conf", this.configurationGenerator.getNuxeoConf().getPath()));
        nuxeoProperties.add(this.getNuxeoProperty("nuxeo.log.dir"));
        nuxeoProperties.add(this.getNuxeoProperty("nuxeo.data.dir"));
        nuxeoProperties.add(this.getNuxeoProperty("nuxeo.tmp.dir"));
        if (!DEFAULT_NUXEO_CONTEXT_PATH.equals(this.configurationGenerator.getUserConfig().getProperty("org.nuxeo.ecm.contextPath"))) {
            nuxeoProperties.add(this.getNuxeoProperty("org.nuxeo.ecm.contextPath"));
        }
        if (this.overrideJavaTmpDir) {
            nuxeoProperties.add("-Djava.io.tmpdir=" + this.configurationGenerator.getUserConfig().getProperty("nuxeo.tmp.dir"));
        }
        return nuxeoProperties;
    }

    private String getNuxeoProperty(String property) {
        return "-D" + property + "=" + this.configurationGenerator.getUserConfig().getProperty(property);
    }

    protected String addToClassPath(String cp, String filename) {
        File classPathEntry = new File(this.configurationGenerator.getNuxeoHome(), filename);
        if (!classPathEntry.exists()) {
            classPathEntry = new File(filename);
        }
        if (!classPathEntry.exists()) {
            throw new RuntimeException("Tried to add inexistent classpath entry: " + filename);
        }
        cp = cp + System.getProperty("path.separator") + classPathEntry.getPath();
        return cp;
    }

    protected static void initParserOptions() {
        if (launcherOptions == null) {
            launcherOptions = new Options();
            OptionBuilder.withLongOpt((String)OPTION_HELP);
            OptionBuilder.withDescription((String)OPTION_HELP_DESC);
            launcherOptions.addOption(OptionBuilder.create((String)"h"));
            OptionBuilder.withLongOpt((String)OPTION_QUIET);
            OptionBuilder.withDescription((String)OPTION_QUIET_DESC);
            launcherOptions.addOption(OptionBuilder.create((String)"q"));
            OptionBuilder.withLongOpt((String)OPTION_DEBUG);
            OptionBuilder.withDescription((String)OPTION_DEBUG_DESC);
            launcherOptions.addOption(OptionBuilder.create((String)"d"));
            OptionBuilder.withDescription((String)OPTION_DEBUG_CATEGORY_DESC);
            OptionBuilder.hasArg();
            launcherOptions.addOption(OptionBuilder.create((String)OPTION_DEBUG_CATEGORY));
            OptionGroup outputOptions = new OptionGroup();
            OptionBuilder.withLongOpt((String)OPTION_HIDE_DEPRECATION);
            OptionBuilder.withDescription((String)OPTION_HIDE_DEPRECATION_DESC);
            outputOptions.addOption(OptionBuilder.create());
            OptionBuilder.withLongOpt((String)OPTION_XML);
            OptionBuilder.withDescription((String)OPTION_XML_DESC);
            outputOptions.addOption(OptionBuilder.create());
            OptionBuilder.withLongOpt((String)OPTION_JSON);
            OptionBuilder.withDescription((String)OPTION_JSON_DESC);
            outputOptions.addOption(OptionBuilder.create());
            launcherOptions.addOptionGroup(outputOptions);
            OptionBuilder.withLongOpt((String)OPTION_GUI);
            OptionBuilder.hasArg();
            OptionBuilder.withArgName((String)"true|false");
            OptionBuilder.withDescription((String)OPTION_GUI_DESC);
            launcherOptions.addOption(OptionBuilder.create());
            OptionBuilder.withLongOpt((String)OPTION_NODEPS);
            OptionBuilder.withDescription((String)OPTION_NODEPS_DESC);
            launcherOptions.addOption(OptionBuilder.create());
            OptionBuilder.withLongOpt((String)OPTION_RELAX);
            OptionBuilder.hasArg();
            OptionBuilder.withArgName((String)"true|false|ask");
            OptionBuilder.withDescription((String)OPTION_RELAX_DESC);
            launcherOptions.addOption(OptionBuilder.create());
            OptionBuilder.withLongOpt((String)OPTION_ACCEPT);
            OptionBuilder.hasArg();
            OptionBuilder.withArgName((String)"true|false|ask");
            OptionBuilder.withDescription((String)OPTION_ACCEPT_DESC);
            launcherOptions.addOption(OptionBuilder.create());
            OptionBuilder.withLongOpt((String)OPTION_SNAPSHOT);
            OptionBuilder.withDescription((String)OPTION_SNAPSHOT_DESC);
            launcherOptions.addOption(OptionBuilder.create((String)"s"));
            OptionBuilder.withLongOpt((String)OPTION_FORCE);
            OptionBuilder.withDescription((String)OPTION_FORCE_DESC);
            launcherOptions.addOption(OptionBuilder.create((String)"f"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static CommandLine parseOptions(String[] args) throws ParseException {
        CommandLine cmdLine;
        block13: {
            NuxeoLauncher.initParserOptions();
            PosixParser parser = new PosixParser();
            cmdLine = null;
            Boolean stopAfterParsing = true;
            try {
                cmdLine = parser.parse(launcherOptions, args);
                if (cmdLine.hasOption(OPTION_HELP) || cmdLine.getArgList().contains(OPTION_HELP)) {
                    NuxeoLauncher.printLongHelp();
                } else if (cmdLine.getArgList().isEmpty()) {
                    NuxeoLauncher.printShortHelp();
                } else {
                    stopAfterParsing = false;
                }
            }
            catch (UnrecognizedOptionException e) {
                log.error((Object)e.getMessage());
                NuxeoLauncher.printShortHelp();
            }
            catch (MissingArgumentException e) {
                log.error((Object)e.getMessage());
                NuxeoLauncher.printShortHelp();
            }
            catch (ParseException e) {
                log.error((Object)("Error while parsing command line: " + e.getMessage()));
                NuxeoLauncher.printShortHelp();
            }
            finally {
                if (!stopAfterParsing.booleanValue()) break block13;
                throw new ParseException("Invalid command line");
            }
        }
        return cmdLine;
    }

    public static void main(String[] args) {
        try {
            NuxeoLauncher launcher = NuxeoLauncher.createLauncher(args);
            if (Arrays.asList(COMMANDS_NO_GUI).contains(launcher.command)) {
                launcher.useGui = false;
            }
            if (launcher.useGui && launcher.getGUI() == null) {
                launcher.setGUI(new NuxeoLauncherGUI(launcher));
            }
            NuxeoLauncher.launch(launcher);
        }
        catch (ParseException e) {
            System.exit(1);
        }
        catch (Exception e) {
            log.error((Object)("Cannot execute command. " + e.getMessage()));
            log.debug((Object)e, (Throwable)e);
            System.exit(1);
        }
    }

    public static void launch(final NuxeoLauncher launcher) throws IOException, PackageException {
        int exitStatus = 0;
        boolean commandSucceeded = true;
        if (launcher.command == null) {
            return;
        }
        if (Arrays.asList(COMMANDS_NO_RUNNING_SERVER).contains(launcher.command)) {
            launcher.checkNoRunningServer();
        }
        if ("status".equalsIgnoreCase(launcher.command)) {
            log.warn((Object)launcher.status());
            if (launcher.isStarted()) {
                log.info((Object)launcher.getStartupSummary());
            }
            exitStatus = launcher.status;
        } else if ("startbg".equalsIgnoreCase(launcher.command)) {
            commandSucceeded = launcher.doStart();
        } else if ("start".equalsIgnoreCase(launcher.command)) {
            if (launcher.useGui) {
                launcher.getGUI().start();
            } else {
                commandSucceeded = launcher.doStartAndWait();
            }
        } else if ("console".equalsIgnoreCase(launcher.command)) {
            launcher.executor.execute(new Runnable(){

                @Override
                public void run() {
                    launcher.addShutdownHook();
                    try {
                        if (!launcher.doStart(true)) {
                            launcher.removeShutdownHook();
                            System.exit(1);
                        }
                    }
                    catch (PackageException e) {
                        log.error((Object)"Could not initialize the packaging subsystem", (Throwable)e);
                        launcher.removeShutdownHook();
                        System.exit(1);
                    }
                }
            });
        } else if ("stop".equalsIgnoreCase(launcher.command)) {
            if (launcher.useGui) {
                launcher.getGUI().stop();
            } else {
                launcher.stop();
            }
        } else if ("restartbg".equalsIgnoreCase(launcher.command)) {
            launcher.stop();
            commandSucceeded = launcher.doStart();
        } else if ("restart".equalsIgnoreCase(launcher.command)) {
            launcher.stop();
            commandSucceeded = launcher.doStartAndWait();
        } else if ("wizard".equalsIgnoreCase(launcher.command)) {
            commandSucceeded = launcher.startWizard();
        } else if ("configure".equalsIgnoreCase(launcher.command)) {
            try {
                launcher.configure();
            }
            catch (ConfigurationException e) {
                commandSucceeded = false;
                launcher.errorValue = 6;
                log.error((Object)("Could not run configuration: " + e.getMessage()));
                log.debug((Object)e, (Throwable)e);
            }
        } else if ("pack".equalsIgnoreCase(launcher.command)) {
            commandSucceeded = launcher.pack();
        } else if ("mp-list".equalsIgnoreCase(launcher.command)) {
            launcher.pkgList();
        } else if ("mp-listall".equalsIgnoreCase(launcher.command)) {
            launcher.pkgListAll();
        } else if ("mp-init".equalsIgnoreCase(launcher.command)) {
            commandSucceeded = launcher.pkgInit();
        } else if ("mp-purge".equalsIgnoreCase(launcher.command)) {
            commandSucceeded = launcher.pkgPurge();
        } else if ("mp-add".equalsIgnoreCase(launcher.command)) {
            commandSucceeded = launcher.hasOption(OPTION_NODEPS) ? launcher.pkgAdd(params) : launcher.pkgRequest(Arrays.asList(params), null, null, null);
        } else if ("mp-install".equalsIgnoreCase(launcher.command)) {
            commandSucceeded = launcher.hasOption(OPTION_NODEPS) ? launcher.pkgInstall(params) : launcher.pkgRequest(null, Arrays.asList(params), null, null);
        } else if ("mp-uninstall".equalsIgnoreCase(launcher.command)) {
            commandSucceeded = launcher.hasOption(OPTION_NODEPS) ? launcher.pkgUninstall(params) : launcher.pkgRequest(null, null, Arrays.asList(params), null);
        } else if ("mp-remove".equalsIgnoreCase(launcher.command)) {
            commandSucceeded = launcher.hasOption(OPTION_NODEPS) ? launcher.pkgRemove(params) : launcher.pkgRequest(null, null, null, Arrays.asList(params));
        } else if ("mp-request".equalsIgnoreCase(launcher.command)) {
            if (launcher.hasOption(OPTION_NODEPS)) {
                log.error((Object)"This command is not available with the --nodeps option");
                commandSucceeded = false;
            } else {
                commandSucceeded = launcher.pkgCompoundRequest(Arrays.asList(params));
            }
        } else if ("mp-set".equalsIgnoreCase(launcher.command)) {
            commandSucceeded = launcher.pkgSetRequest(Arrays.asList(params), launcher.hasOption(OPTION_NODEPS));
        } else if ("mp-hotfix".equalsIgnoreCase(launcher.command)) {
            commandSucceeded = launcher.pkgHotfix();
        } else if ("mp-upgrade".equalsIgnoreCase(launcher.command)) {
            commandSucceeded = launcher.pkgUpgrade();
        } else if ("mp-reset".equalsIgnoreCase(launcher.command)) {
            commandSucceeded = launcher.pkgReset();
        } else if ("mp-update".equalsIgnoreCase(launcher.command)) {
            commandSucceeded = launcher.pkgRefreshCache();
        } else if ("showconf".equalsIgnoreCase(launcher.command)) {
            commandSucceeded = launcher.showConfig();
        } else if ("mp-show".equalsIgnoreCase(launcher.command)) {
            commandSucceeded = launcher.pkgShow(params);
        } else {
            NuxeoLauncher.printLongHelp();
            commandSucceeded = false;
        }
        if (launcher.command.startsWith("mp-")) {
            launcher.printXMLOutput();
        }
        if (!commandSucceeded) {
            if (!quiet && !debug) {
                log.error((Object)"\nSome commands failed:");
                launcher.cset.log();
            }
            exitStatus = launcher.errorValue;
        }
        if (debug) {
            log.debug((Object)"\nCommands debug dump:");
            launcher.cset.log(true);
        }
        if (exitStatus != 0) {
            System.exit(exitStatus);
        }
    }

    private boolean hasOption(String option) {
        return this.cmdLine.hasOption(option);
    }

    private boolean pack() {
        try {
            this.checkNoRunningServer();
            this.configurationGenerator.setProperty(PARAM_UPDATECENTER_DISABLED, "true");
            ArrayList<String> startCommand = new ArrayList<String>();
            startCommand.add(this.getJavaExecutable().getPath());
            startCommand.addAll(Arrays.asList(this.getJavaOptsProperty().split(" ")));
            startCommand.add("-cp");
            String classpath = this.getClassPath();
            classpath = this.addToClassPath(classpath, "bin" + File.separator + "nuxeo-launcher.jar");
            classpath = this.getClassPath(classpath, this.configurationGenerator.getServerConfigurator().getServerLibDir());
            classpath = this.getClassPath(classpath, this.configurationGenerator.getServerConfigurator().getNuxeoLibDir());
            classpath = this.getClassPath(classpath, new File(this.configurationGenerator.getRuntimeHome(), "bundles"));
            startCommand.add(classpath);
            startCommand.addAll(this.getNuxeoProperties());
            if (this.configurationGenerator.isJBoss) {
                startCommand.add(PACK_JBOSS_CLASS);
            } else if (this.configurationGenerator.isTomcat) {
                startCommand.add(PACK_TOMCAT_CLASS);
            } else {
                this.errorValue = 1;
                return false;
            }
            startCommand.add(this.configurationGenerator.getRuntimeHome().getPath());
            for (String param : params) {
                startCommand.add(param);
            }
            ProcessBuilder pb = new ProcessBuilder(this.getOSCommand(startCommand));
            pb.directory(this.configurationGenerator.getNuxeoHome());
            log.debug((Object)("Pack command: " + pb.command()));
            Process process = pb.start();
            ArrayList<ThreadedStreamGobbler> sgArray = this.logProcessStreams(process, true);
            Thread.sleep(100L);
            process.waitFor();
            this.waitForProcessStreams(sgArray);
        }
        catch (IOException e) {
            this.errorValue = 1;
            log.error((Object)"Could not start process", (Throwable)e);
        }
        catch (InterruptedException e) {
            this.errorValue = 1;
            log.error((Object)"Could not start process", (Throwable)e);
        }
        catch (IllegalStateException e) {
            this.errorValue = 1;
            log.error((Object)"The server must not be running while running pack command", (Throwable)e);
        }
        catch (ConfigurationException e) {
            this.errorValue = 1;
            log.error((Object)e);
        }
        return this.errorValue == 0;
    }

    private boolean startWizard() throws PackageException {
        if (!this.configurationGenerator.getServerConfigurator().isWizardAvailable()) {
            log.error((Object)"Sorry, the wizard is not available within that server.");
            return false;
        }
        if (this.isRunning()) {
            log.error((Object)"Server already running. Please stop it before calling \"wizard\" command or use the Admin Center instead of the wizard.");
            return false;
        }
        if (this.reloadConfiguration) {
            this.configurationGenerator = new ConfigurationGenerator(quiet, debug);
            this.configurationGenerator.init();
            this.reloadConfiguration = false;
        }
        this.configurationGenerator.getUserConfig().setProperty("nuxeo.wizard.done", "false");
        return this.doStart();
    }

    public boolean doStartAndWait() throws PackageException {
        return this.doStartAndWait(false);
    }

    public void stop() {
        this.stop(false);
    }

    public boolean doStart() throws PackageException {
        return this.doStart(false);
    }

    public boolean doStartAndWait(boolean logProcessOutput) throws PackageException {
        boolean commandSucceeded = false;
        if (this.doStart(logProcessOutput)) {
            this.addShutdownHook();
            try {
                if (this.configurationGenerator.isWizardRequired() || this.waitForEffectiveStart()) {
                    commandSucceeded = true;
                }
                this.removeShutdownHook();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return commandSucceeded;
    }

    protected void removeShutdownHook() {
        try {
            Runtime.getRuntime().removeShutdownHook(this.shutdownHook);
            log.debug((Object)"Removed shutdown hook");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    protected boolean waitForEffectiveStart() throws InterruptedException {
        long startTime = new Date().getTime();
        int startMaxWait = Integer.parseInt(this.configurationGenerator.getUserConfig().getProperty(START_MAX_WAIT_PARAM, this.getDefaultMaxWait()));
        log.debug((Object)("Will wait for effective start during " + startMaxWait + " seconds."));
        StringBuilder startSummary = new StringBuilder();
        String newLine = System.getProperty("line.separator");
        boolean isReady = false;
        long deltaTime = 0L;
        do {
            block12: {
                try {
                    isReady = this.statusServletClient.init();
                }
                catch (SocketTimeoutException e) {
                    if (quiet) break block12;
                    System.out.print(".");
                }
            }
            deltaTime = (new Date().getTime() - startTime) / 1000L;
        } while (!isReady && deltaTime < (long)startMaxWait && this.isRunning());
        isReady = false;
        do {
            if (!(isReady = this.isStarted())) {
                if (!quiet) {
                    System.out.print(".");
                }
                Thread.sleep(1000L);
            }
            deltaTime = (new Date().getTime() - startTime) / 1000L;
        } while (!isReady && deltaTime < (long)startMaxWait && this.isRunning());
        if (isReady) {
            startSummary.append(newLine + this.getStartupSummary());
            long duration = (new Date().getTime() - startTime) / 1000L;
            startSummary.append("Started in " + String.format("%dmin%02ds", new Long(duration / 60L), new Long(duration % 60L)));
            if (this.wasStartupFine()) {
                if (!quiet) {
                    System.out.println(startSummary);
                }
            } else {
                System.err.println(startSummary);
            }
            return true;
        }
        if (deltaTime >= (long)startMaxWait) {
            if (!quiet) {
                System.out.println();
            }
            log.error((Object)"Starting process is taking too long - giving up.");
        }
        this.errorValue = 1;
        return false;
    }

    public boolean wasStartupFine() {
        return this.statusServletClient.isStartupFine();
    }

    public String getStartupSummary() {
        try {
            return this.statusServletClient.getStartupSummary();
        }
        catch (SocketTimeoutException e) {
            log.warn((Object)"Failed to contact Nuxeo for getting startup summary", (Throwable)e);
            return "";
        }
    }

    public boolean doStart(boolean logProcessOutput) throws PackageException {
        this.errorValue = 0;
        boolean serverStarted = false;
        try {
            if (this.reloadConfiguration) {
                this.configurationGenerator = new ConfigurationGenerator(quiet, debug);
                this.configurationGenerator.init();
            } else {
                this.reloadConfiguration = true;
            }
            this.configure();
            this.configurationGenerator.verifyInstallation();
            if (this.configurationGenerator.isWizardRequired()) {
                if (!this.configurationGenerator.isForceGeneration()) {
                    log.error((Object)"Cannot start setup wizard with nuxeo.force.generation=false. Either set it to true or once, either set nuxeo.wizard.done=true to skip the wizard.");
                    this.errorValue = 6;
                    return false;
                }
                String paramsStr = "";
                for (String param : params) {
                    paramsStr = paramsStr + " " + param;
                }
                System.setProperty("wizard.restart.params", paramsStr);
                this.configurationGenerator.prepareWizardStart();
            } else {
                this.configurationGenerator.cleanupPostWizard();
            }
            log.debug((Object)"Check if install in progress...");
            if (this.configurationGenerator.isInstallInProgress()) {
                this.getConnectBroker().executePending(this.configurationGenerator.getInstallFile(), true, true);
                System.setProperty("nuxeo.wizard.done", this.configurationGenerator.getUserConfig().getProperty("nuxeo.wizard.done", "true"));
                return this.doStart(logProcessOutput);
            }
            this.start(logProcessOutput);
            serverStarted = this.isRunning();
            if (this.pid != null) {
                File pidFile = new File(this.configurationGenerator.getPidDir(), "nuxeo.pid");
                FileWriter writer = new FileWriter(pidFile);
                writer.write(this.pid);
                writer.close();
            }
        }
        catch (ConfigurationException e) {
            this.errorValue = 6;
            log.error((Object)("Could not run configuration: " + e.getMessage()));
            log.debug((Object)e, (Throwable)e);
        }
        catch (IOException e) {
            this.errorValue = 1;
            log.error((Object)("Could not start process: " + e.getMessage()));
            log.debug((Object)e, (Throwable)e);
        }
        catch (InterruptedException e) {
            this.errorValue = 1;
            log.error((Object)("Could not start process: " + e.getMessage()));
            log.debug((Object)e, (Throwable)e);
        }
        catch (IllegalStateException e) {
            if (force) {
                this.errorValue = 6;
            }
            log.error((Object)e.getMessage());
        }
        return serverStarted;
    }

    protected void printXMLOutput() {
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{CommandSetInfo.class, CommandInfo.class, PackageInfo.class, MessageInfo.class});
            this.printXMLOutput(jaxbContext, this.cset);
        }
        catch (JAXBException e) {
            log.error((Object)("Output serialization failed: " + e.getMessage()), (Throwable)e);
            this.errorValue = 7;
        }
    }

    protected void printXMLOutput(JAXBContext jaxbContext, Object objectToOutput) {
        if (!this.xmlOutput) {
            return;
        }
        try {
            StringWriter xml = new StringWriter();
            Marshaller marshaller = jaxbContext.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)true);
            marshaller.marshal(objectToOutput, (Writer)xml);
            if (!this.jsonOutput) {
                System.out.println(((Object)xml).toString());
            } else {
                try {
                    System.out.println(XML.toJSONObject((String)((Object)xml).toString()).toString(2));
                }
                catch (JSONException e) {
                    log.error((Object)String.format("XML to JSON conversion failed: %s\nOutput was:\n%s", e.getMessage(), ((Object)xml).toString()));
                }
            }
        }
        catch (JAXBException e) {
            log.error((Object)("Output serialization failed: " + e.getMessage()), (Throwable)e);
            this.errorValue = 7;
        }
    }

    public void waitForProcessStreams(ArrayList<ThreadedStreamGobbler> sgArray) {
        for (ThreadedStreamGobbler streamGobbler : sgArray) {
            try {
                streamGobbler.join(3000L);
            }
            catch (InterruptedException e) {
                streamGobbler.interrupt();
            }
        }
    }

    protected String getClassPath(String classpath, File baseDir) throws IOException {
        File[] files;
        for (File file : files = this.getFilename(baseDir, ".*")) {
            classpath = classpath + System.getProperty("path.separator") + file.getPath();
        }
        return classpath;
    }

    protected File[] getFilename(File baseDir, final String filePattern) {
        File[] files = baseDir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File basedir, String filename) {
                return filename.matches(filePattern + "(-[0-9].*)?\\.jar");
            }
        });
        return files;
    }

    protected void addShutdownHook() {
        log.debug((Object)"Add shutdown hook");
        this.shutdownHook = new ShutdownThread(this);
        Runtime.getRuntime().addShutdownHook(this.shutdownHook);
    }

    public void stop(boolean logProcessOutput) {
        long startTime = new Date().getTime();
        try {
            if (!this.isRunning()) {
                log.warn((Object)"Server is not running.");
                return;
            }
            if (!quiet) {
                System.out.print("\nStopping server...");
            }
            int nbTry = 0;
            boolean retry = false;
            int stopMaxWait = Integer.parseInt(this.configurationGenerator.getUserConfig().getProperty(STOP_MAX_WAIT_PARAM, STOP_MAX_WAIT_DEFAULT));
            do {
                ArrayList<String> stopCommand = new ArrayList<String>();
                stopCommand.add(this.getJavaExecutable().getPath());
                stopCommand.add("-cp");
                stopCommand.add(this.getShutdownClassPath());
                stopCommand.addAll(this.getNuxeoProperties());
                stopCommand.addAll(this.getServerProperties());
                this.setServerStopCommand(stopCommand);
                for (String param : params) {
                    stopCommand.add(param);
                }
                ProcessBuilder pb = new ProcessBuilder(this.getOSCommand(stopCommand));
                pb.directory(this.configurationGenerator.getNuxeoHome());
                log.debug((Object)("Server command: " + pb.command()));
                try {
                    Process stopProcess = pb.start();
                    ArrayList<ThreadedStreamGobbler> sgArray = this.logProcessStreams(stopProcess, logProcessOutput);
                    stopProcess.waitFor();
                    this.waitForProcessStreams(sgArray);
                    boolean wait = true;
                    while (wait) {
                        try {
                            if (stopProcess.exitValue() == 0) {
                                retry = false;
                            } else {
                                boolean bl = retry = ++nbTry < 5;
                                if (!quiet) {
                                    System.out.print(".");
                                }
                                Thread.sleep(2000L);
                            }
                            wait = false;
                        }
                        catch (IllegalThreadStateException e) {
                            wait = true;
                            if (!quiet) {
                                System.out.print(".");
                            }
                            Thread.sleep(1000L);
                        }
                    }
                    if (!this.processManager.canFindPid()) {
                        log.warn((Object)"Can't check server status on your OS.");
                        return;
                    }
                    long deltaTime = 0L;
                    do {
                        if (!quiet) {
                            System.out.print(".");
                        }
                        Thread.sleep(1000L);
                        deltaTime = (new Date().getTime() - startTime) / 1000L;
                    } while (!retry && this.getPid() != null && deltaTime < (long)stopMaxWait);
                }
                catch (InterruptedException e) {
                    log.error((Object)e);
                }
            } while (retry);
            if (this.getPid() == null) {
                log.warn((Object)"Server stopped.");
            } else {
                log.info((Object)("No answer from server, try to kill process " + this.pid + "..."));
                this.processManager.kill(this.nuxeoProcess, this.pid);
                if (this.getPid() == null) {
                    log.warn((Object)"Server forcibly stopped.");
                }
            }
        }
        catch (IOException e) {
            log.error((Object)"Could not manage process!", (Throwable)e);
        }
    }

    protected abstract void setServerStopCommand(List<String> var1);

    private String getPid() throws IOException {
        this.pid = this.processManager.findPid(this.processRegex);
        log.debug((Object)("regexp: " + this.processRegex + " pid:" + this.pid));
        return this.pid;
    }

    public void configure() throws ConfigurationException {
        this.checkNoRunningServer();
        this.configurationGenerator.checkJavaVersion();
        this.configurationGenerator.run();
        this.overrideJavaTmpDir = Boolean.parseBoolean(this.configurationGenerator.getUserConfig().getProperty(OVERRIDE_JAVA_TMPDIR_PARAM, "true"));
    }

    private String getDefaultMaxWait() {
        return this.configurationGenerator.isJBoss ? START_MAX_WAIT_JBOSS_DEFAULT : START_MAX_WAIT_DEFAULT;
    }

    public String status() {
        if (this.processManager instanceof PureJavaProcessManager) {
            this.status = 4;
            return "Can't check server status on your OS.";
        }
        try {
            if (this.getPid() == null) {
                this.status = 3;
                return "Server is not running.";
            }
            this.status = 0;
            return "Server is running with process ID " + this.getPid() + ".";
        }
        catch (IOException e) {
            this.status = 4;
            return "Could not check existing process (" + e.getMessage() + ").";
        }
    }

    public int getStatus() {
        return this.status;
    }

    public int getErrorValue() {
        return this.errorValue;
    }

    public static NuxeoLauncher createLauncher(String[] args) throws ConfigurationException, ParseException {
        NuxeoLauncher launcher;
        CommandLine cmdLine = NuxeoLauncher.parseOptions(args);
        if (cmdLine.hasOption(OPTION_QUIET) || cmdLine.hasOption(OPTION_XML) || cmdLine.hasOption(OPTION_JSON)) {
            NuxeoLauncher.setQuiet();
        }
        if (cmdLine.hasOption(OPTION_DEBUG) || cmdLine.hasOption(OPTION_DEBUG_CATEGORY)) {
            NuxeoLauncher.setDebug(cmdLine.getOptionValue(OPTION_DEBUG_CATEGORY, "org.nuxeo.launcher"));
        }
        if (cmdLine.hasOption(OPTION_FORCE)) {
            NuxeoLauncher.setForce(true);
        }
        ConfigurationGenerator cg = new ConfigurationGenerator(quiet, debug);
        if (cmdLine.hasOption(OPTION_HIDE_DEPRECATION)) {
            cg.hideDeprecationWarnings(true);
        }
        if (cg.isJBoss) {
            launcher = new NuxeoJBossLauncher(cg);
        } else if (cg.isJetty) {
            launcher = new NuxeoJettyLauncher(cg);
        } else if (cg.isTomcat) {
            launcher = new NuxeoTomcatLauncher(cg);
        } else {
            throw new ConfigurationException("Unknown server!");
        }
        super.setArgs(cmdLine);
        return launcher;
    }

    private void setArgs(CommandLine cmdLine) {
        this.cmdLine = cmdLine;
        this.extractCommandAndParams(cmdLine.getArgs());
        if (cmdLine.hasOption(OPTION_GUI)) {
            this.useGui = Boolean.valueOf(cmdLine.getOptionValue(OPTION_GUI));
            log.debug((Object)("GUI: " + cmdLine.getOptionValue(OPTION_GUI) + " -> " + new Boolean(this.useGui).toString()));
        } else if (OPTION_GUI.equalsIgnoreCase(this.command)) {
            this.useGui = true;
            this.extractCommandAndParams(params);
        } else if (PlatformUtils.isWindows()) {
            this.useGui = true;
            log.debug((Object)"GUI: option not set - platform is Windows -> start GUI");
        } else {
            this.useGui = false;
            log.debug((Object)"GUI: option not set - platform is not Windows -> do not start GUI");
        }
        if (cmdLine.hasOption(OPTION_XML)) {
            this.setXMLOutput();
        }
        if (cmdLine.hasOption(OPTION_JSON)) {
            this.setJSONOutput();
        }
    }

    private void extractCommandAndParams(String[] args) {
        if (args.length > 0) {
            this.command = args[0];
            log.debug((Object)("Launcher command: " + this.command));
            if (args.length > 1) {
                params = Arrays.copyOfRange(args, 1, args.length);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Command parameters: " + ArrayUtils.toString((Object)params)));
                }
            } else {
                params = new String[0];
            }
        } else {
            this.command = null;
        }
    }

    protected static void setQuiet() {
        quiet = true;
        Log4JHelper.setQuiet((String)"CONSOLE");
    }

    protected static void setDebug(String categories) {
        NuxeoLauncher.setDebug(categories, true);
    }

    protected static void setDebug(String categories, boolean activateDebug) {
        debug = activateDebug;
        Log4JHelper.setDebug((String)categories, (boolean)activateDebug, (boolean)true, (String[])new String[]{"CONSOLE", "FILE"});
    }

    protected static void setDebug(boolean activateDebug) {
        NuxeoLauncher.setDebug("org.nuxeo", activateDebug);
    }

    protected static void setForce(boolean value) {
        force = value;
    }

    protected void setXMLOutput() {
        this.xmlOutput = true;
    }

    protected void setJSONOutput() {
        this.jsonOutput = true;
        this.setXMLOutput();
    }

    public static void printShortHelp() {
        HelpFormatter help = new HelpFormatter();
        help.setSyntaxPrefix("Usage: ");
        help.printHelp("nuxeoctl [options] <command> [command parameters]", launcherOptions);
    }

    public static void printLongHelp() {
        NuxeoLauncher.printShortHelp();
        log.error((Object)"\n\nJava usage:\n\tjava [-Dlauncher.java.opts=\"JVM options\"] [-Dnuxeo.home=\"/path/to/nuxeo\"] [-Dnuxeo.conf=\"/path/to/nuxeo.conf\"] [-Djvmcheck=nofail] -jar \"path/to/nuxeo-launcher.jar\" \\ \n\t\t[options] <command> [command parameters]");
        log.error((Object)"\n\tlauncher.java.opts\tParameters for the server JVM (default are -Xms512m -Xmx1024m -XX:MaxPermSize=512m).");
        log.error((Object)"\tnuxeo.home\t\tNuxeo server root path (default is parent of called script).");
        log.error((Object)"\tnuxeo.conf\t\tPath to nuxeo.conf file (default is $NUXEO_HOME/bin/nuxeo.conf).");
        log.error((Object)"\tjvmcheck\t\tIf set to \"nofail\", ignore JVM version validation errors.");
        log.error((Object)"\n\nCommands list:");
        log.error((Object)"\thelp\t\t\tPrint this message.");
        log.error((Object)"\tgui\t\t\tStart the user graphical interface.");
        log.error((Object)"\tstart\t\t\tStart Nuxeo server in background, waiting for effective start. Useful for batch executions requiring the server being immediately available after the script returned.");
        log.error((Object)"\tstop\t\t\tStop any Nuxeo server started with the same nuxeo.conf file.");
        log.error((Object)"\trestart\t\t\tRestart Nuxeo server.");
        log.error((Object)"\tconfigure\t\tConfigure Nuxeo server with parameters from nuxeo.conf.");
        log.error((Object)"\twizard\t\t\tEnable the wizard (force the wizard to be played again in case the wizard configuration has already been done).");
        log.error((Object)"\tconsole\t\t\tStart Nuxeo server in a console mode. Ctrl-C will stop it.");
        log.error((Object)"\tstatus\t\t\tPrint server status (running or not).");
        log.error((Object)"\tstartbg\t\t\tStart Nuxeo server in background, without waiting for effective start. Useful for starting Nuxeo as a service.");
        log.error((Object)"\trestartbg\t\tRestart Nuxeo server with a call to \"startbg\" after \"stop\".");
        log.error((Object)"\tpack <target>\t\tBuild a static archive (the \"pack\" Shell script is deprecated).");
        log.error((Object)"\tshowconf\t\tDisplay the instance configuration.");
        log.error((Object)"\tmp-list\t\t\tList local Marketplace packages.");
        log.error((Object)"\tmp-listall\t\tList all Marketplace packages (requires a registered instance).");
        log.error((Object)"\tmp-init\t\t\tPre-cache Marketplace packages locally available in the distribution.");
        log.error((Object)"\tmp-update\t\tUpdate cache of marketplace packages list.");
        log.error((Object)"\tmp-add\t\t\tAdd Marketplace package(s) to local cache. You must provide the package file(s), name(s) or ID(s) as parameter.");
        log.error((Object)"\tmp-install\t\tRun Marketplace package installation. It is automatically called at startup if {{installAfterRestart.log}} file exists in data directory. Else you must provide the package file(s), name(s) or ID(s) as parameter.");
        log.error((Object)"\tmp-uninstall\t\tUninstall Marketplace package(s). You must provide the package name(s) or ID(s) as parameter (see \"mp-list\" command).");
        log.error((Object)"\tmp-set\t\t\tInstalls a list of Marketplace packages and removes those not in the list.");
        log.error((Object)"\tmp-request\t\tInstall + uninstall Marketplace package(s) in one command. You must provide a *quoted* list of package names or IDs prefixed with + (install) or - (uninstall).");
        log.error((Object)"\tmp-remove\t\tRemove Marketplace package(s) from the local cache. You must provide the package name(s) or ID(s) as parameter (see \"mp-list\" command).");
        log.error((Object)"\tmp-reset\t\tReset all packages to DOWNLOADED state. May be useful after a manual server upgrade.");
        log.error((Object)"\tmp-purge\t\tUninstall and remove all packages from the local cache.");
        log.error((Object)"\tmp-hotfix\t\tInstall all the available hotfixes for the current platform (requires a registered instance).");
        log.error((Object)"\tmp-upgrade\t\tGet all the available upgrades for the Marketplace packages currently installed (requires a registered instance).");
        log.error((Object)"\tmp-show\t\t\tShow Marketplace package(s) information. You must provide the package file(s), name(s) or ID(s) as parameter.");
    }

    public boolean isRunning() {
        if (this.nuxeoProcess != null) {
            try {
                this.nuxeoProcess.exitValue();
                this.nuxeoProcess = null;
            }
            catch (IllegalThreadStateException exception) {
                return true;
            }
        }
        try {
            return this.getPid() != null;
        }
        catch (IOException e) {
            log.error((Object)e);
            return false;
        }
    }

    public boolean isStarted() {
        boolean isStarted;
        if (this.configurationGenerator.isWizardRequired()) {
            isStarted = this.isRunning();
        } else {
            try {
                isStarted = this.isRunning() && this.statusServletClient.isStarted();
            }
            catch (SocketTimeoutException e) {
                isStarted = false;
            }
        }
        return isStarted;
    }

    public File getLogFile() {
        return new File(this.configurationGenerator.getLogDir(), "server.log");
    }

    public String getURL() {
        return this.configurationGenerator.getUserConfig().getProperty("nuxeo.url");
    }

    protected ConnectBroker getConnectBroker() throws IOException, PackageException {
        if (this.connectBroker == null) {
            this.connectBroker = new ConnectBroker(this.configurationGenerator.getEnv());
            if (this.hasOption(OPTION_ACCEPT)) {
                this.connectBroker.setAccept(this.cmdLine.getOptionValue(OPTION_ACCEPT, "ask"));
            }
            if (this.hasOption(OPTION_RELAX)) {
                this.connectBroker.setRelax(this.cmdLine.getOptionValue(OPTION_RELAX));
            }
            if (this.hasOption(OPTION_SNAPSHOT) || this.isSNAPSHOTDistribution()) {
                this.connectBroker.setAllowSNAPSHOT(true);
            }
            this.cset = this.connectBroker.getCommandSet();
        }
        return this.connectBroker;
    }

    private boolean isSNAPSHOTDistribution() {
        return new Version(this.getDistributionInfo().version).isSnapshot();
    }

    protected void pkgList() throws IOException, PackageException {
        this.getConnectBroker().listPending(this.configurationGenerator.getInstallFile());
        this.getConnectBroker().pkgList();
    }

    protected void pkgListAll() throws IOException, PackageException {
        this.getConnectBroker().listPending(this.configurationGenerator.getInstallFile());
        this.getConnectBroker().pkgListAll();
    }

    protected boolean pkgAdd(String[] pkgNames) throws IOException, PackageException {
        boolean cmdOK = this.getConnectBroker().pkgAdd(Arrays.asList(pkgNames));
        if (!cmdOK) {
            this.errorValue = 1;
        }
        return cmdOK;
    }

    protected boolean pkgInstall(String[] pkgIDs) throws IOException, PackageException {
        boolean cmdOK = true;
        if (this.configurationGenerator.isInstallInProgress()) {
            cmdOK = this.getConnectBroker().executePending(this.configurationGenerator.getInstallFile(), true, !this.hasOption(OPTION_NODEPS));
        }
        boolean bl = cmdOK = cmdOK && this.getConnectBroker().pkgInstall(Arrays.asList(pkgIDs));
        if (!cmdOK) {
            this.errorValue = 1;
        }
        return cmdOK;
    }

    protected boolean pkgUninstall(String[] pkgIDs) throws IOException, PackageException {
        boolean cmdOK = this.getConnectBroker().pkgUninstall(Arrays.asList(pkgIDs));
        if (!cmdOK) {
            this.errorValue = 1;
        }
        return cmdOK;
    }

    protected boolean pkgRemove(String[] pkgIDs) throws IOException, PackageException {
        boolean cmdOK = this.getConnectBroker().pkgRemove(Arrays.asList(pkgIDs));
        if (!cmdOK) {
            this.errorValue = 1;
        }
        return cmdOK;
    }

    protected boolean pkgReset() throws IOException, PackageException {
        boolean cmdOK = this.getConnectBroker().pkgReset();
        if (!cmdOK) {
            this.errorValue = 1;
        }
        return cmdOK;
    }

    protected void printInstanceXMLOutput(InstanceInfo instance) {
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{InstanceInfo.class, DistributionInfo.class, PackageInfo.class, ConfigurationInfo.class, KeyValueInfo.class});
            this.printXMLOutput(jaxbContext, instance);
        }
        catch (JAXBException e) {
            log.error((Object)("Output serialization failed: " + e.getMessage()));
            log.debug((Object)e, (Throwable)e);
            this.errorValue = 7;
        }
    }

    protected boolean showConfig() throws IOException, PackageException {
        DistributionInfo nxDistrib;
        InstanceInfo nxInstance = new InstanceInfo();
        log.info((Object)"***** Nuxeo instance configuration *****");
        nxInstance.NUXEO_CONF = this.configurationGenerator.getNuxeoConf().getPath();
        log.info((Object)("NUXEO_CONF: " + nxInstance.NUXEO_CONF));
        nxInstance.NUXEO_HOME = this.configurationGenerator.getNuxeoHome().getPath();
        log.info((Object)("NUXEO_HOME: " + nxInstance.NUXEO_HOME));
        try {
            nxInstance.clid = this.getConnectBroker().getCLID();
            log.info((Object)("Instance CLID: " + nxInstance.clid));
        }
        catch (LogicalInstanceIdentifier.NoCLID e) {
        }
        catch (PackageException e) {
            this.errorValue = 4;
            log.error((Object)"Could not initialize NuxeoConnectClient", (Throwable)e);
            return false;
        }
        nxInstance.distribution = nxDistrib = this.getDistributionInfo();
        log.info((Object)"** Distribution");
        log.info((Object)("- name: " + nxDistrib.name));
        log.info((Object)("- server: " + nxDistrib.server));
        log.info((Object)("- version: " + nxDistrib.version));
        log.info((Object)("- date: " + nxDistrib.date));
        log.info((Object)("- packaging: " + nxDistrib.packaging));
        List<LocalPackage> pkgs = this.getConnectBroker().getPkgList();
        log.info((Object)"** Packages:");
        ArrayList<String> pkgTemplates = new ArrayList<String>();
        for (LocalPackage pkg : pkgs) {
            nxInstance.packages.add(new PackageInfo((Package)pkg));
            log.info((Object)String.format("- %s (version: %s - id: %s - state: %s)", pkg.getName(), pkg.getVersion(), pkg.getId(), PackageState.getByValue((int)pkg.getState()).getLabel()));
            try {
                File installFile = pkg.getInstallFile();
                DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                DocumentBuilder db = dbf.newDocumentBuilder();
                Document dom = db.parse(installFile);
                NodeList nodes = dom.getDocumentElement().getElementsByTagName("config");
                for (int i = 0; i < nodes.getLength(); ++i) {
                    Element node = (Element)nodes.item(i);
                    if (!node.hasAttribute("addtemplate")) continue;
                    pkgTemplates.add(node.getAttribute("addtemplate"));
                }
            }
            catch (Exception e) {
                log.warn((Object)("Could not parse install file for " + pkg.getName()), (Throwable)e);
            }
        }
        ConfigurationInfo nxConfig = new ConfigurationInfo();
        nxConfig.dbtemplate = this.configurationGenerator.extractDatabaseTemplateName();
        log.info((Object)"** Templates:");
        log.info((Object)("Database template: " + nxConfig.dbtemplate));
        String userTemplates = this.configurationGenerator.getUserTemplates();
        StringTokenizer st = new StringTokenizer(userTemplates, ",");
        while (st.hasMoreTokens()) {
            String template = st.nextToken();
            if (template.equals(nxConfig.dbtemplate)) continue;
            if (pkgTemplates.contains(template)) {
                nxConfig.pkgtemplates.add(template);
                log.info((Object)("Package template: " + template));
                continue;
            }
            File testBase = new File(this.configurationGenerator.getNuxeoHome(), "templates" + File.separator + template);
            if (testBase.exists()) {
                nxConfig.basetemplates.add(template);
                log.info((Object)("Base template: " + template));
                continue;
            }
            nxConfig.usertemplates.add(template);
            log.info((Object)("User template: " + template));
        }
        log.info((Object)"** Settings from nuxeo.conf:");
        Properties userConfig = this.configurationGenerator.getUserConfig();
        Enumeration<Object> nxConfEnum = userConfig.keys();
        while (nxConfEnum.hasMoreElements()) {
            String key = (String)nxConfEnum.nextElement();
            String value = userConfig.getProperty(key);
            if (key.equals("JAVA_OPTS")) {
                value = this.getJavaOptsProperty();
            }
            KeyValueInfo kv = new KeyValueInfo(key, value);
            nxConfig.keyvals.add(kv);
            if (!key.contains("password") && !key.equals("server.status.key")) {
                log.info((Object)(key + "=" + value));
                continue;
            }
            log.info((Object)(key + "=********"));
        }
        nxInstance.config = nxConfig;
        log.info((Object)"****************************************");
        this.printInstanceXMLOutput(nxInstance);
        return true;
    }

    protected DistributionInfo getDistributionInfo() {
        DistributionInfo nxDistrib;
        File distFile = new File(this.configurationGenerator.getConfigDir(), "distribution.properties");
        if (!distFile.exists()) {
            distFile = new File(this.configurationGenerator.getNuxeoHome(), "templates");
            distFile = new File(distFile, "common");
            distFile = new File(distFile, "config");
            distFile = new File(distFile, "distribution.properties");
        }
        try {
            nxDistrib = new DistributionInfo(distFile);
        }
        catch (IOException e) {
            nxDistrib = new DistributionInfo();
        }
        return nxDistrib;
    }

    protected boolean pkgRequest(List<String> pkgsToAdd, List<String> pkgsToInstall, List<String> pkgsToUninstall, List<String> pkgsToRemove) throws IOException, PackageException {
        boolean cmdOK = true;
        if (this.configurationGenerator.isInstallInProgress()) {
            cmdOK = this.getConnectBroker().executePending(this.configurationGenerator.getInstallFile(), true, true);
        }
        boolean bl = cmdOK = cmdOK && this.getConnectBroker().pkgRequest(pkgsToAdd, pkgsToInstall, pkgsToUninstall, pkgsToRemove);
        if (!cmdOK) {
            this.errorValue = 1;
        }
        return cmdOK;
    }

    protected boolean pkgRefreshCache() throws IOException, PackageException {
        this.getConnectBroker().refreshCache();
        return true;
    }

    protected boolean pkgInit() throws IOException, PackageException {
        return this.getConnectBroker().addDistributionPackages();
    }

    protected boolean pkgPurge() throws PackageException, IOException {
        return this.getConnectBroker().pkgPurge();
    }

    protected boolean pkgHotfix() throws IOException, PackageException {
        return this.getConnectBroker().pkgHotfix();
    }

    protected boolean pkgUpgrade() throws IOException, PackageException {
        return this.getConnectBroker().pkgUpgrade();
    }

    protected boolean pkgCompoundRequest(List<String> request) throws IOException, PackageException {
        ArrayList<String> add = new ArrayList<String>();
        ArrayList<String> install = new ArrayList<String>();
        ArrayList<String> uninstall = new ArrayList<String>();
        for (String param : request) {
            for (String subparam : param.split("[ ,]")) {
                if (subparam.charAt(0) == '-') {
                    uninstall.add(subparam.substring(1));
                    continue;
                }
                if (subparam.charAt(0) == '+') {
                    install.add(subparam.substring(1));
                    continue;
                }
                add.add(subparam);
            }
        }
        return this.pkgRequest(add, install, uninstall, null);
    }

    protected boolean pkgSetRequest(List<String> request, boolean nodeps) throws IOException, PackageException {
        if (nodeps) {
            return this.getConnectBroker().pkgSet(request);
        }
        return this.getConnectBroker().pkgRequest(null, request, null, null, false);
    }

    protected boolean pkgShow(String[] packages) throws IOException, PackageException {
        boolean cmdOK = this.getConnectBroker().pkgShow(Arrays.asList(packages));
        if (!cmdOK) {
            this.errorValue = 1;
        }
        return cmdOK;
    }

    static {
        if (System.getProperty("nuxeo.log.dir") == null) {
            System.setProperty("nuxeo.log.dir", ".");
        }
        log = LogFactory.getLog(NuxeoLauncher.class);
        launcherOptions = null;
        COMMANDS_NO_GUI = new String[]{"configure", "mp-init", "mp-purge", "mp-add", "mp-install", "mp-uninstall", "mp-request", "mp-remove", "mp-hotfix", "mp-upgrade", "mp-reset", "mp-list", "mp-listall", "mp-update", "status", "showconf", "mp-show", "mp-set"};
        COMMANDS_NO_RUNNING_SERVER = new String[]{"mp-init", "mp-purge", "mp-add", "mp-install", "mp-uninstall", "mp-request", "mp-remove", "mp-hotfix", "mp-upgrade", "mp-reset", "mp-update", "mp-set"};
        quiet = false;
        debug = false;
        force = false;
    }

    protected class ShutdownThread
    extends Thread {
        private NuxeoLauncher launcher;

        public ShutdownThread(NuxeoLauncher launcher) {
            this.launcher = launcher;
        }

        @Override
        public void run() {
            log.debug((Object)"Shutting down...");
            if (this.launcher.isRunning()) {
                this.launcher.stop();
            }
            log.debug((Object)"Shutdown complete.");
        }
    }

    public static class SolarisProcessManager
    extends UnixProcessManager {
        protected static final String SOLARIS_11 = "5.11";
        protected static final String SOLARIS_10 = "5.10";
        protected static final String[] SOLARIS_11_PS = new String[]{"/usr/bin/ps", "auxww"};
        protected static final String[] SOLARIS_10_PS = new String[]{"/usr/ucb/ps", "auxww"};
        protected static final Pattern PS_OUTPUT_LINE = Pattern.compile("^[^\\s]+\\s+([0-9]+)\\s+[0-9.\\s]+[^\\s]+\\s+[^\\s]+\\s+[^\\s]+\\s+[^\\s]+\\s+(.*)$");
        protected String solarisVersion;

        protected String getSolarisVersion() {
            if (this.solarisVersion == null) {
                List<Object> lines;
                try {
                    lines = this.execute("/usr/bin/uname", "-r");
                }
                catch (IOException e) {
                    log.debug((Object)e.getMessage(), (Throwable)e);
                    lines = Collections.emptyList();
                }
                this.solarisVersion = lines.isEmpty() ? "?" : ((String)lines.get(0)).trim();
            }
            return this.solarisVersion;
        }

        protected String[] psCommand() {
            if (SOLARIS_11.equals(this.getSolarisVersion())) {
                return SOLARIS_11_PS;
            }
            return null;
        }

        protected Matcher getLineMatcher(String line) {
            return PS_OUTPUT_LINE.matcher(line);
        }

        public String findPid(String regex) throws IOException {
            if (SOLARIS_11.equals(this.getSolarisVersion())) {
                Pattern commandPattern = Pattern.compile(regex);
                for (String line : this.execute(this.psCommand())) {
                    Matcher lineMatcher = this.getLineMatcher(line);
                    if (!lineMatcher.matches()) continue;
                    String pid = lineMatcher.group(1);
                    String command = lineMatcher.group(2);
                    Matcher commandMatcher = commandPattern.matcher(command);
                    if (!commandMatcher.find()) continue;
                    return pid;
                }
            } else {
                log.debug((Object)("Unsupported Solaris version: " + this.solarisVersion));
            }
            return null;
        }

        protected List<String> execute(String ... command) throws IOException {
            Process process = new ProcessBuilder(command).start();
            List lines = IOUtils.readLines((InputStream)process.getInputStream());
            return lines;
        }
    }
}

