/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.vision.aws;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.services.rekognition.AmazonRekognition;
import com.amazonaws.services.rekognition.AmazonRekognitionClientBuilder;
import com.amazonaws.services.rekognition.model.DetectLabelsRequest;
import com.amazonaws.services.rekognition.model.Image;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.vision.aws.AmazonRekognitionResponse;
import org.nuxeo.vision.core.service.VisionFeature;
import org.nuxeo.vision.core.service.VisionProvider;
import org.nuxeo.vision.core.service.VisionResponse;

public class AmazonRekognitionProvider
implements VisionProvider {
    public static final String REGION_PARAM = "region";
    public static final String ACCESS_KEY_PARAM = "accessKey";
    public static final String SECRET_KEY_PARAM = "secretKey";
    protected static final long BLOB_MAX_SIZE = 0x500000L;
    protected static final List<String> SUPPORTED_FORMAT = Arrays.asList("image/jpeg", "image/png");
    protected volatile AmazonRekognition client;
    protected Map<String, String> parameters;

    public AmazonRekognitionProvider(Map<String, String> parameters) {
        this.parameters = parameters;
    }

    public List<VisionResponse> execute(List<Blob> blobs, List<VisionFeature> features, int maxResults) throws IOException, GeneralSecurityException, IllegalStateException {
        ArrayList<VisionResponse> result = new ArrayList<VisionResponse>();
        for (Blob blob : blobs) {
            result.add(new AmazonRekognitionResponse(this.getClient().detectLabels(new DetectLabelsRequest().withImage(new Image().withBytes(ByteBuffer.wrap(blob.getByteArray()))).withMaxLabels(Integer.valueOf(maxResults)))));
        }
        return result;
    }

    public List<VisionFeature> getSupportedFeatures() {
        return Arrays.asList(VisionFeature.LABEL_DETECTION, VisionFeature.FACE_DETECTION);
    }

    public boolean checkBlobs(List<Blob> blobs) throws IOException {
        for (Blob blob : blobs) {
            long size = blob.getLength();
            if (size <= 0L) {
                throw new IOException("Could not read the blob size");
            }
            if (size > 0x500000L) {
                return false;
            }
            if (SUPPORTED_FORMAT.contains(blob.getMimeType())) continue;
            return false;
        }
        return true;
    }

    public Object getNativeClient() {
        return this.getClient();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AmazonRekognition getClient() {
        AmazonRekognition result = this.client;
        if (result == null) {
            AmazonRekognitionProvider amazonRekognitionProvider = this;
            synchronized (amazonRekognitionProvider) {
                result = this.client;
                if (result == null) {
                    AmazonRekognitionClientBuilder builder = AmazonRekognitionClientBuilder.standard();
                    builder.withCredentials((AWSCredentialsProvider)new AWSStaticCredentialsProvider((AWSCredentials)new BasicAWSCredentials(this.parameters.get(ACCESS_KEY_PARAM), this.parameters.get(SECRET_KEY_PARAM))));
                    builder.withRegion(this.parameters.get(REGION_PARAM));
                    result = this.client = (AmazonRekognition)builder.build();
                }
            }
        }
        return result;
    }
}

