/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.vision.core.google;

import com.google.api.services.vision.v1.model.AnnotateImageResponse;
import com.google.api.services.vision.v1.model.DominantColorsAnnotation;
import com.google.api.services.vision.v1.model.EntityAnnotation;
import com.google.api.services.vision.v1.model.ImageProperties;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import org.nuxeo.vision.core.image.ColorInfo;
import org.nuxeo.vision.core.image.ImageProprerties;
import org.nuxeo.vision.core.image.TextEntity;
import org.nuxeo.vision.core.service.VisionResponse;

public class GoogleVisionResponse
implements VisionResponse {
    AnnotateImageResponse response;

    public GoogleVisionResponse(AnnotateImageResponse response) {
        this.response = response;
    }

    @Override
    public List<TextEntity> getClassificationLabels() {
        ArrayList<TextEntity> results = new ArrayList<TextEntity>();
        if (this.response.getLabelAnnotations() != null) {
            results.addAll(this.processEntityAnnotationList(this.response.getLabelAnnotations()));
        }
        if (this.response.getLandmarkAnnotations() != null) {
            results.addAll(this.processEntityAnnotationList(this.response.getLandmarkAnnotations()));
        }
        if (this.response.getLogoAnnotations() != null) {
            results.addAll(this.processEntityAnnotationList(this.response.getLogoAnnotations()));
        }
        return results;
    }

    @Override
    public List<TextEntity> getOcrText() {
        List labels = this.response.getTextAnnotations();
        return this.processEntityAnnotationList(labels);
    }

    @Override
    public ImageProprerties getImageProperties() {
        ArrayList<ColorInfo> results = new ArrayList<ColorInfo>();
        ImageProperties properties = this.response.getImagePropertiesAnnotation();
        if (properties == null) {
            return new ImageProprerties(results);
        }
        DominantColorsAnnotation annotation = properties.getDominantColors();
        if (annotation == null) {
            return new ImageProprerties(results);
        }
        List colors = annotation.getColors();
        if (colors == null) {
            return new ImageProprerties(results);
        }
        for (com.google.api.services.vision.v1.model.ColorInfo colorInfo : colors) {
            com.google.api.services.vision.v1.model.Color color = colorInfo.getColor();
            Color resultColor = new Color(color.getRed().floatValue() / 255.0f, color.getGreen().floatValue() / 255.0f, color.getBlue().floatValue() / 255.0f);
            results.add(new ColorInfo(resultColor, colorInfo.getPixelFraction().floatValue(), colorInfo.getScore().floatValue()));
        }
        return new ImageProprerties(results);
    }

    @Override
    public Object getNativeObject() {
        return this.response;
    }

    protected List<TextEntity> processEntityAnnotationList(List<EntityAnnotation> annotations) {
        ArrayList<TextEntity> result = new ArrayList<TextEntity>();
        if (annotations == null) {
            return result;
        }
        for (EntityAnnotation annotation : annotations) {
            result.add(new TextEntity(annotation.getDescription(), annotation.getScore() != null ? annotation.getScore().floatValue() : 0.0f, annotation.getLocale()));
        }
        return result;
    }
}

