/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.vision.core.listener;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.automation.AutomationService;
import org.nuxeo.ecm.automation.OperationChain;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.OperationException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventBundle;
import org.nuxeo.ecm.core.event.EventContext;
import org.nuxeo.ecm.core.event.PostCommitEventListener;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.vision.core.service.Vision;

public class PictureConversionChangedListener
implements PostCommitEventListener {
    private static final Log log = LogFactory.getLog(PictureConversionChangedListener.class);

    public void handleEvent(EventBundle events) {
        for (Event event : events) {
            this.handleEvent(event);
        }
    }

    protected void handleEvent(Event event) {
        EventContext ectx = event.getContext();
        if (!(ectx instanceof DocumentEventContext)) {
            return;
        }
        DocumentEventContext docCtx = (DocumentEventContext)ectx;
        DocumentModel doc = docCtx.getSourceDocument();
        if (!doc.hasFacet("Picture") || doc.isProxy()) {
            return;
        }
        Vision visionService = (Vision)Framework.getService(Vision.class);
        String mapperChainName = visionService.getPictureMapperChainName();
        AutomationService as = (AutomationService)Framework.getService(AutomationService.class);
        OperationContext octx = new OperationContext();
        octx.setInput((Object)doc);
        octx.setCoreSession(doc.getCoreSession());
        OperationChain chain = new OperationChain("PictureChangedListenerChain");
        chain.add(mapperChainName);
        try {
            as.run(octx, chain);
        }
        catch (OperationException e) {
            log.warn((Object)e);
        }
    }
}

