/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.vision.core.operation;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.automation.core.util.BlobList;
import org.nuxeo.ecm.automation.core.util.StringList;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.vision.core.service.Vision;
import org.nuxeo.vision.core.service.VisionFeature;
import org.nuxeo.vision.core.service.VisionResponse;

@Operation(id="VisionOp", category="Files", label="Call the Computer Vision Service", description="Call the Computer Vision Service for the input blob(s)")
public class VisionOp {
    public static final String ID = "VisionOp";
    private static final Log log = LogFactory.getLog(VisionOp.class);
    @Context
    protected OperationContext ctx;
    @Context
    protected Vision visionService;
    @Param(name="features", description="A StringList of features to request from the API. Available Features are described at https://cloud.google.com/vision/reference/rest/v1/images/annotate#Feature", required=true)
    protected StringList features;
    @Param(name="outputVariable", description="The key of the context output variable. The output variable is a list of AnnotateImageResponse objects. See https://cloud.google.com/vision/reference/rest/v1/images/annotate#AnnotateImageResponse", required=true)
    protected String outputVariable;
    @Param(name="maxResults", description="The maximum number of results per feature", required=true)
    protected int maxResults;

    @OperationMethod
    public Blob run(Blob blob) {
        if (blob == null) {
            return null;
        }
        BlobList blobs = new BlobList();
        blobs.add((Object)blob);
        return (Blob)this.run(blobs).get(0);
    }

    @OperationMethod
    public BlobList run(BlobList blobs) {
        ArrayList<VisionFeature> featureList = new ArrayList<VisionFeature>();
        for (String feature : this.features) {
            featureList.add(VisionFeature.valueOf(feature));
        }
        try {
            List<VisionResponse> results = this.visionService.execute((List<Blob>)blobs, featureList, this.maxResults);
            this.ctx.put(this.outputVariable, results);
        }
        catch (IOException | GeneralSecurityException e) {
            log.warn((Object)"Call to google vision API failed", (Throwable)e);
        }
        return blobs;
    }
}

