/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.vision.core.service;

import com.google.api.client.googleapis.auth.oauth2.GoogleCredential;
import com.google.api.client.googleapis.javanet.GoogleNetHttpTransport;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.jackson2.JacksonFactory;
import com.google.api.services.vision.v1.Vision;
import com.google.api.services.vision.v1.VisionScopes;
import com.google.api.services.vision.v1.model.AnnotateImageRequest;
import com.google.api.services.vision.v1.model.AnnotateImageResponse;
import com.google.api.services.vision.v1.model.BatchAnnotateImagesRequest;
import com.google.api.services.vision.v1.model.BatchAnnotateImagesResponse;
import com.google.api.services.vision.v1.model.Feature;
import com.google.api.services.vision.v1.model.Image;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.DefaultComponent;
import org.nuxeo.vision.core.google.GoogleVisionDescriptor;
import org.nuxeo.vision.core.google.GoogleVisionResponse;
import org.nuxeo.vision.core.service.Vision;
import org.nuxeo.vision.core.service.VisionDescriptor;
import org.nuxeo.vision.core.service.VisionFeature;
import org.nuxeo.vision.core.service.VisionResponse;

public class VisionImpl
extends DefaultComponent
implements Vision {
    private static final Log log = LogFactory.getLog(VisionImpl.class);
    private volatile com.google.api.services.vision.v1.Vision visionClient;
    protected static final String CONFIG_EXT_POINT = "configuration";
    protected static final String GOOGLE_EXT_POINT = "google";
    protected static final long _4MB = 0x400000L;
    protected static final long _8MB = 0x800000L;
    protected static final int MAX_BLOB_PER_REQUEST = 16;
    protected VisionDescriptor config = null;
    protected GoogleVisionDescriptor googleConfig = null;

    public void activate(ComponentContext context) {
        super.activate(context);
    }

    public void deactivate(ComponentContext context) {
        super.deactivate(context);
    }

    public void applicationStarted(ComponentContext context) {
    }

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        if (CONFIG_EXT_POINT.equals(extensionPoint)) {
            this.config = (VisionDescriptor)contribution;
        } else if (GOOGLE_EXT_POINT.equals(extensionPoint)) {
            this.googleConfig = (GoogleVisionDescriptor)contribution;
        }
    }

    public void unregisterContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private com.google.api.services.vision.v1.Vision getVisionService() throws IOException, GeneralSecurityException {
        com.google.api.services.vision.v1.Vision result = this.visionClient;
        if (result == null) {
            VisionImpl visionImpl = this;
            synchronized (visionImpl) {
                result = this.visionClient;
                if (result == null) {
                    GoogleCredential credential = null;
                    if (this.usesServiceAccount()) {
                        File file = new File(this.googleConfig.getCredentialFilePath());
                        credential = GoogleCredential.fromStream((InputStream)new FileInputStream(file)).createScoped((Collection)VisionScopes.all());
                    }
                    JacksonFactory jsonFactory = JacksonFactory.getDefaultInstance();
                    result = this.visionClient = new Vision.Builder((HttpTransport)GoogleNetHttpTransport.newTrustedTransport(), (JsonFactory)jsonFactory, credential).setApplicationName(this.googleConfig.getAppName()).build();
                }
            }
        }
        return result;
    }

    @Override
    public VisionResponse execute(Blob blob, List<VisionFeature> features, int maxResults) throws IOException, GeneralSecurityException, IllegalStateException {
        if (blob == null) {
            throw new IllegalArgumentException("Input Blob cannot be null");
        }
        if (features == null || features.size() == 0) {
            throw new IllegalArgumentException("The feature list cannot be empty or null");
        }
        List<VisionResponse> results = this.execute((List<Blob>)ImmutableList.of((Object)blob), features, maxResults);
        if (results.size() > 0) {
            return results.get(0);
        }
        throw new NuxeoException("Google vision returned empty results for " + blob.getFilename());
    }

    @Override
    public List<VisionResponse> execute(List<Blob> blobs, List<VisionFeature> features, int maxResults) throws IOException, GeneralSecurityException, IllegalStateException {
        if (blobs == null || blobs.size() == 0) {
            throw new IllegalArgumentException("Input Blob list cannot be null or empty");
        }
        if (!this.checkBlobs(blobs)) {
            throw new IllegalArgumentException("Too many blobs or size exceeds the API limit");
        }
        if (features == null || features.size() == 0) {
            throw new IllegalArgumentException("The feature list cannot be empty or null");
        }
        List<Feature> requestFeatures = this.buildFeatureList(features, maxResults);
        List<AnnotateImageRequest> requests = this.buildRequestList(blobs, requestFeatures);
        Vision.Images.Annotate annotate = this.getVisionService().images().annotate(new BatchAnnotateImagesRequest().setRequests(requests));
        if (!this.usesServiceAccount() && this.usesApiKey()) {
            annotate.setKey(this.googleConfig.getApiKey());
        }
        annotate.setDisableGZipContent(true);
        BatchAnnotateImagesResponse batchResponse = (BatchAnnotateImagesResponse)annotate.execute();
        if (batchResponse.getResponses() == null) {
            throw new IllegalStateException("Google Vision returned an empty response");
        }
        List responses = batchResponse.getResponses();
        ArrayList<VisionResponse> output = new ArrayList<VisionResponse>();
        for (AnnotateImageResponse response : responses) {
            output.add(new GoogleVisionResponse(response));
        }
        return output;
    }

    @Override
    public String getPictureMapperChainName() {
        return this.config.getPictureMapperChainName();
    }

    @Override
    public String getVideoMapperChainName() {
        return this.config.getVideoMapperChainName();
    }

    protected List<Feature> buildFeatureList(List<VisionFeature> features, int maxResults) {
        ArrayList<Feature> requestFeatures = new ArrayList<Feature>();
        for (VisionFeature feature : features) {
            requestFeatures.add(new Feature().setType(feature.toString()).setMaxResults(Integer.valueOf(maxResults)));
        }
        return requestFeatures;
    }

    protected List<AnnotateImageRequest> buildRequestList(List<Blob> blobs, List<Feature> features) throws IOException {
        ArrayList<AnnotateImageRequest> requests = new ArrayList<AnnotateImageRequest>();
        for (Blob blob : blobs) {
            AnnotateImageRequest request = new AnnotateImageRequest().setImage(new Image().encodeContent(blob.getByteArray())).setFeatures(features);
            requests.add(request);
        }
        return requests;
    }

    protected boolean checkBlobs(List<Blob> blobs) throws IOException {
        if (blobs.size() > 16) {
            return false;
        }
        long totalSize = 0L;
        for (Blob blob : blobs) {
            long size = blob.getLength();
            if (size <= 0L) {
                throw new IOException("Could not read the blob size");
            }
            if (size > 0x400000L) {
                return false;
            }
            if ((totalSize += size) <= 0x800000L) continue;
            return false;
        }
        return true;
    }

    protected boolean usesServiceAccount() {
        String path = this.googleConfig.getCredentialFilePath();
        return path != null && path.length() > 0;
    }

    protected boolean usesApiKey() {
        String key = this.googleConfig.getApiKey();
        return key != null && key.length() > 0;
    }
}

