/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.vision.google;

import com.google.api.client.googleapis.auth.oauth2.GoogleCredential;
import com.google.api.client.googleapis.javanet.GoogleNetHttpTransport;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.jackson2.JacksonFactory;
import com.google.api.services.vision.v1.Vision;
import com.google.api.services.vision.v1.VisionScopes;
import com.google.api.services.vision.v1.model.AnnotateImageRequest;
import com.google.api.services.vision.v1.model.AnnotateImageResponse;
import com.google.api.services.vision.v1.model.BatchAnnotateImagesRequest;
import com.google.api.services.vision.v1.model.BatchAnnotateImagesResponse;
import com.google.api.services.vision.v1.model.Feature;
import com.google.api.services.vision.v1.model.Image;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.vision.core.service.VisionFeature;
import org.nuxeo.vision.core.service.VisionProvider;
import org.nuxeo.vision.core.service.VisionResponse;
import org.nuxeo.vision.google.GoogleVisionResponse;

public class GoogleVisionProvider
implements VisionProvider {
    public static final String APP_NAME_PARAM = "appName";
    public static final String API_KEY_PARAM = "apiKey";
    public static final String CREDENTIAL_PATH_PARAM = "credentialFilePath";
    protected static final long BLOB_MAX_SIZE = 0x400000L;
    protected static final long REQUEST_MAX_SIZE = 0x800000L;
    protected static final int MAX_BLOB_PER_REQUEST = 16;
    protected Map<String, String> params;
    protected volatile Vision visionClient;

    public GoogleVisionProvider(Map<String, String> parameters) {
        this.params = parameters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Vision getVisionClient() throws IOException, GeneralSecurityException {
        Vision result = this.visionClient;
        if (result == null) {
            GoogleVisionProvider googleVisionProvider = this;
            synchronized (googleVisionProvider) {
                result = this.visionClient;
                if (result == null) {
                    GoogleCredential credential = null;
                    if (this.usesServiceAccount()) {
                        File file = new File(this.getCredentialFilePath());
                        credential = GoogleCredential.fromStream((InputStream)new FileInputStream(file)).createScoped((Collection)VisionScopes.all());
                    }
                    JacksonFactory jsonFactory = JacksonFactory.getDefaultInstance();
                    result = this.visionClient = new Vision.Builder((HttpTransport)GoogleNetHttpTransport.newTrustedTransport(), (JsonFactory)jsonFactory, credential).setApplicationName(this.getAppName()).build();
                }
            }
        }
        return result;
    }

    public List<VisionResponse> execute(List<Blob> blobs, List<VisionFeature> features, int maxResults) throws IOException, GeneralSecurityException, IllegalStateException {
        List<Feature> requestFeatures = this.buildFeatureList(features, maxResults);
        List<AnnotateImageRequest> requests = this.buildRequestList(blobs, requestFeatures);
        Vision.Images.Annotate annotate = this.getVisionClient().images().annotate(new BatchAnnotateImagesRequest().setRequests(requests));
        if (!this.usesServiceAccount() && this.usesApiKey()) {
            annotate.setKey(this.getApiKey());
        }
        annotate.setDisableGZipContent(true);
        BatchAnnotateImagesResponse batchResponse = (BatchAnnotateImagesResponse)annotate.execute();
        if (batchResponse.getResponses() == null) {
            throw new IllegalStateException("Google Vision returned an empty response");
        }
        List responses = batchResponse.getResponses();
        ArrayList<VisionResponse> output = new ArrayList<VisionResponse>();
        for (AnnotateImageResponse response : responses) {
            output.add(new GoogleVisionResponse(response));
        }
        return output;
    }

    public List<VisionFeature> getSupportedFeatures() {
        return Arrays.asList(VisionFeature.FACE_DETECTION, VisionFeature.LANDMARK_DETECTION, VisionFeature.LOGO_DETECTION, VisionFeature.LABEL_DETECTION, VisionFeature.SAFE_SEARCH_DETECTION, VisionFeature.IMAGE_PROPERTIES);
    }

    public boolean checkBlobs(List<Blob> blobs) throws IOException {
        if (blobs.size() > 16) {
            return false;
        }
        long totalSize = 0L;
        for (Blob blob : blobs) {
            long size = blob.getLength();
            if (size <= 0L) {
                throw new IOException("Could not read the blob size");
            }
            if (size > 0x400000L) {
                return false;
            }
            if ((totalSize += size) <= 0x800000L) continue;
            return false;
        }
        return true;
    }

    public Vision getNativeClient() {
        try {
            return this.getVisionClient();
        }
        catch (IOException | GeneralSecurityException e) {
            throw new NuxeoException((Throwable)e);
        }
    }

    protected String getCredentialFilePath() {
        return this.params.get(CREDENTIAL_PATH_PARAM);
    }

    protected String getApiKey() {
        return this.params.get(API_KEY_PARAM);
    }

    protected String getAppName() {
        return this.params.get(APP_NAME_PARAM);
    }

    protected boolean usesServiceAccount() {
        String path = this.getCredentialFilePath();
        return StringUtils.isNotEmpty((CharSequence)path);
    }

    protected boolean usesApiKey() {
        String key = this.getApiKey();
        return StringUtils.isNotEmpty((CharSequence)key);
    }

    protected List<Feature> buildFeatureList(List<VisionFeature> features, int maxResults) {
        ArrayList<Feature> requestFeatures = new ArrayList<Feature>();
        for (VisionFeature feature : features) {
            requestFeatures.add(new Feature().setType(feature.toString()).setMaxResults(Integer.valueOf(maxResults)));
        }
        return requestFeatures;
    }

    protected List<AnnotateImageRequest> buildRequestList(List<Blob> blobs, List<Feature> features) throws IOException {
        ArrayList<AnnotateImageRequest> requests = new ArrayList<AnnotateImageRequest>();
        for (Blob blob : blobs) {
            AnnotateImageRequest request = new AnnotateImageRequest().setImage(new Image().encodeContent(blob.getByteArray())).setFeatures(features);
            requests.add(request);
        }
        return requests;
    }
}

