/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.vision.google;

import com.google.api.services.vision.v1.model.AnnotateImageResponse;
import com.google.api.services.vision.v1.model.DominantColorsAnnotation;
import com.google.api.services.vision.v1.model.EntityAnnotation;
import com.google.api.services.vision.v1.model.ImageProperties;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import org.nuxeo.vision.core.image.ColorInfo;
import org.nuxeo.vision.core.image.TextEntity;
import org.nuxeo.vision.core.service.VisionResponse;

public class GoogleVisionResponse
implements VisionResponse {
    AnnotateImageResponse response;

    public GoogleVisionResponse(AnnotateImageResponse response) {
        this.response = response;
    }

    public List<TextEntity> getClassificationLabels() {
        ArrayList<TextEntity> results = new ArrayList<TextEntity>();
        if (this.response.getLabelAnnotations() != null) {
            results.addAll(this.processEntityAnnotationList(this.response.getLabelAnnotations()));
        }
        if (this.response.getLandmarkAnnotations() != null) {
            results.addAll(this.processEntityAnnotationList(this.response.getLandmarkAnnotations()));
        }
        if (this.response.getLogoAnnotations() != null) {
            results.addAll(this.processEntityAnnotationList(this.response.getLogoAnnotations()));
        }
        return results;
    }

    public List<TextEntity> getOcrText() {
        List labels = this.response.getTextAnnotations();
        return this.processEntityAnnotationList(labels);
    }

    public org.nuxeo.vision.core.image.ImageProperties getImageProperties() {
        ArrayList<ColorInfo> results = new ArrayList<ColorInfo>();
        ImageProperties properties = this.response.getImagePropertiesAnnotation();
        if (properties == null) {
            return new org.nuxeo.vision.core.image.ImageProperties(results);
        }
        DominantColorsAnnotation annotation = properties.getDominantColors();
        if (annotation == null) {
            return new org.nuxeo.vision.core.image.ImageProperties(results);
        }
        List colors = annotation.getColors();
        if (colors == null) {
            return new org.nuxeo.vision.core.image.ImageProperties(results);
        }
        for (com.google.api.services.vision.v1.model.ColorInfo colorInfo : colors) {
            com.google.api.services.vision.v1.model.Color color = colorInfo.getColor();
            float red = color.getRed() != null ? color.getRed().floatValue() / 255.0f : 0.0f;
            float blue = color.getBlue() != null ? color.getBlue().floatValue() / 255.0f : 0.0f;
            float green = color.getGreen() != null ? color.getGreen().floatValue() / 255.0f : 0.0f;
            Color resultColor = new Color(red, green, blue);
            results.add(new ColorInfo(resultColor, colorInfo.getPixelFraction().floatValue(), colorInfo.getScore().floatValue()));
        }
        return new org.nuxeo.vision.core.image.ImageProperties(results);
    }

    public Object getNativeObject() {
        return this.response;
    }

    protected List<TextEntity> processEntityAnnotationList(List<EntityAnnotation> annotations) {
        ArrayList<TextEntity> result = new ArrayList<TextEntity>();
        if (annotations == null) {
            return result;
        }
        for (EntityAnnotation annotation : annotations) {
            result.add(new TextEntity(annotation.getDescription(), annotation.getScore() != null ? annotation.getScore().floatValue() : 0.0f, annotation.getLocale()));
        }
        return result;
    }
}

