/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.vision.core.listener;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventContext;
import org.nuxeo.ecm.core.event.EventListener;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.ecm.core.work.api.Work;
import org.nuxeo.ecm.core.work.api.WorkManager;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.vision.core.worker.VideoVisionWorker;

public class VideoStoryboardChangedListener
implements EventListener {
    private static final Log log = LogFactory.getLog(VideoStoryboardChangedListener.class);

    public void handleEvent(Event event) {
        EventContext ectx = event.getContext();
        if (!(ectx instanceof DocumentEventContext)) {
            return;
        }
        DocumentEventContext docCtx = (DocumentEventContext)ectx;
        DocumentModel doc = docCtx.getSourceDocument();
        if (!doc.hasFacet("HasStoryboard") || doc.isProxy()) {
            return;
        }
        if (!doc.getProperty("vid:storyboard").isDirty()) {
            return;
        }
        VideoVisionWorker work = new VideoVisionWorker(doc.getRepositoryName(), doc.getId());
        WorkManager workManager = (WorkManager)Framework.getLocalService(WorkManager.class);
        workManager.schedule((Work)work, WorkManager.Scheduling.IF_NOT_SCHEDULED, true);
    }
}

