/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.vision.core.service;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.DefaultComponent;
import org.nuxeo.vision.core.service.Vision;
import org.nuxeo.vision.core.service.VisionDescriptor;
import org.nuxeo.vision.core.service.VisionFeature;
import org.nuxeo.vision.core.service.VisionProvider;
import org.nuxeo.vision.core.service.VisionProviderDescriptor;
import org.nuxeo.vision.core.service.VisionResponse;

public class VisionImpl
extends DefaultComponent
implements Vision {
    private static final Log log = LogFactory.getLog(VisionImpl.class);
    protected static final String CONFIG_EXT_POINT = "configuration";
    protected static final String PROVIDER_EXT_POINT = "provider";
    protected VisionDescriptor config = null;
    protected Map<String, VisionProvider> providers = new HashMap<String, VisionProvider>();

    public void activate(ComponentContext context) {
        super.activate(context);
    }

    public void deactivate(ComponentContext context) {
        super.deactivate(context);
    }

    public void applicationStarted(ComponentContext context) {
    }

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        if (CONFIG_EXT_POINT.equals(extensionPoint)) {
            this.config = (VisionDescriptor)contribution;
        } else if (PROVIDER_EXT_POINT.equals(extensionPoint)) {
            VisionProviderDescriptor desc = (VisionProviderDescriptor)contribution;
            try {
                VisionProvider provider = (VisionProvider)desc.getKlass().getConstructor(Map.class).newInstance(desc.getParameters());
                this.providers.put(desc.getProviderName(), provider);
            }
            catch (ReflectiveOperationException e) {
                throw new NuxeoException((Throwable)e);
            }
        }
    }

    public void unregisterContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
    }

    @Override
    public VisionResponse execute(Blob blob, List<VisionFeature> features, int maxResults) throws IOException, GeneralSecurityException, IllegalStateException {
        return this.execute(this.config.getDefaultProviderName(), blob, features, maxResults);
    }

    @Override
    public List<VisionResponse> execute(List<Blob> blobs, List<VisionFeature> features, int maxResults) throws IOException, GeneralSecurityException, IllegalStateException {
        return this.execute(this.config.getDefaultProviderName(), blobs, features, maxResults);
    }

    @Override
    public VisionResponse execute(String providerName, Blob blob, List<VisionFeature> features, int maxResults) throws IOException, GeneralSecurityException {
        if (blob == null) {
            throw new IllegalArgumentException("Input Blob cannot be null");
        }
        if (features == null || features.size() == 0) {
            throw new IllegalArgumentException("The feature list cannot be empty or null");
        }
        List<VisionResponse> results = this.execute(providerName, Arrays.asList(blob), features, maxResults);
        if (results.size() > 0) {
            return results.get(0);
        }
        throw new NuxeoException("Provider " + providerName + " vision returned empty results for " + blob.getFilename());
    }

    @Override
    public List<VisionResponse> execute(String providerName, List<Blob> blobs, List<VisionFeature> features, int maxResults) throws IOException, GeneralSecurityException {
        VisionProvider provider = this.providers.get(providerName);
        if (provider == null) {
            throw new NuxeoException("Unknown provider: " + providerName);
        }
        if (blobs == null || blobs.size() == 0) {
            throw new IllegalArgumentException("Input Blob list cannot be null or empty");
        }
        if (!provider.checkBlobs(blobs)) {
            throw new IllegalArgumentException("Too many blobs or size exceeds the API limit");
        }
        if (features == null || features.size() == 0) {
            throw new IllegalArgumentException("The feature list cannot be empty or null");
        }
        return provider.execute(blobs, features, maxResults);
    }

    @Override
    public String getPictureMapperChainName() {
        return this.config.getPictureMapperChainName();
    }

    @Override
    public String getVideoMapperChainName() {
        return this.config.getVideoMapperChainName();
    }

    @Override
    public String getDefaultProvider() {
        return this.config.getDefaultProviderName();
    }

    @Override
    public VisionProvider getProvider(String name) {
        return this.providers.get(name);
    }

    @Override
    public Map<String, VisionProvider> getProviders() {
        return this.providers;
    }
}

