/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.vision.core.worker;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.automation.AutomationService;
import org.nuxeo.ecm.automation.OperationChain;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.OperationException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventService;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.ecm.core.work.AbstractWork;
import org.nuxeo.ecm.core.work.api.Work;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.transaction.TransactionHelper;
import org.nuxeo.vision.core.service.Vision;

public class VideoVisionWorker
extends AbstractWork {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(VideoVisionWorker.class);

    public VideoVisionWorker(String repositoryName, String docId) {
        super(repositoryName + ':' + docId + ":Vision");
        this.setDocument(repositoryName, docId);
    }

    public void work() {
        this.setProgress(Work.Progress.PROGRESS_INDETERMINATE);
        this.setStatus("Extracting");
        if (!TransactionHelper.isTransactionActive()) {
            this.startTransaction();
        }
        this.initSession();
        if (!this.session.exists((DocumentRef)new IdRef(this.docId))) {
            this.setStatus("Nothing to process");
            return;
        }
        DocumentModel doc = this.session.getDocument((DocumentRef)new IdRef(this.docId));
        Vision visionService = (Vision)Framework.getService(Vision.class);
        String mapperChainName = visionService.getVideoMapperChainName();
        AutomationService as = (AutomationService)Framework.getService(AutomationService.class);
        OperationContext octx = new OperationContext();
        octx.setInput((Object)doc);
        octx.setCoreSession(this.session);
        OperationChain chain = new OperationChain("VideoChangedListenerChain");
        chain.add(mapperChainName);
        try {
            doc = (DocumentModel)as.run(octx, chain);
            this.session.saveDocument(doc);
            DocumentEventContext evctx = new DocumentEventContext(this.session, this.session.getPrincipal(), doc);
            Event eventToSend = evctx.newEvent("visionOnVideoDone");
            EventService eventService = (EventService)Framework.getLocalService(EventService.class);
            eventService.fireEvent(eventToSend);
        }
        catch (OperationException e) {
            log.warn((Object)e);
        }
        this.setStatus("Done");
    }

    public String getTitle() {
        return "VideoVisionWorker";
    }
}

