/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.csv.core;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.nuxeo.common.utils.Path;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.PathRef;
import org.nuxeo.ecm.core.api.impl.DocumentModelImpl;
import org.nuxeo.ecm.csv.core.CSVImporterDocumentFactory;
import org.nuxeo.ecm.csv.core.CSVImporterOptions;

public class DefaultCSVImporterDocumentFactory
implements CSVImporterDocumentFactory {
    private static final long serialVersionUID = 1L;
    public static final String DC_CREATOR = "dc:creator";
    public static final String DC_CONTRIBUTORS = "dc:contributors";
    public static final List<String> IGNORE_FIELDS_ON_UPDATE = Collections.singletonList("ecm:currentLifeCycleState");
    protected CSVImporterOptions importerOptions = CSVImporterOptions.DEFAULT_OPTIONS;

    @Override
    public void createDocument(CoreSession session, String parentPath, String name, String type, Map<String, Serializable> values) {
        values = this.prepareValues(values);
        DocumentModel doc = session.createDocumentModel(parentPath, name, type);
        if (this.importerOptions.importMode.equals((Object)CSVImporterOptions.ImportMode.IMPORT)) {
            this.setLifeCycleState(values, doc, "ecm:lifeCycleState");
            if (values.containsKey("ecm:uuid")) {
                ((DocumentModelImpl)doc).setId((String)((Object)values.get("ecm:uuid")));
                values.remove("ecm:uuid");
            } else {
                ((DocumentModelImpl)doc).setId(UUID.randomUUID().toString());
            }
            for (Map.Entry<String, Serializable> entry : values.entrySet()) {
                doc.setPropertyValue(entry.getKey(), entry.getValue());
            }
            session.importDocuments(Collections.singletonList(doc));
        } else {
            this.setLifeCycleState(values, doc, "initialLifecycleState");
            if (values.containsKey("ecm:uuid")) {
                throw new NuxeoException("CSV file contains UUID. Import using Import Mode to avoid overwriting.");
            }
            for (Map.Entry<String, Serializable> entry : values.entrySet()) {
                doc.setPropertyValue(entry.getKey(), entry.getValue());
            }
            session.createDocument(doc);
        }
    }

    protected void setLifeCycleState(Map<String, Serializable> values, DocumentModel doc, String lifeCyclePropertyName) {
        if (values.containsKey("ecm:currentLifeCycleState")) {
            doc.putContextData(lifeCyclePropertyName, values.get("ecm:currentLifeCycleState"));
            values.remove("ecm:currentLifeCycleState");
        }
    }

    protected Map<String, Serializable> prepareValues(Map<String, Serializable> values) {
        if (values.containsKey(DC_CREATOR)) {
            ArrayList<String> contributors;
            String creator = (String)((Object)values.get(DC_CREATOR));
            String[] contributorsArray = (String[])values.get(DC_CONTRIBUTORS);
            ArrayList<String> arrayList = contributors = contributorsArray == null ? new ArrayList<String>() : new ArrayList<String>(Arrays.asList(contributorsArray));
            if (StringUtils.isNotBlank((CharSequence)creator) && !contributors.contains(creator)) {
                contributors.add(creator);
            }
            values.put(DC_CONTRIBUTORS, (Serializable)contributors.toArray(new String[contributors.size()]));
        }
        return values;
    }

    @Override
    public void updateDocument(CoreSession session, DocumentRef docRef, Map<String, Serializable> values) {
        DocumentModel doc = session.getDocument(docRef);
        for (Map.Entry<String, Serializable> entry : values.entrySet()) {
            if (IGNORE_FIELDS_ON_UPDATE.contains(entry.getKey())) continue;
            doc.setPropertyValue(entry.getKey(), entry.getValue());
        }
        session.saveDocument(doc);
    }

    @Override
    public boolean exists(CoreSession session, String parentPath, String name, Map<String, Serializable> values) {
        String targetPath = new Path(parentPath).append(name).toString();
        PathRef docRef = new PathRef(targetPath);
        return session.exists((DocumentRef)docRef);
    }

    @Override
    @Deprecated
    public boolean exists(CoreSession session, String parentPath, String name, String type, Map<String, Serializable> values) {
        return this.exists(session, parentPath, name, null);
    }

    @Override
    public void setImporterOptions(CSVImporterOptions importerOptions) {
        this.importerOptions = importerOptions;
    }
}

