/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.drive.adapter.impl;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Iterator;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.nuxeo.drive.adapter.FileSystemItem;
import org.nuxeo.drive.adapter.FolderItem;
import org.nuxeo.drive.adapter.RootlessItemException;
import org.nuxeo.drive.adapter.impl.AbstractFileSystemItem;
import org.nuxeo.drive.service.FileSystemItemFactory;
import org.nuxeo.drive.service.NuxeoDriveManager;
import org.nuxeo.ecm.collections.api.CollectionManager;
import org.nuxeo.ecm.core.api.CloseableCoreSession;
import org.nuxeo.ecm.core.api.CoreInstance;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.DocumentSecurityException;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.api.trash.TrashService;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.services.config.ConfigurationService;

public abstract class AbstractDocumentBackedFileSystemItem
extends AbstractFileSystemItem {
    private static final Logger log = LogManager.getLogger(AbstractDocumentBackedFileSystemItem.class);
    protected static final String PERMISSION_CHECK_OPTIMIZED_PROPERTY = "org.nuxeo.drive.permissionCheckOptimized";
    protected String repositoryName;
    protected String docId;
    protected String docPath;
    protected String docTitle;

    protected AbstractDocumentBackedFileSystemItem(String factoryName, DocumentModel doc) {
        this(factoryName, doc, false);
    }

    protected AbstractDocumentBackedFileSystemItem(String factoryName, DocumentModel doc, boolean relaxSyncRootConstraint) {
        this(factoryName, doc, relaxSyncRootConstraint, true);
    }

    protected AbstractDocumentBackedFileSystemItem(String factoryName, DocumentModel doc, boolean relaxSyncRootConstraint, boolean getLockInfo) {
        block7: {
            this(factoryName, null, doc, relaxSyncRootConstraint, getLockInfo);
            CoreSession docSession = doc.getCoreSession();
            DocumentModel parentDoc = null;
            try {
                DocumentRef parentDocRef = docSession.getParentDocumentRef(doc.getRef());
                if (parentDocRef != null) {
                    parentDoc = docSession.getDocument(parentDocRef);
                }
            }
            catch (DocumentSecurityException e) {
                Supplier[] supplierArray = new Supplier[3];
                supplierArray[0] = () -> this.principal.getName();
                supplierArray[1] = () -> ((DocumentModel)doc).getPathAsString();
                supplierArray[2] = () -> ((DocumentModel)doc).getId();
                log.debug("User {} has no READ access on parent of document {} ({}), will throw RootlessItemException.", supplierArray);
            }
            try {
                if (parentDoc == null) {
                    log.trace("We either reached the root of the repository or a document for which the current user doesn't have read access to its parent, without being adapted to a (possibly virtual) descendant of the top level folder item. Let's raise a marker exception and let the caller give more information on the source document.");
                    throw new RootlessItemException();
                }
                FileSystemItem parent = this.getFileSystemItemAdapterService().getFileSystemItem(parentDoc, true, relaxSyncRootConstraint, getLockInfo);
                if (parent == null) {
                    log.trace("We reached a document for which the parent document cannot be  adapted to a (possibly virtual) descendant of the top level folder item. Let's raise a marker exception and let the caller give more information on the source document.");
                    throw new RootlessItemException();
                }
                this.parentId = parent.getId();
                this.path = parent.getPath() + "/" + this.id;
            }
            catch (RootlessItemException e) {
                log.trace("Let's try to adapt the document as a member of a collection sync root, if not the case let's raise a marker exception and let the caller give more information on the source document.");
                if (this.handleCollectionMember(doc, docSession, relaxSyncRootConstraint, getLockInfo)) break block7;
                throw new RootlessItemException();
            }
        }
    }

    protected boolean handleCollectionMember(DocumentModel doc, CoreSession session, boolean relaxSyncRootConstraint, boolean getLockInfo) {
        if (!doc.hasSchema("collectionMember")) {
            return false;
        }
        CollectionManager cm = (CollectionManager)Framework.getService(CollectionManager.class);
        List docCollections = cm.getVisibleCollection(doc, session);
        if (docCollections.isEmpty()) {
            Supplier[] supplierArray = new Supplier[2];
            supplierArray[0] = () -> ((DocumentModel)doc).getPathAsString();
            supplierArray[1] = () -> ((DocumentModel)doc).getId();
            log.trace("Doc {} ({}) is not member of any collection", supplierArray);
            return false;
        }
        FileSystemItem parent = null;
        DocumentModel collection = null;
        Iterator it = docCollections.iterator();
        while (it.hasNext() && parent == null) {
            collection = (DocumentModel)it.next();
            if (collection.getPathAsString().startsWith(doc.getPathAsString() + "/") && !((NuxeoDriveManager)Framework.getService(NuxeoDriveManager.class)).isSynchronizationRoot(session.getPrincipal(), collection)) continue;
            try {
                parent = this.getFileSystemItemAdapterService().getFileSystemItem(collection, true, relaxSyncRootConstraint, getLockInfo);
            }
            catch (RootlessItemException e) {
                Supplier[] supplierArray = new Supplier[4];
                supplierArray[0] = () -> ((DocumentModel)collection).getPathAsString();
                supplierArray[1] = () -> ((DocumentModel)collection).getId();
                supplierArray[2] = () -> ((DocumentModel)doc).getPathAsString();
                supplierArray[3] = () -> ((DocumentModel)doc).getId();
                log.trace("The collection {} ({}) of which doc {} ({}) is a member cannot be adapted as a FileSystemItem.", supplierArray);
            }
        }
        if (parent == null) {
            Supplier[] supplierArray = new Supplier[2];
            supplierArray[0] = () -> ((DocumentModel)doc).getPathAsString();
            supplierArray[1] = () -> ((DocumentModel)doc).getId();
            log.trace("None of the collections of which doc {} ({}) is a member can be adapted as a FileSystemItem.", supplierArray);
            return false;
        }
        Supplier[] supplierArray = new Supplier[4];
        supplierArray[0] = () -> ((DocumentModel)collection).getPathAsString();
        supplierArray[1] = () -> ((DocumentModel)collection).getId();
        supplierArray[2] = () -> ((DocumentModel)doc).getPathAsString();
        supplierArray[3] = () -> ((DocumentModel)doc).getId();
        log.trace("Using first collection {} ({}) of which doc {} ({}) is a member and that is adaptable as a FileSystemItem as a parent FileSystemItem.", supplierArray);
        this.parentId = parent.getId();
        this.path = parent.getPath() + "/" + this.id;
        return true;
    }

    protected AbstractDocumentBackedFileSystemItem(String factoryName, FolderItem parentItem, DocumentModel doc, boolean relaxSyncRootConstraint) {
        this(factoryName, parentItem, doc, relaxSyncRootConstraint, true);
    }

    protected AbstractDocumentBackedFileSystemItem(String factoryName, FolderItem parentItem, DocumentModel doc, boolean relaxSyncRootConstraint, boolean getLockInfo) {
        super(factoryName, doc.getCoreSession().getPrincipal(), relaxSyncRootConstraint);
        String parentPath;
        this.repositoryName = doc.getRepositoryName();
        this.docId = doc.getId();
        this.docPath = doc.getPathAsString();
        this.docTitle = doc.getTitle();
        this.id = this.computeId(this.docId);
        this.creator = (String)((Object)doc.getPropertyValue("dc:creator"));
        this.lastContributor = (String)((Object)doc.getPropertyValue("dc:lastContributor"));
        this.creationDate = (Calendar)doc.getPropertyValue("dc:created");
        this.lastModificationDate = (Calendar)doc.getPropertyValue("dc:modified");
        CoreSession docSession = doc.getCoreSession();
        this.canRename = !doc.hasFacet("PublishSpace") && !doc.isProxy() && docSession.hasPermission(doc.getRef(), "WriteProperties");
        DocumentRef parentRef = doc.getParentRef();
        boolean bl = this.canDelete = !doc.hasFacet("PublishSpace") && !doc.isProxy() && docSession.hasPermission(doc.getRef(), "Remove");
        if (this.canDelete && ((ConfigurationService)Framework.getService(ConfigurationService.class)).isBooleanFalse(PERMISSION_CHECK_OPTIMIZED_PROPERTY)) {
            boolean bl2 = this.canDelete = parentRef == null || docSession.hasPermission(parentRef, "RemoveChildren");
        }
        if (getLockInfo) {
            this.lockInfo = doc.getLockInfo();
        }
        if (parentItem != null) {
            this.parentId = parentItem.getId();
            parentPath = parentItem.getPath();
        } else {
            this.parentId = null;
            parentPath = "";
        }
        this.path = parentPath + "/" + this.id;
    }

    protected AbstractDocumentBackedFileSystemItem() {
    }

    @Override
    public void delete() {
        try (CloseableCoreSession session = CoreInstance.openCoreSession((String)this.repositoryName, (NuxeoPrincipal)this.principal);){
            DocumentModel doc = this.getDocument((CoreSession)session);
            FileSystemItemFactory parentFactory = this.getFileSystemItemAdapterService().getFileSystemItemFactoryForId(this.parentId);
            if ("collectionSyncRootFolderItemFactory".equals(parentFactory.getName())) {
                String[] idFragments = this.parseFileSystemId(this.parentId);
                String parentRepositoryName = idFragments[1];
                String parentDocId = idFragments[2];
                if (!parentRepositoryName.equals(this.repositoryName)) {
                    throw new UnsupportedOperationException(String.format("Found collection member: %s [repo=%s] in a different repository from the collection one: %s [repo=%s].", doc, this.repositoryName, parentDocId, parentRepositoryName));
                }
                DocumentModel collection = this.getDocumentById(parentDocId, (CoreSession)session);
                ((CollectionManager)Framework.getService(CollectionManager.class)).removeFromCollection(collection, doc, (CoreSession)session);
            } else {
                ArrayList<DocumentModel> docs = new ArrayList<DocumentModel>();
                docs.add(doc);
                this.getTrashService().trashDocuments(docs);
            }
        }
    }

    @Override
    public boolean canMove(FolderItem dest) {
        if (!this.canDelete) {
            return false;
        }
        AbstractDocumentBackedFileSystemItem docBackedDest = (AbstractDocumentBackedFileSystemItem)((Object)dest);
        String destRepoName = docBackedDest.getRepositoryName();
        IdRef destDocRef = new IdRef(docBackedDest.getDocId());
        String sessionRepo = this.repositoryName;
        if (!this.repositoryName.equals(destRepoName)) {
            sessionRepo = destRepoName;
        }
        try (CloseableCoreSession session = CoreInstance.openCoreSession((String)sessionRepo, (NuxeoPrincipal)this.principal);){
            boolean bl = session.hasPermission((DocumentRef)destDocRef, "AddChildren");
            return bl;
        }
    }

    @Override
    public FileSystemItem move(FolderItem dest) {
        IdRef sourceDocRef = new IdRef(this.docId);
        AbstractDocumentBackedFileSystemItem docBackedDest = (AbstractDocumentBackedFileSystemItem)((Object)dest);
        String destRepoName = docBackedDest.getRepositoryName();
        IdRef destDocRef = new IdRef(docBackedDest.getDocId());
        if (this.repositoryName.equals(destRepoName)) {
            try (CloseableCoreSession session = CoreInstance.openCoreSession((String)this.repositoryName, (NuxeoPrincipal)this.principal);){
                DocumentModel movedDoc = session.move((DocumentRef)sourceDocRef, (DocumentRef)destDocRef, null);
                session.save();
                FileSystemItem fileSystemItem = this.getFileSystemItemAdapterService().getFileSystemItem(movedDoc, dest);
                return fileSystemItem;
            }
        }
        throw new UnsupportedOperationException("Multi repository move is not supported yet.");
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    protected final String computeId(String docId) {
        StringBuilder sb = new StringBuilder();
        sb.append(super.getId());
        sb.append(this.repositoryName);
        sb.append("#");
        sb.append(docId);
        return sb.toString();
    }

    protected String getRepositoryName() {
        return this.repositoryName;
    }

    protected String getDocId() {
        return this.docId;
    }

    protected String getDocPath() {
        return this.docPath;
    }

    protected DocumentModel getDocument(CoreSession session) {
        return session.getDocument((DocumentRef)new IdRef(this.docId));
    }

    protected DocumentModel getDocumentById(String docId, CoreSession session) {
        return session.getDocument((DocumentRef)new IdRef(docId));
    }

    protected void updateLastModificationDate(DocumentModel doc) {
        this.lastModificationDate = (Calendar)doc.getPropertyValue("dc:modified");
    }

    protected TrashService getTrashService() {
        return (TrashService)Framework.getService(TrashService.class);
    }

    protected String[] parseFileSystemId(String id) {
        String[] idFragments = id.split("#");
        if (idFragments.length != 3) {
            throw new IllegalArgumentException(String.format("FileSystemItem id %s is not valid. Should match the 'fileSystemItemFactoryName#repositoryName#docId' pattern.", id));
        }
        return idFragments;
    }

    @Override
    protected void setId(String id) {
        super.setId(id);
        String[] idFragments = this.parseFileSystemId(id);
        this.factoryName = idFragments[0];
        this.repositoryName = idFragments[1];
        this.docId = idFragments[2];
    }
}

