/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.drive.service.impl;

import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.nuxeo.drive.service.impl.ActiveTopLevelFolderItemFactoryDescriptor;
import org.nuxeo.runtime.model.ContributionFragmentRegistry;

public class ActiveTopLevelFolderItemFactoryRegistry
extends ContributionFragmentRegistry<ActiveTopLevelFolderItemFactoryDescriptor> {
    private static final Logger log = LogManager.getLogger(ActiveTopLevelFolderItemFactoryRegistry.class);
    protected static final String CONTRIBUTION_ID = "activeTopLevelFolderItemFactoriesContrib";
    protected String activeFactory;

    public String getContributionId(ActiveTopLevelFolderItemFactoryDescriptor contrib) {
        return CONTRIBUTION_ID;
    }

    public void contributionUpdated(String id, ActiveTopLevelFolderItemFactoryDescriptor contrib, ActiveTopLevelFolderItemFactoryDescriptor newOrigContrib) {
        log.trace("Updating activeTopLevelFolderItemFactory contribution {}.", (Object)contrib);
        Supplier[] supplierArray = new Supplier[1];
        supplierArray[0] = contrib::getName;
        log.trace("Setting active factory to {}.", supplierArray);
        this.activeFactory = contrib.getName();
    }

    public void contributionRemoved(String id, ActiveTopLevelFolderItemFactoryDescriptor origContrib) {
        log.trace("Clearing active factory.");
        this.activeFactory = null;
    }

    public ActiveTopLevelFolderItemFactoryDescriptor clone(ActiveTopLevelFolderItemFactoryDescriptor orig) {
        log.trace("Cloning contribution {}.", (Object)orig);
        ActiveTopLevelFolderItemFactoryDescriptor clone = new ActiveTopLevelFolderItemFactoryDescriptor();
        clone.name = orig.name;
        return clone;
    }

    public void merge(ActiveTopLevelFolderItemFactoryDescriptor src, ActiveTopLevelFolderItemFactoryDescriptor dst) {
        log.trace("Merging contribution {} to contribution {}.", (Object)src, (Object)dst);
        if (!StringUtils.isEmpty((CharSequence)src.getName()) && !src.getName().equals(dst.getName())) {
            dst.setName(src.getName());
        }
    }
}

