/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.gcp;

import com.google.api.gax.paging.Page;
import com.google.auth.Credentials;
import com.google.auth.oauth2.GoogleCredentials;
import com.google.cloud.WriteChannel;
import com.google.cloud.storage.Blob;
import com.google.cloud.storage.BlobId;
import com.google.cloud.storage.BlobInfo;
import com.google.cloud.storage.Bucket;
import com.google.cloud.storage.BucketInfo;
import com.google.cloud.storage.Storage;
import com.google.cloud.storage.StorageOptions;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuxeo.common.Environment;
import org.nuxeo.ecm.blob.AbstractBinaryGarbageCollector;
import org.nuxeo.ecm.blob.AbstractCloudBinaryManager;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.blob.binary.BinaryGarbageCollector;
import org.nuxeo.ecm.core.blob.binary.CachingBinaryManager;
import org.nuxeo.ecm.core.blob.binary.FileStorage;

public class GoogleStorageBinaryManager
extends AbstractCloudBinaryManager {
    private static final Logger log = LogManager.getLogger(GoogleStorageBinaryManager.class);
    public static final String BUCKET_NAME_PROPERTY = "storage.bucket";
    public static final String BUCKET_PREFIX_PROPERTY = "storage.bucket_prefix";
    public static final String UPLOAD_CHUNK_SIZE_PROPERTY = "storage.upload.chunk.size";
    public static final int DEFAULT_UPLOAD_CHUNK_SIZE = 0x200000;
    public static final String PROJECT_ID_PROPERTY = "project";
    public static final String GOOGLE_APPLICATION_CREDENTIALS = "credentials";
    public static final String GOOGLE_PLATFORM_SCOPE = "https://www.googleapis.com/auth/cloud-platform";
    public static final String GOOGLE_STORAGE_SCOPE = "https://www.googleapis.com/auth/devstorage.full_control";
    public static final String SYSTEM_PROPERTY_PREFIX = "nuxeo.gcp";
    private static final Pattern MD5_RE = Pattern.compile("[0-9a-f]{32}");
    public static final String DELIMITER = "/";
    public static final String GCP_JSON_FILE = "gcp-credentials.json";
    protected String bucketName;
    protected String bucketPrefix;
    protected Bucket bucket;
    protected Storage storage;
    protected int chunkSize;

    protected void setupCloudClient() {
        try {
            String projectId = this.getProperty(PROJECT_ID_PROPERTY);
            Path credentialsPath = Path.of(this.getProperty(GOOGLE_APPLICATION_CREDENTIALS, GCP_JSON_FILE), new String[0]);
            if (!credentialsPath.isAbsolute()) {
                credentialsPath = Environment.getDefault().getConfig().toPath().resolve(credentialsPath);
            }
            GoogleCredentials credentials = GoogleCredentials.fromStream((InputStream)Files.newInputStream(credentialsPath, new OpenOption[0])).createScoped(new String[]{GOOGLE_PLATFORM_SCOPE, GOOGLE_STORAGE_SCOPE});
            credentials.refreshIfExpired();
            this.storage = (Storage)((StorageOptions.Builder)((StorageOptions.Builder)StorageOptions.newBuilder().setCredentials((Credentials)credentials)).setProjectId(projectId)).build().getService();
            this.bucketName = this.getProperty(BUCKET_NAME_PROPERTY);
            this.bucketPrefix = this.getProperty(BUCKET_PREFIX_PROPERTY, "");
            this.bucket = this.getOrCreateBucket(this.bucketName);
            this.chunkSize = this.getIntProperty(UPLOAD_CHUNK_SIZE_PROPERTY, 0x200000);
            if (!StringUtils.isBlank((CharSequence)this.bucketPrefix) && !this.bucketPrefix.endsWith(DELIMITER)) {
                log.warn("Google bucket prefix ({}): {} should end with '/': added automatically.", (Object)BUCKET_PREFIX_PROPERTY, (Object)this.bucketPrefix);
                this.bucketPrefix = this.bucketPrefix + DELIMITER;
            }
            if (StringUtils.isNotBlank((CharSequence)this.namespace)) {
                this.bucketPrefix = this.bucketPrefix + this.namespace;
                if (!this.bucketPrefix.endsWith(DELIMITER)) {
                    this.bucketPrefix = this.bucketPrefix + DELIMITER;
                }
            }
        }
        catch (IOException e) {
            throw new NuxeoException((Throwable)e);
        }
    }

    public Bucket getOrCreateBucket(String bucketName) {
        Bucket bucket = this.storage.get(bucketName, new Storage.BucketGetOption[0]);
        if (bucket == null) {
            log.debug("Creating a new bucket: {}", (Object)bucketName);
            return this.storage.create(BucketInfo.of((String)bucketName), new Storage.BucketTargetOption[0]);
        }
        return bucket;
    }

    public boolean deleteBucket(String bucketName) {
        Bucket bucket = this.storage.get(bucketName, new Storage.BucketGetOption[0]);
        for (Blob blob : this.storage.list(bucketName, new Storage.BlobListOption[0]).iterateAll()) {
            blob.delete(new Blob.BlobSourceOption[0]);
        }
        return bucket.exists(new Bucket.BucketSourceOption[0]) && this.storage.delete(bucketName, new Storage.BucketSourceOption[0]);
    }

    public Bucket getBucket() {
        return this.bucket;
    }

    protected FileStorage getFileStorage() {
        return new GCPFileStorage();
    }

    protected String getSystemPropertyPrefix() {
        return SYSTEM_PROPERTY_PREFIX;
    }

    protected static boolean isMD5(String digest) {
        return MD5_RE.matcher(digest).matches();
    }

    protected BinaryGarbageCollector instantiateGarbageCollector() {
        return new GoogleStorageBinaryGarbageCollector(this);
    }

    public void removeBinaries(Collection<String> digests) {
        digests.forEach(this::removeBinary);
    }

    protected void removeBinary(String digest) {
        this.storage.delete(BlobId.of((String)this.bucket.getName(), (String)(this.bucketPrefix + digest)));
    }

    public static class GoogleStorageBinaryGarbageCollector
    extends AbstractBinaryGarbageCollector<GoogleStorageBinaryManager> {
        protected GoogleStorageBinaryGarbageCollector(GoogleStorageBinaryManager binaryManager) {
            super((CachingBinaryManager)binaryManager);
        }

        public String getId() {
            return "gcs:" + ((GoogleStorageBinaryManager)this.binaryManager).bucketName;
        }

        public Set<String> getUnmarkedBlobs() {
            HashSet<String> unmarked = new HashSet<String>();
            Page blobs = ((GoogleStorageBinaryManager)this.binaryManager).getBucket().list(new Storage.BlobListOption[]{Storage.BlobListOption.fields((Storage.BlobField[])new Storage.BlobField[]{Storage.BlobField.ID, Storage.BlobField.SIZE}), Storage.BlobListOption.prefix((String)((GoogleStorageBinaryManager)this.binaryManager).bucketPrefix)});
            do {
                int prefixLength = ((GoogleStorageBinaryManager)this.binaryManager).bucketPrefix.length();
                for (Blob blob : blobs.iterateAll()) {
                    String digest = blob.getName().substring(prefixLength);
                    if (!GoogleStorageBinaryManager.isMD5(digest)) continue;
                    if (this.marked.contains(digest)) {
                        ++this.status.numBinaries;
                        this.status.sizeBinaries += blob.getSize().longValue();
                        continue;
                    }
                    ++this.status.numBinariesGC;
                    this.status.sizeBinariesGC += blob.getSize().longValue();
                    unmarked.add(digest);
                    this.marked.remove(digest);
                }
            } while ((blobs = blobs.getNextPage()) != null);
            return unmarked;
        }
    }

    public class GCPFileStorage
    implements FileStorage {
        public void storeFile(String digest, File file) {
            long t0 = System.currentTimeMillis();
            log.debug("Storing blob with digest: {} to GCS", (Object)digest);
            String key = GoogleStorageBinaryManager.this.bucketPrefix + digest;
            if (GoogleStorageBinaryManager.this.bucket.get(key, new Storage.BlobGetOption[0]) == null) {
                try (BufferedInputStream is = new BufferedInputStream(new FileInputStream(file));
                     WriteChannel writer = GoogleStorageBinaryManager.this.storage.writer(BlobInfo.newBuilder((String)GoogleStorageBinaryManager.this.bucketName, (String)key).build(), new Storage.BlobWriteOption[0]);){
                    int bufferLength;
                    byte[] buffer = new byte[GoogleStorageBinaryManager.this.chunkSize];
                    writer.setChunkSize(GoogleStorageBinaryManager.this.chunkSize);
                    while ((bufferLength = IOUtils.read((InputStream)is, (byte[])buffer)) > 0) {
                        writer.write(ByteBuffer.wrap(buffer, 0, bufferLength));
                    }
                }
                catch (IOException e) {
                    throw new NuxeoException((Throwable)e);
                }
                log.debug("Stored blob with digest: {} to GCS in {}ms", (Object)digest, (Object)(System.currentTimeMillis() - t0));
            } else {
                log.debug("Blob with digest: {} is already in GCS", (Object)digest);
            }
        }

        public boolean fetchFile(String key, File file) {
            Blob blob = GoogleStorageBinaryManager.this.bucket.get(GoogleStorageBinaryManager.this.bucketPrefix + key, new Storage.BlobGetOption[0]);
            if (blob != null) {
                blob.downloadTo(file.toPath());
                return true;
            }
            return false;
        }
    }
}

