/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.oauth2.openid.auth;

import com.google.api.client.json.GenericJson;
import com.google.api.client.util.DateTime;
import com.google.api.client.util.Key;
import java.util.Date;
import org.nuxeo.ecm.platform.oauth2.openid.auth.OpenIDUserInfo;

public class DefaultOpenIDUserInfo
extends GenericJson
implements OpenIDUserInfo {
    @Key(value="sub")
    protected String subject;
    @Key(value="name")
    protected String name;
    @Key(value="given_name")
    protected String givenName;
    @Key(value="family_name")
    protected String familyName;
    @Key(value="middle_name")
    protected String middleName;
    @Key(value="nickname")
    protected String nickname;
    @Key(value="preferred_username")
    protected String preferredUsername;
    @Key(value="profile")
    protected String profile;
    @Key(value="picture")
    protected String picture;
    @Key(value="website")
    protected String website;
    @Key(value="email")
    protected String email;
    @Key(value="email_verified")
    protected boolean emailVerified;
    @Key(value="gender")
    protected String gender;
    @Key(value="birthdate")
    protected Date birthdate;
    @Key(value="zoneinfo")
    protected String zoneInfo;
    @Key(value="locale")
    protected String locale;
    @Key(value="phone_number")
    protected String phoneNumber;
    @Key(value="address")
    protected String address;
    @Key(value="updated_time")
    protected String updatedTime;

    @Override
    public String getSubject() {
        return this.subject;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getGivenName() {
        return this.givenName;
    }

    @Override
    public String getFamilyName() {
        return this.familyName;
    }

    @Override
    public String getMiddleName() {
        return this.middleName;
    }

    @Override
    public String getNickname() {
        return this.nickname;
    }

    @Override
    public String getPreferredUsername() {
        return this.preferredUsername;
    }

    @Override
    public String getProfile() {
        return this.profile;
    }

    @Override
    public String getPicture() {
        return this.picture;
    }

    @Override
    public String getWebsite() {
        return this.website;
    }

    @Override
    public String getEmail() {
        return this.email;
    }

    @Override
    public boolean isEmailVerified() {
        return this.emailVerified;
    }

    @Override
    public String getGender() {
        return this.gender;
    }

    @Override
    public Date getBirthdate() {
        return this.birthdate;
    }

    @Override
    public String getZoneInfo() {
        return this.zoneInfo;
    }

    @Override
    public String getLocale() {
        return this.locale;
    }

    @Override
    public String getPhoneNumber() {
        return this.phoneNumber;
    }

    @Override
    public String getAddress() {
        return this.address;
    }

    @Override
    public Date getUpdatedTime() {
        Date date;
        try {
            DateTime dateTime = DateTime.parseRfc3339((String)this.updatedTime);
            date = new Date(dateTime.getValue());
        }
        catch (NumberFormatException e) {
            return null;
        }
        return date;
    }
}

