/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.oauth2.openid;

import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XNodeList;
import org.nuxeo.common.xmap.annotation.XObject;
import org.nuxeo.ecm.platform.oauth2.openid.RedirectUriResolver;
import org.nuxeo.ecm.platform.oauth2.openid.RedirectUriResolverHelper;
import org.nuxeo.ecm.platform.oauth2.openid.auth.DefaultOpenIDUserInfo;
import org.nuxeo.ecm.platform.oauth2.openid.auth.EmailBasedUserResolver;
import org.nuxeo.ecm.platform.oauth2.openid.auth.OpenIDUserInfo;
import org.nuxeo.ecm.platform.oauth2.openid.auth.UserResolver;
import org.nuxeo.runtime.model.Descriptor;

@XObject(value="provider")
public class OpenIDConnectProviderDescriptor
implements Descriptor {
    protected static final long serialVersionUID = 1L;
    public static final String DEFAULT_ACCESS_TOKEN_KEY = "access_token";
    public static final Class<? extends UserResolver> DEFAULT_USER_RESOLVER_CLASS = EmailBasedUserResolver.class;
    public static final Class<? extends RedirectUriResolver> DEFAULT_REDIRECT_URI_RESOLVER_CLASS = RedirectUriResolverHelper.class;
    public static final Class<? extends OpenIDUserInfo> DEFAULT_USER_INFO_CLASS = DefaultOpenIDUserInfo.class;
    public static final String URL_AUTHENTICATION_METHOD = "url";
    public static final String BEARER_AUTHENTICATION_METHOD = "bearer";
    public static final String DEFAULT_AUTHENTICATION_METHOD = "url";
    @XNode(value="@enabled")
    protected boolean enabled = true;
    @XNode(value="name")
    protected String name;
    @XNode(value="tokenServerURL")
    protected String tokenServerURL;
    @XNode(value="authorizationServerURL")
    protected String authorizationServerURL;
    @XNode(value="userInfoURL")
    protected String userInfoURL;
    @XNode(value="accessTokenKey")
    protected String accessTokenKey = "access_token";
    @XNode(value="clientId")
    protected String clientId;
    @XNode(value="clientSecret")
    protected String clientSecret;
    @XNodeList(value="scope", type=String[].class, componentType=String.class)
    protected String[] scopes;
    @XNode(value="icon")
    protected String icon;
    @XNode(value="label")
    protected String label;
    @XNode(value="description")
    protected String description;
    @XNode(value="userResolverClass")
    protected Class<? extends UserResolver> userResolverClass;
    @XNode(value="userMapperName")
    protected String userMapper;
    @XNode(value="redirectUriResolver")
    protected Class<? extends RedirectUriResolver> redirectUriResolver = DEFAULT_REDIRECT_URI_RESOLVER_CLASS;
    @XNode(value="userInfoClass")
    protected Class<? extends OpenIDUserInfo> userInfoClass = DEFAULT_USER_INFO_CLASS;
    @XNode(value="authenticationMethod")
    protected String authenticationMethod = "url";

    public static long getSerialversionuid() {
        return 1L;
    }

    public String getId() {
        return this.getName();
    }

    public String getName() {
        return this.name;
    }

    public String getTokenServerURL() {
        return this.tokenServerURL;
    }

    public String getAuthorizationServerURL() {
        return this.authorizationServerURL;
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    public String[] getScopes() {
        return this.scopes;
    }

    public String getUserInfoURL() {
        return this.userInfoURL;
    }

    public String getAccessTokenKey() {
        return this.accessTokenKey;
    }

    public String getIcon() {
        return this.icon;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public String getLabel() {
        return this.label;
    }

    public String getDescription() {
        return this.description;
    }

    public String getUserMapper() {
        return this.userMapper;
    }

    public Class<? extends UserResolver> getUserResolverClass() {
        if (this.userResolverClass == null && this.userMapper == null) {
            return DEFAULT_USER_RESOLVER_CLASS;
        }
        return this.userResolverClass;
    }

    public Class<? extends RedirectUriResolver> getRedirectUriResolver() {
        return this.redirectUriResolver;
    }

    public Class<? extends OpenIDUserInfo> getUserInfoClass() {
        return this.userInfoClass;
    }

    public String getAuthenticationMethod() {
        return this.authenticationMethod;
    }

    public Descriptor merge(Descriptor o) {
        OpenIDConnectProviderDescriptor other = (OpenIDConnectProviderDescriptor)o;
        OpenIDConnectProviderDescriptor merged = new OpenIDConnectProviderDescriptor();
        merged.name = this.name;
        merged.enabled = other.enabled;
        merged.authorizationServerURL = StringUtils.isNotBlank((CharSequence)other.authorizationServerURL) ? other.authorizationServerURL : this.authorizationServerURL;
        merged.clientId = StringUtils.isNotBlank((CharSequence)other.clientId) ? other.clientId : this.clientId;
        merged.clientSecret = StringUtils.isNotBlank((CharSequence)other.clientSecret) ? other.clientSecret : this.clientSecret;
        merged.icon = StringUtils.isNotBlank((CharSequence)other.icon) ? other.icon : this.icon;
        merged.scopes = ArrayUtils.isNotEmpty((Object[])other.scopes) ? other.scopes : this.scopes;
        merged.tokenServerURL = StringUtils.isNotBlank((CharSequence)other.tokenServerURL) ? other.tokenServerURL : this.tokenServerURL;
        merged.userInfoURL = StringUtils.isNotBlank((CharSequence)other.userInfoURL) ? other.userInfoURL : this.userInfoURL;
        merged.label = StringUtils.isNotBlank((CharSequence)other.label) ? other.label : this.label;
        merged.description = StringUtils.isNotBlank((CharSequence)other.description) ? other.description : this.description;
        merged.accessTokenKey = !other.accessTokenKey.equals(DEFAULT_ACCESS_TOKEN_KEY) ? other.accessTokenKey : this.accessTokenKey;
        merged.userInfoClass = other.userInfoClass != DEFAULT_USER_INFO_CLASS ? other.userInfoClass : this.userInfoClass;
        merged.redirectUriResolver = other.redirectUriResolver != DEFAULT_REDIRECT_URI_RESOLVER_CLASS ? other.redirectUriResolver : this.redirectUriResolver;
        Class<? extends UserResolver> otherUserResolverClass = other.getUserResolverClass();
        merged.userResolverClass = otherUserResolverClass != DEFAULT_USER_RESOLVER_CLASS ? otherUserResolverClass : this.userResolverClass;
        merged.userMapper = StringUtils.isNotBlank((CharSequence)other.userMapper) ? other.userMapper : this.userMapper;
        merged.authenticationMethod = !other.authenticationMethod.equals("url") ? other.authenticationMethod : this.authenticationMethod;
        return merged;
    }
}

