/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.oauth2.openid;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuxeo.common.xmap.Context;
import org.nuxeo.common.xmap.XAnnotatedObject;
import org.nuxeo.common.xmap.registry.MapRegistry;
import org.nuxeo.ecm.platform.oauth2.openid.OpenIDConnectProviderDescriptor;
import org.w3c.dom.Element;

public class OpenIDDescriptorRegistry
extends MapRegistry {
    private static final Logger log = LogManager.getLogger(OpenIDDescriptorRegistry.class);

    protected <T> T doRegister(Context ctx, XAnnotatedObject xObject, Element element, String extensionId) {
        OpenIDConnectProviderDescriptor provider = (OpenIDConnectProviderDescriptor)super.doRegister(ctx, xObject, element, extensionId);
        if (provider != null && provider.isEnabled() && (provider.getClientId() == null || provider.getClientSecret() == null)) {
            log.info("OpenId provider for '{}', contributed by '{}', is disabled because clientId and/or clientSecret are empty", (Object)provider.getName(), (Object)extensionId);
            provider.setEnabled(false);
            this.disabled.add(provider.getId());
        }
        return (T)provider;
    }
}

