/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.quota;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.quota.QuotaStatsUpdater;
import org.nuxeo.ecm.quota.QuotaStatsUpdaterDescriptor;
import org.nuxeo.runtime.model.ContributionFragmentRegistry;

public class QuotaStatsUpdaterRegistry
extends ContributionFragmentRegistry<QuotaStatsUpdaterDescriptor> {
    protected Map<String, QuotaStatsUpdater> quotaStatsUpdaters = new HashMap<String, QuotaStatsUpdater>();

    public QuotaStatsUpdater getQuotaStatsUpdater(String name) {
        return this.quotaStatsUpdaters.get(name);
    }

    public List<QuotaStatsUpdater> getQuotaStatsUpdaters() {
        return new ArrayList<QuotaStatsUpdater>(this.quotaStatsUpdaters.values());
    }

    public String getContributionId(QuotaStatsUpdaterDescriptor descriptor) {
        return descriptor.getName();
    }

    public void contributionUpdated(String id, QuotaStatsUpdaterDescriptor contrib, QuotaStatsUpdaterDescriptor newOrigContrib) {
        if (contrib.isEnabled()) {
            try {
                QuotaStatsUpdater updater = contrib.getQuotaStatsUpdaterClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                updater.setName(contrib.getName());
                updater.setLabel(contrib.getLabel());
                updater.setDescriptionLabel(contrib.getDescriptionLabel());
                this.quotaStatsUpdaters.put(id, updater);
            }
            catch (ReflectiveOperationException e) {
                throw new NuxeoException((Throwable)e);
            }
        } else {
            this.quotaStatsUpdaters.remove(id);
        }
    }

    public void contributionRemoved(String id, QuotaStatsUpdaterDescriptor descriptor) {
        this.quotaStatsUpdaters.remove(id);
    }

    public QuotaStatsUpdaterDescriptor clone(QuotaStatsUpdaterDescriptor descriptor) {
        return descriptor.clone();
    }

    public void merge(QuotaStatsUpdaterDescriptor src, QuotaStatsUpdaterDescriptor dst) {
        dst.setQuotaStatsUpdaterClass(src.getQuotaStatsUpdaterClass());
        dst.setEnabled(src.isEnabled());
        dst.setLabel(src.getLabel());
        dst.setDescriptionLabel(src.getDescriptionLabel());
    }
}

