/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml2.core.validator;

import org.opensaml.common.SAMLVersion;
import org.opensaml.saml2.core.RequestAbstractType;
import org.opensaml.xml.util.DatatypeHelper;
import org.opensaml.xml.validation.ValidationException;
import org.opensaml.xml.validation.Validator;

public abstract class RequestAbstractTypeSchemaValidator<RequestType extends RequestAbstractType>
implements Validator<RequestType> {
    public void validate(RequestType request) throws ValidationException {
        this.validateID((RequestAbstractType)request);
        this.validateVersion((RequestAbstractType)request);
        this.validateIssueInstant((RequestAbstractType)request);
    }

    protected void validateID(RequestAbstractType request) throws ValidationException {
        if (DatatypeHelper.isEmpty((String)request.getID())) {
            throw new ValidationException("ID attribute must not be empty");
        }
    }

    protected void validateVersion(RequestAbstractType request) throws ValidationException {
        if (request.getVersion() == null) {
            throw new ValidationException("Version attribute must not be null");
        }
        if (!DatatypeHelper.safeEquals((Object)request.getVersion().toString(), (Object)SAMLVersion.VERSION_20.toString())) {
            throw new ValidationException("Wrong SAML Version");
        }
    }

    protected void validateIssueInstant(RequestAbstractType request) throws ValidationException {
        if (request.getIssueInstant() == null) {
            throw new ValidationException("IssueInstant attribute must not be null");
        }
    }
}

