/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.esapi.crypto;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.owasp.esapi.ESAPI;
import org.owasp.esapi.Encryptor;
import org.owasp.esapi.Logger;
import org.owasp.esapi.crypto.CipherText;
import org.owasp.esapi.crypto.PlainText;
import org.owasp.esapi.errors.ConfigurationException;
import org.owasp.esapi.errors.EncodingException;
import org.owasp.esapi.errors.EncryptionException;
import org.owasp.esapi.errors.EncryptionRuntimeException;
import org.owasp.esapi.errors.ValidationException;

public class CryptoToken {
    public static final String ANONYMOUS_USER = "<anonymous>";
    private static final long DEFAULT_EXP_TIME = 300000L;
    private static final String DELIM = ";";
    private static final char DELIM_CHAR = ';';
    private static final char QUOTE_CHAR = '\\';
    private static final String ATTR_NAME_REGEX = "[A-Za-z0-9_.-]+";
    private static final String USERNAME_REGEX = "[a-z][a-z0-9_.@-]*";
    private static Logger logger = ESAPI.getLogger("CryptoToken");
    private String username = "<anonymous>";
    private long expirationTime = 0L;
    private TreeMap<String, String> attributes = new TreeMap();
    private transient SecretKey secretKey = null;
    private Pattern attrNameRegex = Pattern.compile("[A-Za-z0-9_.-]+");
    private Pattern userNameRegex = Pattern.compile("[a-z][a-z0-9_.@-]*");

    public CryptoToken() {
        this.secretKey = this.getDefaultSecretKey(ESAPI.securityConfiguration().getEncryptionAlgorithm());
        long now = System.currentTimeMillis();
        this.expirationTime = now + 300000L;
    }

    public CryptoToken(SecretKey skey) {
        if (skey == null) {
            throw new IllegalArgumentException("SecretKey may not be null.");
        }
        this.secretKey = skey;
        long now = System.currentTimeMillis();
        this.expirationTime = now + 300000L;
    }

    public CryptoToken(String token) throws EncryptionException {
        this.secretKey = this.getDefaultSecretKey(ESAPI.securityConfiguration().getEncryptionAlgorithm());
        try {
            this.decryptToken(this.secretKey, token);
        }
        catch (EncodingException e) {
            throw new EncryptionException("Decryption of token failed. Token improperly encoded or encrypted with different key.", "Can't decrypt token because not correctly encoded or encrypted with different key.", e);
        }
        if (this.username == null) {
            throw new IllegalArgumentException("Programming error or malformed token: Decrypted token found username null.");
        }
        if (this.expirationTime <= 0L) {
            throw new IllegalArgumentException("Programming error or malformed token: Decrypted token found expirationTime <= 0.");
        }
    }

    public CryptoToken(SecretKey skey, String token) throws EncryptionException {
        if (skey == null) {
            throw new IllegalArgumentException("SecretKey may not be null.");
        }
        if (token == null) {
            throw new IllegalArgumentException("Token may not be null");
        }
        this.secretKey = skey;
        try {
            this.decryptToken(this.secretKey, token);
        }
        catch (EncodingException e) {
            throw new EncryptionException("Decryption of token failed. Token improperly encoded.", "Can't decrypt token because not correctly encoded.", e);
        }
        if (this.username == null) {
            String exm = "Programming error???: Decrypted token found username null.";
            throw new EncryptionException(exm, exm);
        }
        if (this.expirationTime <= 0L) {
            String exm = "Programming error???: Decrypted token found expirationTime <= 0.";
            throw new EncryptionException(exm, exm);
        }
    }

    public String getUserAccountName() {
        return this.username != null ? this.username : ANONYMOUS_USER;
    }

    public void setUserAccountName(String userAccountName) throws ValidationException {
        if (userAccountName == null) {
            throw new IllegalArgumentException("User account name may not be null.");
        }
        String userAcct = userAccountName.toLowerCase();
        Matcher userNameChecker = this.userNameRegex.matcher(userAcct);
        if (!userNameChecker.matches()) {
            throw new ValidationException("Invalid user account name encountered.", "User account name " + userAccountName + " does not match regex " + USERNAME_REGEX + " after conversion to lowercase.");
        }
        this.username = userAcct;
    }

    public boolean isExpired() {
        return System.currentTimeMillis() > this.expirationTime;
    }

    public void setExpiration(int intervalSecs) throws IllegalArgumentException {
        int intervalMillis = intervalSecs * 1000;
        if (intervalMillis <= 0) {
            throw new IllegalArgumentException("intervalSecs argument, converted to millisecs, must be > 0.");
        }
        long now = System.currentTimeMillis();
        CryptoToken.preAdd(now, intervalMillis);
        this.expirationTime = now + (long)intervalMillis;
    }

    public void setExpiration(Date expirationDate) throws IllegalArgumentException {
        if (expirationDate == null) {
            throw new IllegalArgumentException("expirationDate may not be null.");
        }
        long curTime = System.currentTimeMillis();
        long expTime = expirationDate.getTime();
        if (expTime <= curTime) {
            throw new IllegalArgumentException("Expiration date must be after current date/time.");
        }
        this.expirationTime = expTime;
    }

    public long getExpiration() {
        assert (this.expirationTime > 0L) : "Programming error: Expiration time <= 0";
        return this.expirationTime;
    }

    public Date getExpirationDate() {
        return new Date(this.getExpiration());
    }

    public void setAttribute(String name, String value) throws ValidationException {
        if (name == null || name.length() == 0) {
            throw new ValidationException("Null or empty attribute NAME encountered", "Attribute NAMES may not be null or empty string.");
        }
        if (value == null) {
            throw new ValidationException("Null attribute VALUE encountered for attr name " + name, "Attribute VALUE may not be null; attr name: " + name);
        }
        Matcher attrNameChecker = this.attrNameRegex.matcher(name);
        if (!attrNameChecker.matches()) {
            throw new ValidationException("Invalid attribute name encountered.", "Attribute name " + name + " does not match regex " + ATTR_NAME_REGEX);
        }
        this.attributes.put(name, value);
    }

    public void addAttributes(Map<String, String> attrs) throws ValidationException {
        if (attrs == null) {
            throw new IllegalArgumentException("Attribute map may not be null.");
        }
        Set<Map.Entry<String, String>> keyValueSet = attrs.entrySet();
        for (Map.Entry<String, String> entry : keyValueSet) {
            String key = entry.getKey();
            String value = entry.getValue();
            this.setAttribute(key, value);
        }
    }

    public String getAttribute(String name) {
        return this.attributes.get(name);
    }

    public Map<String, String> getAttributes() {
        return (Map)this.attributes.clone();
    }

    public void clearAttributes() {
        this.attributes.clear();
    }

    public String getToken(SecretKey skey) throws EncryptionException {
        return this.createEncryptedToken(skey);
    }

    public String updateToken(int additionalSecs) throws EncryptionException, ValidationException {
        if (additionalSecs < 0) {
            throw new IllegalArgumentException("additionalSecs argument must be >= 0.");
        }
        long curExpTime = this.getExpiration();
        CryptoToken.preAdd(curExpTime, additionalSecs * 1000);
        this.expirationTime = curExpTime + (long)(additionalSecs * 1000);
        if (this.isExpired()) {
            this.expirationTime = curExpTime;
            throw new ValidationException("Token timed out.", "Cryptographic token not increased to sufficient value to prevent timeout.");
        }
        return this.getToken();
    }

    public String getToken() throws EncryptionException {
        return this.createEncryptedToken(this.secretKey);
    }

    private String createEncryptedToken(SecretKey skey) throws EncryptionException {
        StringBuilder sb = new StringBuilder(this.getUserAccountName() + DELIM);
        sb.append(this.getExpiration()).append(DELIM);
        sb.append(this.getQuotedAttributes());
        Encryptor encryptor = ESAPI.encryptor();
        CipherText ct = encryptor.encrypt(skey, new PlainText(sb.toString()));
        String b64 = ESAPI.encoder().encodeForBase64(ct.asPortableSerializedByteArray(), false);
        return b64;
    }

    private String getQuotedAttributes() {
        StringBuilder sb = new StringBuilder();
        Set<Map.Entry<String, String>> keyValueSet = this.attributes.entrySet();
        for (Map.Entry<String, String> entry : keyValueSet) {
            String key = entry.getKey();
            String value = entry.getValue();
            logger.debug(Logger.EVENT_UNSPECIFIED, "   " + key + " -> <not shown>");
            sb.append(key + "=" + CryptoToken.quoteAttributeValue(value) + DELIM);
        }
        return sb.toString();
    }

    private static String quoteAttributeValue(String value) {
        if (value == null) {
            String exm = "Programming error???: Value should not be null.";
            throw new EncryptionRuntimeException(exm, exm);
        }
        StringBuilder sb = new StringBuilder();
        char[] charArray = value.toCharArray();
        for (int i = 0; i < charArray.length; ++i) {
            char c = charArray[i];
            if (c == '\\' || c == '=' || c == ';') {
                sb.append('\\').append(c);
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    private static String parseQuotedValue(String quotedValue) {
        StringBuilder sb = new StringBuilder();
        char[] charArray = quotedValue.toCharArray();
        for (int i = 0; i < charArray.length; ++i) {
            char c = charArray[i];
            if (c == '\\') {
                sb.append(charArray[++i]);
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    private void decryptToken(SecretKey skey, String b64token) throws EncryptionException, EncodingException {
        byte[] token = null;
        try {
            token = ESAPI.encoder().decodeFromBase64(b64token);
        }
        catch (IOException e) {
            throw new EncodingException("Invalid base64 encoding.", "Invalid base64 encoding for token [REDACTED]");
        }
        CipherText ct = CipherText.fromPortableSerializedBytes(token);
        Encryptor encryptor = ESAPI.encryptor();
        PlainText pt = encryptor.decrypt(skey, ct);
        String str = pt.toString();
        if (!str.endsWith(DELIM)) {
            String exm = "Programming error???: Expecting decrypted token to end with delim char, ;";
            throw new EncryptionException(exm, exm);
        }
        char[] charArray = str.toCharArray();
        int prevPos = -1;
        int fieldNo = 0;
        ArrayList<String> fields = new ArrayList<String>();
        int lastPos = charArray.length;
        for (int curPos = 0; curPos < lastPos; ++curPos) {
            boolean quoted = false;
            int curChar = charArray[curPos];
            if (curChar == 92) {
                ++curPos;
                if (curChar != lastPos) {
                    curChar = charArray[curPos + 1];
                    quoted = true;
                } else {
                    curChar = 59;
                }
            }
            if (curChar != 59 || quoted) continue;
            String record = str.substring(prevPos + 1, curPos);
            fields.add(record);
            ++fieldNo;
            prevPos = curPos;
        }
        Object[] objArray = fields.toArray();
        if (fieldNo != objArray.length) {
            String exm = "Programming error???: Mismatch of delimited field count.";
            throw new EncryptionException(exm, exm);
        }
        logger.debug(Logger.EVENT_UNSPECIFIED, "Found " + objArray.length + " fields.");
        if (objArray.length < 2) {
            String exm = "Missing mandatory fields from decrypted token (username &/or expiration time).";
            throw new EncryptionException(exm, exm);
        }
        this.username = ((String)objArray[0]).toLowerCase();
        String expTime = (String)objArray[1];
        this.expirationTime = Long.parseLong(expTime);
        for (int i = 2; i < objArray.length; ++i) {
            String nvpair = (String)objArray[i];
            int equalsAt = nvpair.indexOf("=");
            if (equalsAt == -1) {
                throw new EncryptionException("Invalid attribute encountered in decrypted token.", "Malformed attribute name/value pair (" + nvpair + ") found in decrypted token.");
            }
            String name = nvpair.substring(0, equalsAt);
            String quotedValue = nvpair.substring(equalsAt + 1);
            String value = CryptoToken.parseQuotedValue(quotedValue);
            logger.debug(Logger.EVENT_UNSPECIFIED, "Attribute[" + i + "]: name=" + name + ", value=<not shown>");
            Matcher attrNameChecker = this.attrNameRegex.matcher(name);
            if (!attrNameChecker.matches()) {
                throw new EncryptionException("Invalid attribute name encountered in decrypted token.", "Invalid attribute name encountered in decrypted token; attribute name " + name + " does not match regex " + ATTR_NAME_REGEX);
            }
            this.attributes.put(name, value);
            this.attributes.put(name, value);
        }
    }

    private SecretKey getDefaultSecretKey(String encryptAlgorithm) {
        if (encryptAlgorithm == null) {
            throw new IllegalArgumentException("Encryption algorithm cannot be null");
        }
        byte[] skey = ESAPI.securityConfiguration().getMasterKey();
        if (skey == null) {
            throw new IllegalArgumentException("Can't obtain master key, Encryptor.MasterKey");
        }
        if (skey.length < 7) {
            throw new ConfigurationException("Encryptor.MasterKey must be at least 7 bytes. Length is: " + skey.length + " bytes.");
        }
        return new SecretKeySpec(skey, encryptAlgorithm);
    }

    static final void preAdd(long leftLongValue, int rightIntValue) throws ArithmeticException {
        if (rightIntValue > 0 && leftLongValue + (long)rightIntValue < leftLongValue) {
            throw new ArithmeticException("Arithmetic overflow for addition.");
        }
        if (rightIntValue < 0 && leftLongValue + (long)rightIntValue > leftLongValue) {
            throw new ArithmeticException("Arithmetic underflow for addition.");
        }
    }
}

