/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.auth.saml;

import java.io.Serializable;
import java.util.List;
import org.opensaml.saml2.core.Attribute;
import org.opensaml.saml2.core.NameID;

public class SAMLCredential {
    private final NameID nameID;
    private final List<String> sessionIndexes;
    private String remoteEntityID;
    private String relayState;
    private List<Attribute> attributes;
    private String localEntityID;
    private Serializable additionalData;

    public SAMLCredential(NameID nameID, List<String> sessionIndexes) {
        this.nameID = nameID;
        this.sessionIndexes = sessionIndexes;
    }

    public SAMLCredential(NameID nameID, List<String> sessionIndexes, String remoteEntityID, String relayState, List<Attribute> attributes, String localEntityID, Serializable additionalData) {
        this.nameID = nameID;
        this.sessionIndexes = sessionIndexes;
        this.remoteEntityID = remoteEntityID;
        this.relayState = relayState;
        this.attributes = attributes;
        this.localEntityID = localEntityID;
        this.additionalData = additionalData;
    }

    public NameID getNameID() {
        return this.nameID;
    }

    public List<String> getSessionIndexes() {
        return this.sessionIndexes;
    }

    public String getRemoteEntityID() {
        return this.remoteEntityID;
    }

    public Attribute getAttributeByName(String name) {
        for (Attribute attribute : this.getAttributes()) {
            if (!name.equalsIgnoreCase(attribute.getName())) continue;
            return attribute;
        }
        return null;
    }

    public List<Attribute> getAttributes() {
        return this.attributes;
    }

    public String getRelayState() {
        return this.relayState;
    }

    public String getLocalEntityID() {
        return this.localEntityID;
    }

    public Serializable getAdditionalData() {
        return this.additionalData;
    }
}

