/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xml.security.keyinfo;

import java.security.Key;
import java.security.KeyException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.crypto.SecretKey;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.security.CriteriaSet;
import org.opensaml.xml.security.SecurityException;
import org.opensaml.xml.security.SecurityHelper;
import org.opensaml.xml.security.credential.AbstractCriteriaFilteringCredentialResolver;
import org.opensaml.xml.security.credential.BasicCredential;
import org.opensaml.xml.security.credential.Credential;
import org.opensaml.xml.security.keyinfo.KeyInfoCredentialResolver;
import org.opensaml.xml.security.keyinfo.KeyInfoCriteria;
import org.opensaml.xml.security.keyinfo.KeyInfoHelper;
import org.opensaml.xml.security.keyinfo.KeyInfoProvider;
import org.opensaml.xml.security.keyinfo.KeyInfoResolutionContext;
import org.opensaml.xml.signature.DEREncodedKeyValue;
import org.opensaml.xml.signature.KeyInfo;
import org.opensaml.xml.signature.KeyName;
import org.opensaml.xml.signature.KeyValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicProviderKeyInfoCredentialResolver
extends AbstractCriteriaFilteringCredentialResolver
implements KeyInfoCredentialResolver {
    private final Logger log = LoggerFactory.getLogger(BasicProviderKeyInfoCredentialResolver.class);
    private List<KeyInfoProvider> providers = new ArrayList<KeyInfoProvider>();

    public BasicProviderKeyInfoCredentialResolver(List<KeyInfoProvider> keyInfoProviders) {
        this.providers.addAll(keyInfoProviders);
    }

    protected List<KeyInfoProvider> getProviders() {
        return this.providers;
    }

    @Override
    protected Iterable<Credential> resolveFromSource(CriteriaSet criteriaSet) throws SecurityException {
        KeyInfoCriteria kiCriteria = criteriaSet.get(KeyInfoCriteria.class);
        if (kiCriteria == null) {
            this.log.error("No KeyInfo criteria supplied, resolver could not process");
            throw new SecurityException("Credential criteria set did not contain an instance ofKeyInfoCredentialCriteria");
        }
        KeyInfo keyInfo = kiCriteria.getKeyInfo();
        ArrayList<Credential> credentials = new ArrayList<Credential>();
        KeyInfoResolutionContext kiContext = new KeyInfoResolutionContext(credentials);
        if (keyInfo != null) {
            this.processKeyInfo(keyInfo, kiContext, criteriaSet, credentials);
        } else {
            this.log.info("KeyInfo was null, any credentials will be resolved by post-processing hooks only");
        }
        this.postProcess(kiContext, criteriaSet, credentials);
        if (credentials.isEmpty()) {
            this.log.debug("No credentials were found, calling empty credentials post-processing hook");
            this.postProcessEmptyCredentials(kiContext, criteriaSet, credentials);
        }
        this.log.debug("A total of {} credentials were resolved", (Object)credentials.size());
        return credentials;
    }

    private void processKeyInfo(KeyInfo keyInfo, KeyInfoResolutionContext kiContext, CriteriaSet criteriaSet, List<Credential> credentials) throws SecurityException {
        Credential keyValueCredential;
        this.initResolutionContext(kiContext, keyInfo, criteriaSet);
        Key keyValueKey = kiContext.getKey();
        HashSet<String> keyNames = new HashSet<String>();
        keyNames.addAll(kiContext.getKeyNames());
        this.processKeyInfoChildren(kiContext, criteriaSet, credentials);
        if (credentials.isEmpty() && keyValueKey != null && (keyValueCredential = this.buildBasicCredential(keyValueKey, keyNames)) != null) {
            this.log.debug("No credentials were extracted by registered non-KeyValue handling providers, adding KeyValue credential to returned credential set");
            credentials.add(keyValueCredential);
        }
    }

    protected void postProcess(KeyInfoResolutionContext kiContext, CriteriaSet criteriaSet, List<Credential> credentials) throws SecurityException {
    }

    protected void postProcessEmptyCredentials(KeyInfoResolutionContext kiContext, CriteriaSet criteriaSet, List<Credential> credentials) throws SecurityException {
    }

    protected void processKeyInfoChildren(KeyInfoResolutionContext kiContext, CriteriaSet criteriaSet, List<Credential> credentials) throws SecurityException {
        for (XMLObject keyInfoChild : kiContext.getKeyInfo().getXMLObjects()) {
            if (keyInfoChild instanceof KeyValue || keyInfoChild instanceof DEREncodedKeyValue) continue;
            this.log.debug("Processing KeyInfo child with qname: {}", (Object)keyInfoChild.getElementQName());
            Collection<Credential> childCreds = this.processKeyInfoChild(kiContext, criteriaSet, keyInfoChild);
            if (childCreds != null && !childCreds.isEmpty()) {
                credentials.addAll(childCreds);
                continue;
            }
            if (keyInfoChild instanceof KeyName) {
                this.log.debug("KeyName, with value {}, did not independently produce a credential based on any registered providers", (Object)((KeyName)keyInfoChild).getValue());
                continue;
            }
            this.log.warn("No credentials could be extracted from KeyInfo child with qname {} by any registered provider", (Object)keyInfoChild.getElementQName());
        }
    }

    protected Collection<Credential> processKeyInfoChild(KeyInfoResolutionContext kiContext, CriteriaSet criteriaSet, XMLObject keyInfoChild) throws SecurityException {
        for (KeyInfoProvider provider : this.getProviders()) {
            if (!provider.handles(keyInfoChild)) {
                this.log.debug("Provider {} doesn't handle objects of type {}, skipping", (Object)provider.getClass().getName(), (Object)keyInfoChild.getElementQName());
                continue;
            }
            this.log.debug("Processing KeyInfo child {} with provider {}", (Object)keyInfoChild.getElementQName(), (Object)provider.getClass().getName());
            Collection<Credential> creds = provider.process(this, keyInfoChild, criteriaSet, kiContext);
            if (creds == null || creds.isEmpty()) continue;
            this.log.debug("Credentials successfully extracted from child {} by provider {}", (Object)keyInfoChild.getElementQName(), (Object)provider.getClass().getName());
            return creds;
        }
        return null;
    }

    protected void initResolutionContext(KeyInfoResolutionContext kiContext, KeyInfo keyInfo, CriteriaSet criteriaSet) throws SecurityException {
        kiContext.setKeyInfo(keyInfo);
        kiContext.getKeyNames().addAll(KeyInfoHelper.getKeyNames(keyInfo));
        this.log.debug("Found {} key names: {}", (Object)kiContext.getKeyNames().size(), kiContext.getKeyNames());
        this.resolveKeyValue(kiContext, criteriaSet, keyInfo.getKeyValues());
        this.resolveKeyValue(kiContext, criteriaSet, keyInfo.getXMLObjects(DEREncodedKeyValue.DEFAULT_ELEMENT_NAME));
    }

    protected void resolveKeyValue(KeyInfoResolutionContext kiContext, CriteriaSet criteriaSet, List<? extends XMLObject> keyValues) throws SecurityException {
        for (XMLObject xMLObject : keyValues) {
            Collection<Credential> creds;
            if (!(xMLObject instanceof KeyValue) && !(xMLObject instanceof DEREncodedKeyValue) || (creds = this.processKeyInfoChild(kiContext, criteriaSet, xMLObject)) == null) continue;
            for (Credential cred : creds) {
                Key key = this.extractKeyValue(cred);
                if (key == null) continue;
                kiContext.setKey(key);
                this.log.debug("Found a credential based on a KeyValue/DEREncodedKeyValue having key type: {}", (Object)key.getAlgorithm());
                return;
            }
        }
    }

    protected Credential buildBasicCredential(Key key, Set<String> keyNames) throws SecurityException {
        if (key == null) {
            this.log.debug("Key supplied was null, could not build credential");
            return null;
        }
        BasicCredential basicCred = new BasicCredential();
        basicCred.getKeyNames().addAll(keyNames);
        if (key instanceof PublicKey) {
            basicCred.setPublicKey((PublicKey)key);
        } else if (key instanceof SecretKey) {
            basicCred.setSecretKey((SecretKey)key);
        } else if (key instanceof PrivateKey) {
            PrivateKey privateKey = (PrivateKey)key;
            try {
                PublicKey publicKey = SecurityHelper.derivePublicKey(privateKey);
                if (publicKey == null) {
                    this.log.error("Failed to derive public key from private key");
                    return null;
                }
                basicCred.setPublicKey(publicKey);
                basicCred.setPrivateKey(privateKey);
            }
            catch (KeyException e) {
                this.log.error("Could not derive public key from private key", (Throwable)e);
                return null;
            }
        } else {
            this.log.error(String.format("Key was of an unsupported type '%s'", key.getClass().getName()));
            return null;
        }
        return basicCred;
    }

    protected Key extractKeyValue(Credential cred) {
        if (cred == null) {
            return null;
        }
        if (cred.getPublicKey() != null) {
            return cred.getPublicKey();
        }
        if (cred.getSecretKey() != null) {
            return cred.getSecretKey();
        }
        if (cred.getPrivateKey() != null) {
            return cred.getPrivateKey();
        }
        return null;
    }
}

