/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.auth.saml.key;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.platform.auth.saml.key.KeyDescriptor;
import org.nuxeo.ecm.platform.auth.saml.key.KeyManager;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.DefaultComponent;
import org.opensaml.common.SAMLRuntimeException;
import org.opensaml.xml.security.CriteriaSet;
import org.opensaml.xml.security.SecurityException;
import org.opensaml.xml.security.credential.Credential;
import org.opensaml.xml.security.credential.KeyStoreCredentialResolver;
import org.opensaml.xml.security.criteria.EntityIDCriteria;

public class KeyManagerImpl
extends DefaultComponent
implements KeyManager {
    private static final Log log = LogFactory.getLog(KeyManagerImpl.class);
    private static final String XP = "configuration";
    private static final String KEYSTORE_TYPE = "JKS";
    private KeyDescriptor config;
    private KeyStore keyStore;
    private KeyStoreCredentialResolver credentialResolver;
    private Set<String> availableCredentials;

    public void start(ComponentContext context) {
        this.config = this.getRegistryContribution(XP).orElse(null);
        this.setup();
    }

    public void stop(ComponentContext context) throws InterruptedException {
        this.config = null;
        this.setup();
    }

    private void setup() {
        if (this.config != null) {
            try {
                this.keyStore = this.getKeyStore(this.config.getKeystoreFilePath(), this.config.getKeystorePassword());
            }
            catch (SecurityException e) {
                throw new RuntimeException(e);
            }
            this.credentialResolver = new KeyStoreCredentialResolver(this.keyStore, this.config.getPasswords());
        } else {
            this.keyStore = null;
            this.credentialResolver = null;
            this.availableCredentials = null;
        }
    }

    private KeyStore getKeyStore(String path, String password) throws SecurityException {
        KeyStore ks;
        try {
            File rootKeystoreFile = new File(path);
            if (!rootKeystoreFile.exists()) {
                throw new SecurityException("Unable to find keyStore at " + new File(".").getAbsolutePath() + File.separator + path);
            }
            try (FileInputStream keystoreIS = new FileInputStream(rootKeystoreFile);){
                ks = KeyStore.getInstance(KEYSTORE_TYPE);
                ks.load(keystoreIS, password.toCharArray());
            }
        }
        catch (IOException | KeyStoreException e) {
            throw new SecurityException(e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new SecurityException((Exception)e);
        }
        catch (CertificateException e) {
            throw new SecurityException((Exception)e);
        }
        return ks;
    }

    @Override
    public Credential getCredential(String keyName) {
        try {
            CriteriaSet cs = new CriteriaSet();
            EntityIDCriteria criteria = new EntityIDCriteria(keyName);
            cs.add((Object)criteria);
            return this.resolveSingle(cs);
        }
        catch (SecurityException e) {
            throw new SAMLRuntimeException("Can't obtain SP signing key", (Exception)((Object)e));
        }
    }

    @Override
    public Set<String> getAvailableCredentials() {
        if (this.availableCredentials != null) {
            return this.availableCredentials;
        }
        try {
            this.availableCredentials = new HashSet<String>();
            Enumeration<String> aliases = this.keyStore.aliases();
            while (aliases.hasMoreElements()) {
                this.availableCredentials.add(aliases.nextElement());
            }
            return this.availableCredentials;
        }
        catch (KeyStoreException e) {
            throw new RuntimeException("Unable to load aliases from keyStore", e);
        }
    }

    @Override
    public X509Certificate getCertificate(String alias) {
        if (alias == null || alias.length() == 0) {
            return null;
        }
        try {
            return (X509Certificate)this.keyStore.getCertificate(alias);
        }
        catch (KeyStoreException e) {
            log.error((Object)"Error loading certificate", (Throwable)e);
            return null;
        }
    }

    @Override
    public Credential getSigningCredential() {
        if (!this.hasCredentials() || this.config.getSigningKey() == null) {
            return null;
        }
        return this.getCredential(this.config.getSigningKey());
    }

    @Override
    public Credential getEncryptionCredential() {
        if (!this.hasCredentials() || this.config.getEncryptionKey() == null) {
            return null;
        }
        return this.getCredential(this.config.getEncryptionKey());
    }

    @Override
    public Credential getTlsCredential() {
        if (!this.hasCredentials() || this.config.getTlsKey() == null) {
            return null;
        }
        return this.getCredential(this.config.getTlsKey());
    }

    public Iterable<Credential> resolve(CriteriaSet criteria) throws SecurityException {
        return this.credentialResolver.resolve(criteria);
    }

    public Credential resolveSingle(CriteriaSet criteria) throws SecurityException {
        return this.credentialResolver.resolveSingle(criteria);
    }

    private boolean hasCredentials() {
        return this.config != null && this.credentialResolver != null;
    }
}

