/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.usermapper.service;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.DefaultComponent;
import org.nuxeo.usermapper.extension.UserMapper;
import org.nuxeo.usermapper.service.UserMapperService;

public class UserMapperComponent
extends DefaultComponent
implements UserMapperService {
    protected static final Log log = LogFactory.getLog(UserMapperComponent.class);
    protected Map<String, UserMapper> mappers;
    public static final String MAPPER_EP = "mapper";

    public void start(ComponentContext context) {
        this.mappers = new HashMap<String, UserMapper>();
        this.getRegistryContributions(MAPPER_EP).forEach(desc -> {
            try {
                this.mappers.put(desc.name, desc.getInstance());
            }
            catch (Exception e) {
                log.error((Object)("Unable to register mapper " + desc.name), (Throwable)e);
            }
        });
    }

    public void stop(ComponentContext context) throws InterruptedException {
        for (UserMapper um : this.mappers.values()) {
            um.release();
        }
        this.mappers = null;
    }

    @Override
    public UserMapper getMapper(String mappingName) throws NuxeoException {
        UserMapper um = this.mappers.get(mappingName);
        if (um == null) {
            throw new NuxeoException("No mapping defined for " + mappingName);
        }
        return um;
    }

    @Override
    public NuxeoPrincipal getOrCreateAndUpdateNuxeoPrincipal(String mappingName, Object userObject) throws NuxeoException {
        return this.getOrCreateAndUpdateNuxeoPrincipal(mappingName, userObject, true, true, null);
    }

    @Override
    public NuxeoPrincipal getOrCreateAndUpdateNuxeoPrincipal(String mappingName, Object userObject, boolean createIfNeeded, boolean update, Map<String, Serializable> params) throws NuxeoException {
        return this.getMapper(mappingName).getOrCreateAndUpdateNuxeoPrincipal(userObject, createIfNeeded, update, params);
    }

    @Override
    public Object wrapNuxeoPrincipal(String mappingName, NuxeoPrincipal principal, Object nativePrincipal, Map<String, Serializable> params) throws NuxeoException {
        return this.getMapper(mappingName).wrapNuxeoPrincipal(principal, nativePrincipal, params);
    }

    @Override
    public Set<String> getAvailableMappings() {
        return this.mappers.keySet();
    }
}

