/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.ws.security.provider;

import org.opensaml.ws.message.MessageContext;
import org.opensaml.ws.security.SecurityPolicyException;
import org.opensaml.ws.security.SecurityPolicyRule;
import org.opensaml.ws.transport.http.HTTPTransport;
import org.opensaml.xml.util.DatatypeHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HTTPRule
implements SecurityPolicyRule {
    private final Logger log = LoggerFactory.getLogger(HTTPRule.class);
    private String requiredContentType;
    private String requiredRequestMethod;
    private boolean requireSecured;

    public HTTPRule(String type, String method, boolean secured) {
        this.requiredContentType = DatatypeHelper.safeTrimOrNullString((String)type);
        this.requiredRequestMethod = DatatypeHelper.safeTrimOrNullString((String)method);
        this.requireSecured = secured;
    }

    @Override
    public void evaluate(MessageContext messageContext) throws SecurityPolicyException {
        if (!(messageContext.getInboundMessageTransport() instanceof HTTPTransport)) {
            this.log.debug("Message context was did not contain an HTTP transport, unable to evaluate security rule");
            return;
        }
        this.doEvaluate(messageContext);
    }

    protected void doEvaluate(MessageContext messageContext) throws SecurityPolicyException {
        HTTPTransport transport = (HTTPTransport)((Object)messageContext.getInboundMessageTransport());
        this.evaluateContentType(transport);
        this.evaluateRequestMethod(transport);
        this.evaluateSecured(transport);
    }

    protected void evaluateContentType(HTTPTransport transport) throws SecurityPolicyException {
        String transportContentType = transport.getHeaderValue("Content-Type");
        if (this.requiredContentType != null && !transportContentType.startsWith(this.requiredContentType)) {
            this.log.error("Invalid content type, expected " + this.requiredContentType + " but was " + transportContentType);
            throw new SecurityPolicyException("Invalid content type, expected " + this.requiredContentType + " but was " + transportContentType);
        }
    }

    protected void evaluateRequestMethod(HTTPTransport transport) throws SecurityPolicyException {
        String transportMethod = transport.getHTTPMethod();
        if (this.requiredRequestMethod != null && !transportMethod.equalsIgnoreCase(this.requiredRequestMethod)) {
            this.log.error("Invalid request method, expected " + this.requiredRequestMethod + " but was " + transportMethod);
            throw new SecurityPolicyException("Invalid request method, expected " + this.requiredRequestMethod + " but was " + transportMethod);
        }
    }

    protected void evaluateSecured(HTTPTransport transport) throws SecurityPolicyException {
        if (this.requireSecured && !transport.isConfidential()) {
            this.log.error("Request was required to be secured but was not");
            throw new SecurityPolicyException("Request was required to be secured but was not");
        }
    }
}

