/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.wopi;

import java.util.Arrays;
import org.apache.commons.codec.binary.Base64;
import org.nuxeo.ecm.core.api.DocumentModel;

public class FileInfo {
    public final String repositoryName;
    public final String docId;
    public final String xpath;

    public static String computeFileId(String repositoryName, String docId, String xpath) {
        return Base64.encodeBase64String((byte[])String.join((CharSequence)"/", repositoryName, docId, xpath).getBytes());
    }

    public static String computeFileId(DocumentModel doc, String xpath) {
        return FileInfo.computeFileId(doc.getRepositoryName(), doc.getId(), xpath);
    }

    public FileInfo(String fileId) {
        String str = new String(Base64.decodeBase64((String)fileId));
        String[] parts = str.split("/");
        this.repositoryName = parts[0];
        this.docId = parts[1];
        this.xpath = String.join((CharSequence)"/", Arrays.asList(parts).subList(2, parts.length));
    }
}

