/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.wopi;

import com.beetstra.jutf7.CharsetProvider;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.HttpHeaders;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.api.PropertyException;
import org.nuxeo.ecm.core.blob.BlobManager;
import org.nuxeo.ecm.core.blob.BlobProvider;
import org.nuxeo.ecm.jwt.JWTService;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.wopi.exception.UnauthorizedException;

public class Helpers {
    private static final Logger log = LogManager.getLogger(Helpers.class);
    public static final Charset UTF_7 = new CharsetProvider().charsetForName("UTF-7");

    private Helpers() {
    }

    public static String readUTF7String(String s) {
        byte[] bytes = s.getBytes(StandardCharsets.UTF_8);
        return new String(bytes, UTF_7);
    }

    public static String createJWTToken() {
        return ((JWTService)Framework.getService(JWTService.class)).newBuilder().withTTL(3600).build();
    }

    public static String getJWTToken(HttpServletRequest request) {
        String token = request.getParameter("access_token");
        if (token == null || ((JWTService)Framework.getService(JWTService.class)).verifyToken(token) == null) {
            throw new UnauthorizedException();
        }
        return token;
    }

    public static long getJWTTokenExp(String token) {
        Map claims = ((JWTService)Framework.getService(JWTService.class)).verifyToken(token);
        long expireAt = (Long)claims.get("exp");
        return expireAt * 1000L;
    }

    public static String principalFullName(NuxeoPrincipal principal) {
        String first = principal.getFirstName();
        String last = principal.getLastName();
        return Helpers.userDisplayName(principal.getName(), first, last);
    }

    public static Blob getEditableBlob(DocumentModel doc, String xpath) {
        Blob blob = null;
        try {
            blob = (Blob)doc.getPropertyValue(xpath);
        }
        catch (PropertyException propertyException) {
            // empty catch block
        }
        if (blob == null) {
            Supplier[] supplierArray = new Supplier[3];
            supplierArray[0] = () -> ((DocumentModel)doc).getRepositoryName();
            supplierArray[1] = () -> ((DocumentModel)doc).getId();
            supplierArray[2] = () -> xpath;
            log.debug("Blobs: repository={} docId={} xpath={} Cannot find blob", supplierArray);
            return null;
        }
        if (!Helpers.supportsSync(blob)) {
            Supplier[] supplierArray = new Supplier[3];
            supplierArray[0] = () -> ((DocumentModel)doc).getRepositoryName();
            supplierArray[1] = () -> ((DocumentModel)doc).getId();
            supplierArray[2] = () -> xpath;
            log.debug("Blobs: repository={} docId={} xpath={} Ignoring blob as it is backed by a BlobProvider preventing sync", supplierArray);
            return null;
        }
        return blob;
    }

    @Deprecated
    protected static boolean isExternalBlobProvider(Blob blob) {
        BlobManager blobManager = (BlobManager)Framework.getService(BlobManager.class);
        BlobProvider blobProvider = blobManager.getBlobProvider(blob);
        return blobProvider != null && (!blobProvider.supportsUserUpdate() || blobProvider.getBinaryManager() == null);
    }

    protected static boolean supportsSync(Blob blob) {
        BlobManager blobManager = (BlobManager)Framework.getService(BlobManager.class);
        BlobProvider blobProvider = blobManager.getBlobProvider(blob);
        return blobProvider != null && blobProvider.supportsSync();
    }

    public static String getWOPIURL(String baseURL, String action, DocumentModel doc, String xpath) {
        return String.format("%s%s/%s/%s/%s/%s", baseURL, "wopi", action, doc.getRepositoryName(), doc.getId(), xpath);
    }

    protected static String userDisplayName(String id, String first, String last) {
        if (StringUtils.isEmpty((CharSequence)first)) {
            if (StringUtils.isEmpty((CharSequence)last)) {
                return id;
            }
            return last;
        }
        if (StringUtils.isEmpty((CharSequence)last)) {
            return first;
        }
        return first + " " + last;
    }

    public static String getHeader(HttpHeaders httpHeaders, String headerName) {
        List headers = httpHeaders.getRequestHeader(headerName);
        return headers == null || headers.isEmpty() ? null : (String)headers.get(0);
    }
}

