/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.wopi;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlElementWrapper;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import java.io.IOException;
import java.util.List;
import org.nuxeo.ecm.core.api.NuxeoException;

@JsonIgnoreProperties(ignoreUnknown=true)
public class WOPIDiscovery {
    @JacksonXmlProperty(localName="net-zone")
    private NetZone netZone;
    @JacksonXmlProperty(localName="proof-key")
    private ProofKey proofKey;
    protected static final XmlMapper XML_MAPPER = new XmlMapper();

    public NetZone getNetZone() {
        return this.netZone;
    }

    public void setNetZone(NetZone netZone) {
        this.netZone = netZone;
    }

    public ProofKey getProofKey() {
        return this.proofKey;
    }

    public void setProofKey(ProofKey proofKey) {
        this.proofKey = proofKey;
    }

    public static WOPIDiscovery read(byte[] discoveryBytes) {
        try {
            return (WOPIDiscovery)XML_MAPPER.readValue(discoveryBytes, WOPIDiscovery.class);
        }
        catch (IOException e) {
            throw new NuxeoException((Throwable)e);
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class Action {
        private String name;
        private String ext;
        @JacksonXmlProperty(localName="urlsrc")
        private String url;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getExt() {
            return this.ext;
        }

        public void setExt(String ext) {
            this.ext = ext;
        }

        public String getUrl() {
            return this.url;
        }

        public void setUrl(String url) {
            this.url = url;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class App {
        private String name;
        @JacksonXmlProperty(localName="action")
        @JacksonXmlElementWrapper(useWrapping=false)
        private List<Action> actions;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public List<Action> getActions() {
            return this.actions;
        }

        public void setActions(List<Action> actions) {
            this.actions = actions;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class ProofKey {
        private String exponent;
        private String modulus;
        @JacksonXmlProperty(localName="oldexponent")
        private String oldExponent;
        @JacksonXmlProperty(localName="oldmodulus")
        private String oldModulus;

        public String getExponent() {
            return this.exponent;
        }

        public void setExponent(String exponent) {
            this.exponent = exponent;
        }

        public String getModulus() {
            return this.modulus;
        }

        public void setModulus(String modulus) {
            this.modulus = modulus;
        }

        public String getOldExponent() {
            return this.oldExponent;
        }

        public void setOldExponent(String oldExponent) {
            this.oldExponent = oldExponent;
        }

        public String getOldModulus() {
            return this.oldModulus;
        }

        public void setOldModulus(String oldModulus) {
            this.oldModulus = oldModulus;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class NetZone {
        @JacksonXmlProperty(localName="app")
        @JacksonXmlElementWrapper(useWrapping=false)
        private List<App> apps;

        public List<App> getApps() {
            return this.apps;
        }

        public void setApps(List<App> apps) {
            this.apps = apps;
        }
    }
}

