/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.wopi;

import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.model.Property;
import org.nuxeo.ecm.core.api.model.impl.primitives.BlobProperty;
import org.nuxeo.ecm.core.io.marshallers.json.enrichers.AbstractJsonEnricher;
import org.nuxeo.ecm.core.io.registry.reflect.Instantiations;
import org.nuxeo.ecm.core.io.registry.reflect.Setup;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.wopi.Helpers;
import org.nuxeo.wopi.WOPIBlobInfo;
import org.nuxeo.wopi.WOPIService;

@Setup(mode=Instantiations.SINGLETON, priority=2000)
public class WOPIJsonEnricher
extends AbstractJsonEnricher<BlobProperty> {
    public static final String NAME = "wopi";
    public static final String APP_NAME_FIELD = "appName";

    public WOPIJsonEnricher() {
        super(NAME);
    }

    public void write(JsonGenerator jg, BlobProperty blobProperty) throws IOException {
        DocumentModel doc = (DocumentModel)this.ctx.getParameter("document");
        if (doc == null) {
            return;
        }
        Blob blob = (Blob)blobProperty.getValue();
        WOPIBlobInfo info = ((WOPIService)Framework.getService(WOPIService.class)).getWOPIBlobInfo(blob);
        if (info == null) {
            return;
        }
        jg.writeFieldName(NAME);
        jg.writeStartObject();
        this.writeWOPIBlobInfo(jg, info, doc, this.getXPath((Property)blobProperty));
        jg.writeEndObject();
    }

    protected void writeWOPIBlobInfo(JsonGenerator jg, WOPIBlobInfo info, DocumentModel doc, String xpath) throws IOException {
        jg.writeStringField(APP_NAME_FIELD, info.appName);
        for (String action : info.actions) {
            jg.writeStringField(action, Helpers.getWOPIURL(this.ctx.getBaseUrl(), action, doc, xpath));
        }
    }

    protected String getXPath(Property property) {
        Object xpath = property.getXPath();
        if (!((String)xpath).contains(":")) {
            xpath = property.getSchema().getName() + ":" + (String)xpath;
        }
        return xpath;
    }
}

