/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.wopi;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.security.PublicKey;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventProducer;
import org.nuxeo.ecm.core.event.impl.EventContextImpl;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.cluster.ClusterService;
import org.nuxeo.runtime.kv.KeyValueService;
import org.nuxeo.runtime.kv.KeyValueStore;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.DefaultComponent;
import org.nuxeo.runtime.pubsub.AbstractPubSubBroker;
import org.nuxeo.runtime.pubsub.SerializableMessage;
import org.nuxeo.runtime.services.config.ConfigurationService;
import org.nuxeo.wopi.Helpers;
import org.nuxeo.wopi.ProofKeyHelper;
import org.nuxeo.wopi.WOPIBlobInfo;
import org.nuxeo.wopi.WOPIDiscovery;
import org.nuxeo.wopi.WOPIService;

public class WOPIServiceImpl
extends DefaultComponent
implements WOPIService {
    private static final Logger log = LogManager.getLogger(WOPIServiceImpl.class);
    public static final String PLACEHOLDER_IS_LICENSED_USER = "IsLicensedUser";
    public static final String PLACEHOLDER_IS_LICENSED_USER_VALUE = "1";
    public static final String WOPI_PROPERTY_NAMESPACE = "org.nuxeo.wopi";
    public static final String SUPPORTED_APP_NAMES_PROPERTY_KEY = "supportedAppNames";
    protected static final String WOPI_DISCOVERY_INVAL_PUBSUB_TOPIC = "wopiDiscoveryInval";
    protected Map<String, String> extensionAppNames = new HashMap<String, String>();
    protected Map<String, Map<String, String>> extensionActionURLs = new HashMap<String, Map<String, String>>();
    protected PublicKey proofKey;
    protected PublicKey oldProofKey;
    protected String discoveryURL;
    protected WOPIDiscoveryInvalidator invalidator;

    public void start(ComponentContext context) {
        this.registerInvalidator();
        this.discoveryURL = Framework.getProperty((String)"nuxeo.wopi.discoveryURL");
        this.loadDiscovery();
    }

    protected void registerInvalidator() {
        ClusterService clusterService = (ClusterService)Framework.getService(ClusterService.class);
        if (clusterService.isEnabled()) {
            String nodeId = clusterService.getNodeId();
            this.invalidator = new WOPIDiscoveryInvalidator();
            this.invalidator.initialize(WOPI_DISCOVERY_INVAL_PUBSUB_TOPIC, nodeId);
            log.info("Registered WOPI discovery invalidator for node: {}", (Object)nodeId);
        } else {
            log.info("Not registering a WOPI discovery invalidator because clustering is not enabled");
        }
    }

    protected void loadDiscovery() {
        byte[] discoveryBytes = this.getDiscovery();
        if (ArrayUtils.isEmpty((byte[])discoveryBytes)) {
            boolean refreshed = this.refreshDiscovery();
            if (!refreshed) {
                log.error("Cannot load WOPI discovery: WOPI disabled");
            }
        } else {
            this.loadDiscovery(discoveryBytes);
            this.fireRefreshDiscovery();
        }
    }

    protected boolean loadDiscovery(byte[] discoveryBytes) {
        WOPIDiscovery discovery;
        try {
            discovery = WOPIDiscovery.read(discoveryBytes);
        }
        catch (NuxeoException e) {
            Supplier[] supplierArray = new Supplier[1];
            supplierArray[0] = () -> ((NuxeoException)e).getMessage();
            log.error("Error while reading WOPI discovery {}", supplierArray);
            log.debug((Object)e, (Throwable)e);
            return false;
        }
        WOPIDiscovery.NetZone netZone = discovery.getNetZone();
        if (netZone == null) {
            log.error("Invalid WOPI discovery, no net-zone element");
            return false;
        }
        List<String> supportedAppNames = this.getSupportedAppNames();
        netZone.getApps().stream().filter(app -> supportedAppNames.contains(app.getName())).forEach(this::registerApp);
        log.debug("Successfully loaded WOPI discovery: WOPI enabled");
        WOPIDiscovery.ProofKey pk = discovery.getProofKey();
        this.proofKey = ProofKeyHelper.getPublicKey(pk.getModulus(), pk.getExponent());
        this.oldProofKey = ProofKeyHelper.getPublicKey(pk.getOldModulus(), pk.getOldExponent());
        log.debug("Registered proof key: {}", (Object)this.proofKey);
        log.debug("Registered old proof key: {}", (Object)this.oldProofKey);
        return true;
    }

    protected void fireRefreshDiscovery() {
        EventContextImpl ctx = new EventContextImpl(new Object[0]);
        Event event = ctx.newEvent("refreshWOPIDiscovery");
        ((EventProducer)Framework.getService(EventProducer.class)).fireEvent(event);
    }

    protected List<String> getSupportedAppNames() {
        Serializable supportedAppNames = (Serializable)((ConfigurationService)Framework.getService(ConfigurationService.class)).getProperties(WOPI_PROPERTY_NAMESPACE).get(SUPPORTED_APP_NAMES_PROPERTY_KEY);
        if (!(supportedAppNames instanceof String[])) {
            return Collections.emptyList();
        }
        return Arrays.asList((String[])supportedAppNames);
    }

    protected void registerApp(WOPIDiscovery.App app) {
        app.getActions().forEach(action -> {
            this.extensionAppNames.put(action.getExt(), app.getName());
            this.extensionActionURLs.computeIfAbsent(action.getExt(), k -> new HashMap()).put(action.getName(), String.format("%s%s=%s&", action.getUrl().replaceFirst("<.*$", ""), PLACEHOLDER_IS_LICENSED_USER, PLACEHOLDER_IS_LICENSED_USER_VALUE));
        });
    }

    @Override
    public boolean isEnabled() {
        return !this.extensionAppNames.isEmpty() && !this.extensionActionURLs.isEmpty();
    }

    @Override
    public WOPIBlobInfo getWOPIBlobInfo(Blob blob) {
        if (!this.isEnabled() || !Helpers.supportsSync(blob)) {
            return null;
        }
        String extension = this.getExtension(blob);
        String appName = this.extensionAppNames.get(extension);
        Map<String, String> actionURLs = this.extensionActionURLs.get(extension);
        return appName == null || actionURLs.isEmpty() ? null : new WOPIBlobInfo(appName, actionURLs.keySet());
    }

    @Override
    public String getActionURL(Blob blob, String action) {
        String extension = this.getExtension(blob);
        return (String)this.extensionActionURLs.getOrDefault(extension, Collections.emptyMap()).get(action);
    }

    protected String getExtension(Blob blob) {
        String filename = blob.getFilename();
        if (filename == null) {
            return null;
        }
        String extension = FilenameUtils.getExtension((String)filename);
        return StringUtils.isNotBlank((CharSequence)extension) ? extension : null;
    }

    @Override
    public boolean verifyProofKey(String proofKeyHeader, String oldProofKeyHeader, String url, String accessToken, String timestampHeader) {
        if (StringUtils.isBlank((CharSequence)proofKeyHeader)) {
            return true;
        }
        long timestamp = Long.parseLong(timestampHeader);
        if (!ProofKeyHelper.verifyTimestamp(timestamp)) {
            return false;
        }
        byte[] expectedProofBytes = ProofKeyHelper.getExpectedProofBytes(url, accessToken, timestamp);
        boolean res = ProofKeyHelper.verifyProofKey(this.proofKey, proofKeyHeader, expectedProofBytes);
        if (!res && StringUtils.isNotBlank((CharSequence)oldProofKeyHeader) && !(res = ProofKeyHelper.verifyProofKey(this.proofKey, oldProofKeyHeader, expectedProofBytes))) {
            res = ProofKeyHelper.verifyProofKey(this.oldProofKey, proofKeyHeader, expectedProofBytes);
        }
        return res;
    }

    @Override
    public boolean refreshDiscovery() {
        byte[] discoveryBytes = this.fetchDiscovery();
        if (ArrayUtils.isEmpty((byte[])discoveryBytes)) {
            return false;
        }
        log.debug("Successfully fetched WOPI dicovery");
        if (this.loadDiscovery(discoveryBytes)) {
            this.storeDiscovery(discoveryBytes);
            if (this.invalidator != null) {
                this.invalidator.sendMessage(new WOPIDiscoveryInvalidation());
            }
            return true;
        }
        return false;
    }

    /*
     * Exception decompiling
     */
    protected byte[] fetchDiscovery() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected byte[] getDiscovery() {
        return this.getKeyValueStore().get("wopiDiscovery");
    }

    protected void storeDiscovery(byte[] discoveryBytes) {
        this.getKeyValueStore().put("wopiDiscovery", discoveryBytes);
    }

    protected KeyValueStore getKeyValueStore() {
        return ((KeyValueService)Framework.getService(KeyValueService.class)).getKeyValueStore("wopi");
    }

    public class WOPIDiscoveryInvalidator
    extends AbstractPubSubBroker<WOPIDiscoveryInvalidation> {
        public WOPIDiscoveryInvalidation deserialize(InputStream in) throws IOException {
            return new WOPIDiscoveryInvalidation();
        }

        public void receivedMessage(WOPIDiscoveryInvalidation message) {
            byte[] discoveryBytes = WOPIServiceImpl.this.getDiscovery();
            WOPIServiceImpl.this.loadDiscovery(discoveryBytes);
        }
    }

    public static class WOPIDiscoveryInvalidation
    implements SerializableMessage {
        private static final long serialVersionUID = 1L;

        public void serialize(OutputStream out) throws IOException {
        }
    }
}

