/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.wopi;

import java.io.IOException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.CloseableCoreSession;
import org.nuxeo.ecm.core.api.CoreInstance;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.platform.web.common.vh.VirtualHostHelper;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.wopi.FileInfo;
import org.nuxeo.wopi.Helpers;
import org.nuxeo.wopi.WOPIService;

public class WOPIServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String path = request.getPathInfo();
        if (path == null) {
            response.sendError(400, "Null path");
            return;
        }
        String[] parts = (path = path.substring(1)).split("/");
        int length = parts.length;
        if (length < 4) {
            response.sendError(400, "Invalid path: " + path);
            return;
        }
        WOPIService wopiService = (WOPIService)Framework.getService(WOPIService.class);
        if (!wopiService.isEnabled()) {
            response.sendError(404, "WOPI not enabled");
            return;
        }
        String action = parts[0];
        String repository = parts[1];
        String docId = parts[2];
        String xpath = String.join((CharSequence)"/", Arrays.asList(parts).subList(3, length));
        try (CloseableCoreSession session = CoreInstance.openCoreSession((String)repository);){
            IdRef ref = new IdRef(docId);
            if (!session.exists((DocumentRef)ref)) {
                response.sendError(404, "Document not found");
                return;
            }
            DocumentModel doc = session.getDocument((DocumentRef)ref);
            Blob blob = Helpers.getEditableBlob(doc, xpath);
            if (blob == null) {
                response.sendError(404, "No editable blob on document");
                return;
            }
            String actionURL = wopiService.getActionURL(blob, action);
            if (actionURL == null) {
                response.sendError(404, "Cannot open file with Office Online");
                return;
            }
            String token = Helpers.createJWTToken();
            request.setAttribute("accessToken", (Object)token);
            request.setAttribute("accessTokenTTL", (Object)Helpers.getJWTTokenExp(token));
            String baseURL = VirtualHostHelper.getBaseURL((ServletRequest)request);
            String wopiBaseURL = Framework.getProperty((String)"nuxeo.wopi.baseURL", (String)baseURL);
            String fileId = FileInfo.computeFileId(doc, xpath);
            String wopiSrc = URLEncoder.encode(String.format("%s%s%s", wopiBaseURL, "site/wopi/files/", fileId), StandardCharsets.UTF_8.name());
            request.setAttribute("formURL", (Object)String.format("%s%s=%s", actionURL, "WOPISrc", wopiSrc));
            RequestDispatcher requestDispatcher = request.getRequestDispatcher("/wopi.jsp");
            requestDispatcher.forward((ServletRequest)request, (ServletResponse)response);
        }
    }
}

