/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.wopi.jaxrs;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.Blobs;
import org.nuxeo.ecm.core.api.CoreInstance;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentLocation;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.api.impl.DocumentLocationImpl;
import org.nuxeo.ecm.core.io.download.DownloadService;
import org.nuxeo.ecm.platform.types.adapter.TypeInfo;
import org.nuxeo.ecm.platform.url.DocumentViewImpl;
import org.nuxeo.ecm.platform.url.api.DocumentView;
import org.nuxeo.ecm.platform.url.api.DocumentViewCodecManager;
import org.nuxeo.ecm.platform.web.common.vh.VirtualHostHelper;
import org.nuxeo.ecm.webengine.model.WebObject;
import org.nuxeo.ecm.webengine.model.impl.DefaultObject;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.wopi.FileInfo;
import org.nuxeo.wopi.Helpers;
import org.nuxeo.wopi.Operation;
import org.nuxeo.wopi.WOPIService;
import org.nuxeo.wopi.exception.BadRequestException;
import org.nuxeo.wopi.exception.ConflictException;
import org.nuxeo.wopi.exception.NotImplementedException;
import org.nuxeo.wopi.exception.PreConditionFailedException;
import org.nuxeo.wopi.lock.LockHelper;

@WebObject(type="wopiFiles")
public class FilesEndpoint
extends DefaultObject {
    private static final Logger log = LogManager.getLogger(FilesEndpoint.class);
    @Context
    protected HttpServletRequest request;
    @Context
    protected HttpServletResponse response;
    @Context
    protected HttpHeaders httpHeaders;
    protected CoreSession session;
    protected DocumentModel doc;
    protected Blob blob;
    protected String xpath;
    protected String fileId;
    protected String baseURL;
    protected String wopiBaseURL;

    public void initialize(Object ... args) {
        if (args == null || args.length != 4) {
            throw new IllegalArgumentException("Invalid args: " + Arrays.toString(args));
        }
        this.session = (CoreSession)args[0];
        this.doc = (DocumentModel)args[1];
        this.blob = (Blob)args[2];
        this.xpath = (String)args[3];
        this.fileId = FileInfo.computeFileId(this.doc, this.xpath);
        this.baseURL = VirtualHostHelper.getBaseURL((ServletRequest)this.request);
        this.wopiBaseURL = Framework.getProperty((String)"nuxeo.wopi.baseURL", (String)this.baseURL);
    }

    @GET
    @Produces(value={"application/json"})
    public Response checkFileInfo() {
        this.logRequest("CheckFileInfo", new String[0]);
        Map<String, Serializable> checkFileInfoMap = this.buildCheckFileInfoMap();
        this.logResponse("CheckFileInfo", Response.Status.OK.getStatusCode(), checkFileInfoMap, new String[0]);
        return Response.ok(checkFileInfoMap).build();
    }

    @GET
    @Path(value="contents")
    public Object getFile(@HeaderParam(value="X-WOPI-MaxExpectedSize") String maxExpectedSizeHeader) {
        int maxExpectedSize = this.getMaxExpectedSize(maxExpectedSizeHeader);
        this.logRequest("GetFile", "X-WOPI-MaxExpectedSize", maxExpectedSizeHeader);
        long blobLength = this.blob.getLength();
        if (blobLength > (long)maxExpectedSize) {
            this.logCondition(() -> "Blob length " + blobLength + " > max expected size " + maxExpectedSize);
            this.logResponse("GetFile", Response.Status.PRECONDITION_FAILED.getStatusCode(), new String[0]);
            throw new PreConditionFailedException();
        }
        this.buildItemVersionResponse("GetFile", this.blob);
        return this.blob;
    }

    @POST
    public Object doPost(@HeaderParam(value="X-WOPI-Override") Operation operation) {
        switch (operation) {
            case GET_LOCK: {
                return this.getLock();
            }
            case GET_SHARE_URL: {
                return this.getShareUrl();
            }
            case LOCK: {
                return this.lockOrUnlockAndRelock();
            }
            case PUT_RELATIVE: {
                return this.putRelativeFile();
            }
            case REFRESH_LOCK: {
                return this.refreshLock();
            }
            case RENAME_FILE: {
                return this.renameFile();
            }
            case UNLOCK: {
                return this.unlock();
            }
        }
        throw new BadRequestException();
    }

    protected Object lockOrUnlockAndRelock() {
        String lock = this.getHeader("Lock", "X-WOPI-Lock");
        String oldLock = this.getHeader("Lock", "X-WOPI-OldLock", true);
        return StringUtils.isEmpty((CharSequence)oldLock) ? this.lock(lock) : this.unlockAndRelock(lock, oldLock);
    }

    protected Object lock(String lock) {
        this.logRequest("Lock", "X-WOPI-Lock", lock);
        boolean isLocked = this.doc.isLocked();
        if (!isLocked || !LockHelper.isLocked(this.fileId)) {
            this.logCondition("Document isn't locked or there is no WOPI lock for this file id");
            this.checkWritePropertiesPermission("Lock");
            if (!isLocked) {
                this.logCondition("Document isn't locked");
                this.logNuxeoAction("Locking document");
                this.doc.setLock();
            }
            LockHelper.addLock(this.fileId, lock);
            return this.buildItemVersionResponse("Lock", this.blob);
        }
        this.logCondition("Document is locked and there is a WOPI lock for this file id");
        String currentLock = this.getCurrentLock("Lock");
        if (lock.equals(currentLock)) {
            this.logCondition(() -> "X-WOPI-Lock header is equal to current WOPI lock");
            LockHelper.refreshLock(this.fileId);
            return this.buildItemVersionResponse("Lock", this.blob);
        }
        this.logCondition(() -> "X-WOPI-Lock header is not equal to current WOPI lock");
        return this.buildConflictResponse("Lock", currentLock);
    }

    protected Response buildItemVersionResponse(String operation, Blob blob) {
        String itemVersion = blob.getDigest();
        this.response.addHeader("X-WOPI-ItemVersion", itemVersion);
        this.logResponse(operation, Response.Status.OK.getStatusCode(), "X-WOPI-ItemVersion", itemVersion);
        return Response.ok().build();
    }

    protected Object unlockAndRelock(String lock, String oldLock) {
        this.logRequest("UnlockAndRelock", "X-WOPI-Lock", lock, "X-WOPI-OldLock", oldLock);
        boolean isLocked = this.doc.isLocked();
        if (!isLocked) {
            this.logCondition("Document isn't locked");
            this.buildConflictResponse("UnlockAndRelock", "");
        }
        this.logCondition("Document is locked");
        String currentLock = this.getCurrentLock("UnlockAndRelock");
        if (oldLock.equals(currentLock)) {
            this.logCondition(() -> "X-WOPI-OldLock header is equal to current WOPI lock");
            LockHelper.updateLock(this.fileId, lock);
            this.logResponse("UnlockAndRelock", Response.Status.OK.getStatusCode(), new String[0]);
            return Response.ok().build();
        }
        this.logCondition(() -> "X-WOPI-OldLock header is not equal to current WOPI lock");
        return this.buildConflictResponse("UnlockAndRelock", currentLock);
    }

    protected String getCurrentLock(String operation) {
        String currentLock = LockHelper.getLock(this.fileId);
        if (currentLock == null) {
            this.logCondition("Current WOPI lock not found");
            this.logResponse(operation, Response.Status.CONFLICT.getStatusCode(), new String[0]);
            throw new ConflictException();
        }
        return currentLock;
    }

    protected Response buildConflictResponse(String operation, String lock) {
        this.response.addHeader("X-WOPI-Lock", lock);
        this.logResponse(operation, Response.Status.CONFLICT.getStatusCode(), "X-WOPI-Lock", lock);
        return Response.status((Response.Status)Response.Status.CONFLICT).build();
    }

    protected Object getLock() {
        this.logRequest("GetLock", new String[0]);
        if (!this.doc.isLocked()) {
            this.logCondition("Document isn't locked");
            String lockHeader = "";
            this.response.addHeader("X-WOPI-Lock", lockHeader);
            this.logResponse("GetLock", Response.Status.OK.getStatusCode(), "X-WOPI-Lock", lockHeader);
            return Response.ok().build();
        }
        String currentLock = this.getCurrentLock("GetLock");
        this.response.addHeader("X-WOPI-Lock", currentLock);
        this.logResponse("GetLock", Response.Status.OK.getStatusCode(), "X-WOPI-Lock", currentLock);
        return Response.ok().build();
    }

    protected Object unlockOrRefresh(String operation, String lock, boolean unlock) {
        String currentLock;
        if (!this.doc.isLocked()) {
            this.logCondition("Document isn't locked");
            this.buildConflictResponse(operation, "");
        }
        if (lock.equals(currentLock = this.getCurrentLock(operation))) {
            this.logCondition(() -> "X-WOPI-Lock header is equal to current WOPI lock");
            this.checkWritePropertiesPermission(operation);
            if (unlock) {
                LockHelper.removeLock(this.fileId);
                if (!LockHelper.isLocked(this.doc.getRepositoryName(), this.doc.getId())) {
                    this.logCondition("Found no WOPI lock");
                    this.logNuxeoAction("Unlocking document with a privileged session");
                    CoreInstance.doPrivileged((String)this.doc.getRepositoryName(), privilegedSession -> privilegedSession.removeLock(this.doc.getRef()));
                }
                return this.buildItemVersionResponse(operation, this.blob);
            }
            LockHelper.refreshLock(this.fileId);
            this.logResponse(operation, Response.Status.OK.getStatusCode(), new String[0]);
            return Response.ok().build();
        }
        this.logCondition(() -> "X-WOPI-Lock header is not equal to current WOPI lock");
        return this.buildConflictResponse(operation, currentLock);
    }

    public Object putRelativeFile() {
        String newFileName;
        String relativeTarget;
        String suggestedTarget = this.getHeader("PutRelativeFile", "X-WOPI-SuggestedTarget", true);
        if (suggestedTarget != null) {
            suggestedTarget = Helpers.readUTF7String(suggestedTarget);
        }
        if ((relativeTarget = this.getHeader("PutRelativeFile", "X-WOPI-RelativeTarget", true)) != null) {
            relativeTarget = Helpers.readUTF7String(relativeTarget);
        }
        String fileConversion = this.getHeader("PutRelativeFile", "X-WOPI-FileConversion", true);
        this.logRequest("PutRelativeFile", "X-WOPI-SuggestedTarget", suggestedTarget, "X-WOPI-RelativeTarget", relativeTarget, "X-WOPI-FileConversion", fileConversion);
        if (StringUtils.isEmpty((CharSequence)suggestedTarget) == StringUtils.isEmpty((CharSequence)relativeTarget)) {
            this.logCondition(() -> "X-WOPI-SuggestedTarget and X-WOPI-RelativeTarget headers are both present or not present, yet they are mutually exclusive");
            this.logResponse("PutRelativeFile", 501, new String[0]);
            throw new NotImplementedException();
        }
        if (StringUtils.isNotEmpty((CharSequence)suggestedTarget)) {
            this.logCondition(() -> "X-WOPI-SuggestedTarget header is present");
            newFileName = suggestedTarget.startsWith(".") ? FilenameUtils.getBaseName((String)this.blob.getFilename()) + suggestedTarget : suggestedTarget;
        } else {
            newFileName = relativeTarget;
        }
        if (StringUtils.isEmpty((CharSequence)fileConversion)) {
            this.logCondition(() -> "X-WOPI-FileConversion header is not present, yet new file creation is not supported");
            this.logResponse("PutRelativeFile", 501, new String[0]);
            throw new NotImplementedException();
        }
        this.logCondition(() -> "X-WOPI-FileConversion header is present, handling file conversion");
        DocumentModel newDoc = this.createVersionFromRequestBody(newFileName);
        String token = Helpers.getJWTToken(this.request);
        String newFileId = FileInfo.computeFileId(newDoc, this.xpath);
        String wopiSrc = String.format("%s%s%s?%s=%s", this.wopiBaseURL, "site/wopi/files/", newFileId, "access_token", token);
        String hostViewUrl = Helpers.getWOPIURL(this.baseURL, "view", newDoc, this.xpath);
        String hostEditUrl = Helpers.getWOPIURL(this.baseURL, "edit", newDoc, this.xpath);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("Name", newFileName);
        map.put("Url", wopiSrc);
        map.put("HostViewUrl", hostViewUrl);
        map.put("HostEditUrl", hostEditUrl);
        this.logResponse("PutRelativeFile", Response.Status.OK.getStatusCode(), map, new String[0]);
        return Response.ok(map).type("application/json").build();
    }

    protected DocumentModel createVersionFromRequestBody(String filename) {
        Blob newBlob = this.createBlobFromRequestBody(filename, null);
        this.doc.setPropertyValue(this.xpath, (Serializable)newBlob);
        this.doc.putContextData("source", (Serializable)((Object)"wopi"));
        this.doc = this.session.saveDocument(this.doc);
        this.logNuxeoAction(() -> "Created a version of document " + this.doc.getId() + " with filename " + filename);
        return this.doc;
    }

    public Object renameFile() {
        this.checkWritePropertiesPermission("RenameFile");
        String requestedName = Helpers.readUTF7String(this.getHeader("RenameFile", "X-WOPI-RequestedName"));
        if (!this.doc.isLocked()) {
            this.logCondition("Document isn't locked");
            this.logRequest("RenameFile", "X-WOPI-RequestedName", requestedName);
            return this.renameBlob(requestedName);
        }
        String currentLock = this.getCurrentLock("RenameFile");
        String lock = this.getHeader("RenameFile", "X-WOPI-Lock");
        this.logRequest("RenameFile", "X-WOPI-RequestedName", requestedName, "X-WOPI-Lock", lock);
        if (lock.equals(currentLock)) {
            this.logCondition(() -> "X-WOPI-Lock header is equal to current WOPI lock");
            return this.renameBlob(requestedName);
        }
        this.logCondition(() -> "X-WOPI-Lock header is not equal to current WOPI lock");
        return this.buildConflictResponse("RenameFile", currentLock);
    }

    protected Response renameBlob(String requestedName) {
        String extension = FilenameUtils.getExtension((String)this.blob.getFilename());
        String fullFilename = requestedName + (String)(extension != null ? "." + extension : "");
        this.logNuxeoAction(() -> "Renaming blob to " + fullFilename);
        this.blob.setFilename(fullFilename);
        this.doc.setPropertyValue(this.xpath, (Serializable)this.blob);
        this.session.saveDocument(this.doc);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("Name", requestedName);
        this.logResponse("RenameFile", Response.Status.OK.getStatusCode(), map, new String[0]);
        return Response.ok(map).type("application/json").build();
    }

    public Object getShareUrl() {
        String urlType = this.getHeader("GetShareUrl", "X-WOPI-UrlType", true);
        this.logRequest("GetShareUrl", "X-WOPI-UrlType", urlType);
        if (!"ReadOnly".equals(urlType) && !"ReadWrite".equals(urlType)) {
            this.logCondition(() -> "X-WOPI-UrlType header should be either ReadOnly or ReadWrite");
            this.logResponse("GetShareUrl", 501, new String[0]);
            throw new NotImplementedException();
        }
        String shareURL = Helpers.getWOPIURL(this.baseURL, urlType.equals("ReadOnly") ? "view" : "edit", this.doc, this.xpath);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("ShareUrl", shareURL);
        this.logResponse("GetShareUrl", Response.Status.OK.getStatusCode(), map, new String[0]);
        return Response.ok(map).type("application/json").build();
    }

    @POST
    @Path(value="contents")
    public Object doPostContents(@HeaderParam(value="X-WOPI-Override") Operation operation) {
        if (Operation.PUT.equals((Object)operation)) {
            return this.putFile();
        }
        this.logCondition(() -> "Invalid value " + operation + " for X-WOPI-Override header, should be " + Operation.PUT.name());
        throw new BadRequestException();
    }

    public Object putFile() {
        this.checkWritePropertiesPermission("PutFile");
        if (!this.doc.isLocked()) {
            this.logRequest("PutFile", new String[0]);
            this.logCondition("Document isn't locked");
            if (this.blob.getLength() == 0L) {
                this.logCondition("Blob is empty");
                return this.updateBlob();
            }
            this.logCondition("Blob is not empty");
            this.buildConflictResponse("PutFile", "");
        }
        String currentLock = this.getCurrentLock("PutFile");
        String lock = this.getHeader("PutFile", "X-WOPI-Lock");
        this.logRequest("PutFile", "X-WOPI-Lock", lock);
        if (lock.equals(currentLock)) {
            this.logCondition(() -> "X-WOPI-Lock header is equal to current WOPI lock");
            return this.updateBlob();
        }
        this.logCondition(() -> "X-WOPI-Lock header is not equal to current WOPI lock");
        return this.buildConflictResponse("PutFile", currentLock);
    }

    protected Response updateBlob() {
        this.logNuxeoAction("Updating blob");
        Blob newBlob = this.createBlobFromRequestBody(this.blob.getFilename(), this.blob.getMimeType());
        this.doc.setPropertyValue(this.xpath, (Serializable)newBlob);
        this.doc = this.session.saveDocument(this.doc);
        newBlob = (Blob)this.doc.getPropertyValue(this.xpath);
        return this.buildItemVersionResponse("PutFile", newBlob);
    }

    protected Blob createBlobFromRequestBody(String filename, String mimeType) {
        Blob blob;
        block8: {
            ServletInputStream is = this.request.getInputStream();
            try {
                Blob newBlob = Blobs.createBlob((InputStream)is);
                newBlob.setFilename(filename);
                newBlob.setMimeType(mimeType);
                blob = newBlob;
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new NuxeoException((Throwable)e);
                }
            }
            is.close();
        }
        return blob;
    }

    protected Object unlock() {
        String lock = this.getHeader("Unlock", "X-WOPI-Lock");
        this.logRequest("Unlock", "X-WOPI-Lock", lock);
        return this.unlockOrRefresh("Unlock", lock, true);
    }

    protected Object refreshLock() {
        String lock = this.getHeader("RefreshLock", "X-WOPI-Lock");
        this.logRequest("RefreshLock", "X-WOPI-Lock", lock);
        return this.unlockOrRefresh("RefreshLock", lock, false);
    }

    protected int getMaxExpectedSize(String maxExpectedSizeHeader) {
        if (!StringUtils.isEmpty((CharSequence)maxExpectedSizeHeader)) {
            try {
                return Integer.parseInt(maxExpectedSizeHeader, 10);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return Integer.MAX_VALUE;
    }

    protected String getHeader(String operation, String headerName) {
        return this.getHeader(operation, headerName, false);
    }

    protected String getHeader(String operation, String headerName, boolean nullable) {
        String header = Helpers.getHeader(this.httpHeaders, headerName);
        if (StringUtils.isEmpty((CharSequence)header) && !nullable) {
            this.logCondition(() -> "Header " + headerName + " is not present yet not nullable");
            this.logResponse(operation, Response.Status.BAD_REQUEST.getStatusCode(), new String[0]);
            throw new BadRequestException();
        }
        return header;
    }

    protected void checkWritePropertiesPermission(String operation) {
        if (!this.session.hasPermission(this.doc.getRef(), "WriteProperties")) {
            this.logCondition("Write permission check failed");
            this.logResponse(operation, Response.Status.CONFLICT.getStatusCode(), new String[0]);
            throw new ConflictException();
        }
    }

    protected Map<String, Serializable> buildCheckFileInfoMap() {
        HashMap<String, Serializable> map = new HashMap<String, Serializable>();
        this.addRequiredProperties(map);
        this.addHostCapabilitiesProperties(map);
        this.addUserMetadataProperties(map);
        this.addUserPermissionsProperties(map);
        this.addFileURLProperties(map);
        this.addBreadcrumbProperties(map);
        return map;
    }

    protected void addRequiredProperties(Map<String, Serializable> map) {
        NuxeoPrincipal principal = this.session.getPrincipal();
        map.put("BaseFileName", (Serializable)((Object)this.blob.getFilename()));
        map.put("OwnerId", this.doc.getPropertyValue("dc:creator"));
        map.put("Size", Long.valueOf(this.blob.getLength()));
        map.put("UserId", (Serializable)((Object)principal.getName()));
        map.put("Version", (Serializable)((Object)this.blob.getDigest()));
    }

    protected void addHostCapabilitiesProperties(Map<String, Serializable> map) {
        map.put("SupportsExtendedLockLength", Boolean.valueOf(true));
        map.put("SupportsGetLock", Boolean.valueOf(true));
        map.put("SupportsLocks", Boolean.valueOf(true));
        map.put("SupportsRename", Boolean.valueOf(true));
        map.put("SupportsUpdate", Boolean.valueOf(true));
        map.put("SupportedShareUrlTypes", (Serializable)((Object)Arrays.asList("ReadOnly", "ReadWrite")));
    }

    protected void addUserMetadataProperties(Map<String, Serializable> map) {
        NuxeoPrincipal principal = this.session.getPrincipal();
        map.put("IsAnonymousUser", Boolean.valueOf(principal.isAnonymous()));
        map.put("LicenseCheckForEditIsEnabled", Boolean.valueOf(true));
        map.put("UserFriendlyName", (Serializable)((Object)Helpers.principalFullName(principal)));
    }

    protected void addUserPermissionsProperties(Map<String, Serializable> map) {
        boolean hasWriteProperties = this.session.hasPermission(this.doc.getRef(), "WriteProperties");
        boolean canConvert = ((WOPIService)Framework.getService(WOPIService.class)).getActionURL(this.blob, "convert") != null;
        map.put("ReadOnly", Boolean.valueOf(!hasWriteProperties));
        map.put("UserCanRename", Boolean.valueOf(hasWriteProperties));
        map.put("UserCanWrite", Boolean.valueOf(hasWriteProperties));
        map.put("UserCanNotWriteRelative", Boolean.valueOf(!canConvert));
    }

    protected void addFileURLProperties(Map<String, Serializable> map) {
        String docURL = this.getDocumentURL(this.doc);
        if (docURL != null) {
            map.put("CloseUrl", (Serializable)((Object)docURL));
            map.put("FileVersionUrl", (Serializable)((Object)docURL));
        }
        String downloadURL = this.baseURL + ((DownloadService)Framework.getService(DownloadService.class)).getDownloadUrl(this.doc, this.xpath, this.blob.getFilename());
        map.put("DownloadUrl", (Serializable)((Object)downloadURL));
        map.put("HostEditUrl", (Serializable)((Object)Helpers.getWOPIURL(this.baseURL, "edit", this.doc, this.xpath)));
        map.put("HostViewUrl", (Serializable)((Object)Helpers.getWOPIURL(this.baseURL, "view", this.doc, this.xpath)));
        String signoutURL = this.baseURL + "logout";
        map.put("SignoutUrl", (Serializable)((Object)signoutURL));
    }

    protected void addBreadcrumbProperties(Map<String, Serializable> map) {
        map.put("BreadcrumbBrandName", (Serializable)((Object)Framework.getProperty((String)"org.nuxeo.ecm.product.name")));
        map.put("BreadcrumbBrandUrl", (Serializable)((Object)this.baseURL));
        DocumentRef parentRef = this.doc.getParentRef();
        if (this.session.exists(parentRef)) {
            DocumentModel parent = this.session.getDocument(parentRef);
            map.put("BreadcrumbFolderName", (Serializable)((Object)parent.getTitle()));
            String url = this.getDocumentURL(parent);
            if (url != null) {
                map.put("BreadcrumbFolderUrl", (Serializable)((Object)url));
            }
        }
    }

    protected String getDocumentURL(DocumentModel doc) {
        TypeInfo adapter = (TypeInfo)doc.getAdapter(TypeInfo.class);
        if (adapter != null) {
            DocumentLocationImpl docLoc = new DocumentLocationImpl(doc);
            DocumentViewImpl docView = new DocumentViewImpl((DocumentLocation)docLoc, adapter.getDefaultView());
            return ((DocumentViewCodecManager)Framework.getService(DocumentViewCodecManager.class)).getUrlFromDocumentView("notificationDocId", (DocumentView)docView, true, this.baseURL);
        }
        return null;
    }

    protected void logRequest(String operation, String ... headers) {
        org.apache.logging.log4j.util.Supplier[] supplierArray = new org.apache.logging.log4j.util.Supplier[7];
        supplierArray[0] = () -> ((DocumentModel)this.doc).getRepositoryName();
        supplierArray[1] = () -> ((DocumentModel)this.doc).getId();
        supplierArray[2] = () -> this.xpath;
        supplierArray[3] = () -> ((CoreSession)this.session).getPrincipal();
        supplierArray[4] = () -> this.fileId;
        supplierArray[5] = () -> operation;
        supplierArray[6] = () -> this.getHeaderString(headers);
        log.debug("Request: repository={} docId={} xpath={} user={} fileId={} operation={}{}", supplierArray);
    }

    protected void logCondition(String condition) {
        this.logCondition(() -> condition);
    }

    protected void logCondition(Supplier<String> condition) {
        org.apache.logging.log4j.util.Supplier[] supplierArray = new org.apache.logging.log4j.util.Supplier[6];
        supplierArray[0] = () -> ((DocumentModel)this.doc).getRepositoryName();
        supplierArray[1] = () -> ((DocumentModel)this.doc).getId();
        supplierArray[2] = () -> this.xpath;
        supplierArray[3] = () -> ((CoreSession)this.session).getPrincipal();
        supplierArray[4] = () -> this.fileId;
        supplierArray[5] = condition::get;
        log.debug("Condition: repository={} docId={} xpath={} user={} fileId={} {}", supplierArray);
    }

    protected void logNuxeoAction(String action) {
        this.logNuxeoAction(() -> action);
    }

    protected void logNuxeoAction(Supplier<String> action) {
        org.apache.logging.log4j.util.Supplier[] supplierArray = new org.apache.logging.log4j.util.Supplier[6];
        supplierArray[0] = () -> ((DocumentModel)this.doc).getRepositoryName();
        supplierArray[1] = () -> ((DocumentModel)this.doc).getId();
        supplierArray[2] = () -> this.xpath;
        supplierArray[3] = () -> ((CoreSession)this.session).getPrincipal();
        supplierArray[4] = () -> this.fileId;
        supplierArray[5] = action::get;
        log.debug("Nuxeo action: repository={} docId={} xpath={} user={} fileId={} {}", supplierArray);
    }

    protected void logResponse(String operation, int status, String ... headers) {
        this.logResponse(operation, status, (Object)null, headers);
    }

    protected void logResponse(String operation, int status, Object entity, String ... headers) {
        org.apache.logging.log4j.util.Supplier[] supplierArray = new org.apache.logging.log4j.util.Supplier[9];
        supplierArray[0] = () -> ((DocumentModel)this.doc).getRepositoryName();
        supplierArray[1] = () -> ((DocumentModel)this.doc).getId();
        supplierArray[2] = () -> this.xpath;
        supplierArray[3] = () -> ((CoreSession)this.session).getPrincipal();
        supplierArray[4] = () -> this.fileId;
        supplierArray[5] = () -> operation;
        supplierArray[6] = () -> status;
        supplierArray[7] = () -> this.getEntityString(entity);
        supplierArray[8] = () -> this.getHeaderString(headers);
        log.debug("Response: repository={} docId={} xpath={} user={} fileId={} operation={} status={}{}{}", supplierArray);
    }

    protected String getHeaderString(String ... headers) {
        if (ArrayUtils.isEmpty((Object[])headers)) {
            return "";
        }
        HashMap<String, String> headerMap = new HashMap<String, String>();
        for (int i = 0; i < headers.length; i += 2) {
            headerMap.put(headers[i], headers[i + 1]);
        }
        return " headers=" + headerMap;
    }

    protected String getEntityString(Object entity) {
        return entity == null ? "" : " body=" + entity.toString();
    }
}

