/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.wopi.jaxrs;

import javax.servlet.ServletRequest;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.platform.web.common.RequestContext;
import org.nuxeo.ecm.platform.web.common.vh.VirtualHostHelper;
import org.nuxeo.ecm.webengine.model.WebContext;
import org.nuxeo.ecm.webengine.model.WebObject;
import org.nuxeo.ecm.webengine.model.impl.ModuleRoot;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.wopi.FileInfo;
import org.nuxeo.wopi.Helpers;
import org.nuxeo.wopi.WOPIService;
import org.nuxeo.wopi.exception.InternalServerErrorException;
import org.nuxeo.wopi.exception.NotFoundException;
import org.nuxeo.wopi.lock.LockHelper;

@Path(value="/")
@WebObject(type="wopi")
public class WOPIRoot
extends ModuleRoot {
    protected static final String THREAD_NAME_PREFIX = "WOPI_";
    @Context
    protected HttpHeaders httpHeaders;

    @Path(value="/files/{fileId}")
    public Object filesResource(@PathParam(value="fileId") FileInfo fileInfo) {
        this.prefixThreadName();
        this.verifyProofKey();
        LockHelper.flagWOPIRequest();
        RequestContext.getActiveContext((ServletRequest)this.request).addRequestCleanupHandler(req -> LockHelper.unflagWOPIRequest());
        WebContext context = this.getContext();
        context.setRepositoryName(fileInfo.repositoryName);
        CoreSession session = context.getCoreSession();
        DocumentModel doc = this.getDocument(session, fileInfo.docId);
        Blob blob = this.getBlob(doc, fileInfo.xpath);
        return this.newObject("wopiFiles", new Object[]{session, doc, blob, fileInfo.xpath});
    }

    protected void prefixThreadName() {
        Thread currentThread = Thread.currentThread();
        String threadName = currentThread.getName();
        if (!threadName.startsWith(THREAD_NAME_PREFIX)) {
            currentThread.setName(THREAD_NAME_PREFIX + threadName);
        }
    }

    protected void verifyProofKey() {
        String proofKeyHeader = Helpers.getHeader(this.httpHeaders, "X-WOPI-Proof");
        String oldProofKeyHeader = Helpers.getHeader(this.httpHeaders, "X-WOPI-ProofOld");
        String timestampHeader = Helpers.getHeader(this.httpHeaders, "X-WOPI-TimeStamp");
        String accessToken = this.request.getParameter("access_token");
        String wopiBaseURL = Framework.getProperty((String)"nuxeo.wopi.baseURL", (String)VirtualHostHelper.getBaseURL((ServletRequest)this.request));
        String requestURI = this.request.getRequestURI().substring(this.request.getContextPath().length() + 1);
        String url = String.format("%s%s?%s", wopiBaseURL, requestURI, this.request.getQueryString());
        if (!((WOPIService)Framework.getService(WOPIService.class)).verifyProofKey(proofKeyHeader, oldProofKeyHeader, url, accessToken, timestampHeader)) {
            throw new InternalServerErrorException();
        }
    }

    protected DocumentModel getDocument(CoreSession session, String fileId) {
        IdRef ref = new IdRef(fileId);
        if (!session.exists((DocumentRef)ref)) {
            throw new NotFoundException();
        }
        return session.getDocument((DocumentRef)ref);
    }

    protected Blob getBlob(DocumentModel doc, String xpath) {
        Blob blob = Helpers.getEditableBlob(doc, xpath);
        if (blob == null) {
            throw new NotFoundException();
        }
        return blob;
    }
}

