/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.wopi.lock;

import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.nuxeo.ecm.core.api.CloseableCoreSession;
import org.nuxeo.ecm.core.api.CoreInstance;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.event.EventBundle;
import org.nuxeo.ecm.core.event.PostCommitEventListener;
import org.nuxeo.ecm.directory.Session;
import org.nuxeo.wopi.lock.LockHelper;

public class LockExpirationListener
implements PostCommitEventListener {
    private static final Logger log = LogManager.getLogger(LockExpirationListener.class);

    public void handleEvent(EventBundle eventBundle) {
        LockHelper.doPrivilegedOnLockDirectory(this::handleExpiredLocks);
    }

    protected void handleExpiredLocks(Session directorySession) {
        LockHelper.getExpiredLocksByRepository(directorySession).entrySet().forEach(entry -> {
            String repository = (String)entry.getKey();
            List lockEntries = (List)entry.getValue();
            try (CloseableCoreSession session = CoreInstance.openCoreSession((String)repository);){
                lockEntries.forEach(lockEntry -> this.handleExpiredLock((CoreSession)session, directorySession, (DocumentModel)lockEntry));
            }
        });
    }

    protected void handleExpiredLock(CoreSession session, Session directorySession, DocumentModel entry) {
        String docId = (String)entry.getProperty("wopiLocks", "docId");
        Supplier[] supplierArray = new Supplier[2];
        supplierArray[0] = () -> ((CoreSession)session).getRepositoryName();
        supplierArray[1] = () -> docId;
        log.debug("Locking:  repository={} docId={} WOPI lock expired, unlocking document and removing lock from directory", supplierArray);
        session.removeLock((DocumentRef)new IdRef(docId));
        directorySession.deleteEntry((String)entry.getProperty("wopiLocks", "fileId"));
    }
}

