/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.wopi.lock;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.repository.RepositoryManager;
import org.nuxeo.ecm.core.query.sql.model.Predicates;
import org.nuxeo.ecm.core.query.sql.model.QueryBuilder;
import org.nuxeo.ecm.directory.Session;
import org.nuxeo.ecm.directory.api.DirectoryService;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.wopi.FileInfo;

public class LockHelper {
    private static final Logger log = LogManager.getLogger(LockHelper.class);
    protected static ThreadLocal<Boolean> isWOPIRequest = new ThreadLocal();

    private LockHelper() {
    }

    public static void addLock(String fileId, String lock) {
        FileInfo fileInfo = new FileInfo(fileId);
        LockHelper.addLock(fileId, fileInfo.repositoryName, fileInfo.docId, lock);
    }

    public static void addLock(String fileId, String repository, String docId, String lock) {
        log.debug("Locking: fileId={} Adding lock {}", (Object)fileId, (Object)lock);
        LockHelper.doPrivilegedOnLockDirectory((Session session) -> {
            HashMap<String, Object> entryMap = new HashMap<String, Object>();
            entryMap.put("fileId", fileId);
            entryMap.put("repository", repository);
            entryMap.put("docId", docId);
            entryMap.put("lock", lock);
            entryMap.put("timestamp", System.currentTimeMillis());
            session.createEntry(entryMap);
        });
    }

    public static String getLock(String fileId) {
        return LockHelper.doPrivilegedOnLockDirectory((Session session) -> {
            DocumentModel entry = session.getEntry(fileId);
            return entry == null ? null : (String)entry.getProperty("wopiLocks", "lock");
        });
    }

    public static boolean isLocked(String repository, String docId) {
        QueryBuilder queryBuilder = new QueryBuilder().predicate(Predicates.eq((String)"repository", (Object)repository)).and(Predicates.eq((String)"docId", (Object)docId));
        return LockHelper.doPrivilegedOnLockDirectory((Session session) -> !session.query(queryBuilder, false).isEmpty());
    }

    public static boolean isLocked(String fileId) {
        return LockHelper.doPrivilegedOnLockDirectory((Session session) -> session.getEntry(fileId) != null);
    }

    public static void updateLock(String fileId, String lock) {
        log.debug("Locking: fileId={} Updating lock {}", (Object)fileId, (Object)lock);
        LockHelper.doPrivilegedOnLockDirectory((Session session) -> {
            DocumentModel entry = session.getEntry(fileId);
            entry.setProperty("wopiLocks", "lock", (Object)lock);
            entry.setProperty("wopiLocks", "timestamp", (Object)System.currentTimeMillis());
            session.updateEntry(entry);
        });
    }

    public static void refreshLock(String fileId) {
        log.debug("Locking: fileId={} Refreshing lock", (Object)fileId);
        LockHelper.doPrivilegedOnLockDirectory((Session session) -> {
            DocumentModel entry = session.getEntry(fileId);
            entry.setProperty("wopiLocks", "timestamp", (Object)System.currentTimeMillis());
            session.updateEntry(entry);
        });
    }

    public static void removeLock(String fileId) {
        log.debug("Locking: fileId={} Removing lock", (Object)fileId);
        LockHelper.doPrivilegedOnLockDirectory((Session session) -> session.deleteEntry(fileId));
    }

    public static void removeLocks(String repository, String docId) {
        log.debug("Locking: repository={} docId={} Document was unlocked in Nuxeo, removing related WOPI locks", (Object)repository, (Object)docId);
        QueryBuilder queryBuilder = new QueryBuilder().predicate(Predicates.eq((String)"repository", (Object)repository)).and(Predicates.eq((String)"docId", (Object)docId));
        LockHelper.doPrivilegedOnLockDirectory((Session session) -> session.query(queryBuilder, false).forEach(arg_0 -> ((Session)session).deleteEntry(arg_0)));
    }

    public static void doPrivilegedOnLockDirectory(Consumer<Session> consumer) {
        Framework.doPrivileged(() -> {
            try (Session session = LockHelper.openLockDirectorySession();){
                consumer.accept(session);
            }
        });
    }

    public static <R> R doPrivilegedOnLockDirectory(Function<Session, R> function) {
        return (R)Framework.doPrivileged(() -> {
            try (Session session = LockHelper.openLockDirectorySession();){
                Object r = function.apply(session);
                return r;
            }
        });
    }

    public static Map<String, List<DocumentModel>> getExpiredLocksByRepository(Session session) {
        return ((RepositoryManager)Framework.getService(RepositoryManager.class)).getRepositoryNames().stream().map(repository -> LockHelper.getExpiredLocks(session, repository)).reduce(new HashMap(), (a, b) -> {
            a.putAll(b);
            return a;
        });
    }

    public static boolean isWOPIRequest() {
        return Boolean.TRUE.equals(isWOPIRequest.get());
    }

    public static void flagWOPIRequest() {
        isWOPIRequest.set(true);
    }

    public static void unflagWOPIRequest() {
        isWOPIRequest.remove();
    }

    protected static Map<String, List<DocumentModel>> getExpiredLocks(Session session, String repository) {
        long expirationTime = System.currentTimeMillis() - 1800000L;
        QueryBuilder queryBuilder = new QueryBuilder().predicate(Predicates.eq((String)"repository", (Object)repository)).and(Predicates.lt((String)"timestamp", (Object)expirationTime));
        DocumentModelList expiredLocks = session.query(queryBuilder, false);
        return Collections.singletonMap(repository, expiredLocks);
    }

    protected static Session openLockDirectorySession() {
        return ((DirectoryService)Framework.getService(DirectoryService.class)).open("wopiLocks");
    }
}

