/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.wopi.lock;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.api.security.ACP;
import org.nuxeo.ecm.core.api.security.Access;
import org.nuxeo.ecm.core.model.Document;
import org.nuxeo.ecm.core.security.LockSecurityPolicy;
import org.nuxeo.wopi.lock.LockHelper;

public class WOPILockSecurityPolicy
extends LockSecurityPolicy {
    private static final Logger log = LogManager.getLogger(WOPILockSecurityPolicy.class);

    public Access checkPermission(Document doc, ACP mergedAcp, NuxeoPrincipal principal, String permission, String[] resolvedPermissions, String[] additionalPrincipals) {
        Access access = super.checkPermission(doc, mergedAcp, principal, permission, resolvedPermissions, additionalPrincipals);
        String repositoryName = doc.getSession().getRepositoryName();
        String docUUID = doc.getUUID();
        if (Access.DENY.equals(access) && LockHelper.isLocked(repositoryName, docUUID) && LockHelper.isWOPIRequest()) {
            log.debug("Security: repository={} docId={} user={} Document is locked by another user but it has a WOPI lock and the current user belongs to a WOPI session, don't block WRITE permission", (Object)repositoryName, (Object)docUUID, (Object)principal);
            return Access.UNKNOWN;
        }
        return access;
    }
}

