/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.rss.reader.webengine;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.PathRef;
import org.nuxeo.ecm.webengine.WebEngine;
import org.nuxeo.ecm.webengine.model.WebObject;
import org.nuxeo.ecm.webengine.model.impl.ModuleRoot;
import org.nuxeo.rss.reader.FeedHelper;
import org.nuxeo.rss.reader.service.RSSFeedService;
import org.nuxeo.runtime.api.Framework;

@Path(value="/rssreader")
@WebObject(type="rssreader")
@Produces(value={"text/html; charset=UTF-8"})
public class RssReaderModuleRoot
extends ModuleRoot {
    @GET
    @Path(value="/item")
    public Object getItemContent(@QueryParam(value="i") String id, @QueryParam(value="language") String language) throws Exception {
        WebEngine.getActiveContext().setLocale(new Locale(language));
        RSSFeedService rssFeedService = (RSSFeedService)Framework.getLocalService(RSSFeedService.class);
        List urls = rssFeedService.getCurrentUserRssFeedAddresses(this.ctx.getCoreSession());
        return this.getView("item").args(FeedHelper.searchFeedEntry((String[])urls.toArray(new String[urls.size()]), (String)id));
    }

    @GET
    @Path(value="/sample")
    public Object getSample() {
        return this.getView("sample");
    }

    @GET
    @Path(value="/config")
    public Object getConfigPage(@QueryParam(value="language") String language) throws Exception {
        WebEngine.getActiveContext().setLocale(new Locale(language));
        CoreSession session = this.ctx.getCoreSession();
        boolean isAbleToCreateNew = false;
        RSSFeedService rssFeedService = (RSSFeedService)Framework.getLocalService(RSSFeedService.class);
        DocumentModelList userFeeds = rssFeedService.getCurrentUserRssFeedDocumentModelList(session);
        DocumentModelList globalFeeds = rssFeedService.getGlobalFeedsDocumentModelList(session);
        ArrayList<DocumentModel> options = new ArrayList<DocumentModel>();
        if (userFeeds != null && globalFeeds != null) {
            for (DocumentModel f1 : globalFeeds) {
                boolean found = false;
                String url1 = (String)((Object)f1.getPropertyValue("rf:rss_address"));
                for (DocumentModel f2 : userFeeds) {
                    String url2 = (String)((Object)f2.getPropertyValue("rf:rss_address"));
                    if (url2 == null || !url2.equals(url1)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                options.add(f1);
            }
            isAbleToCreateNew = userFeeds.size() < rssFeedService.getMaximumFeedsCount(session);
        }
        return this.getView("feed_configuration").arg("userFeeds", (Object)userFeeds).arg("globalFeeds", options).arg("ableToCreateNew", (Object)isAbleToCreateNew).arg("maxFeedsCount", (Object)rssFeedService.getMaximumFeedsCount(session));
    }

    @POST
    @Path(value="/removeFeed")
    public Object removeFeed(@FormParam(value="id") String id, @QueryParam(value="language") String language) throws Exception {
        CoreSession session = this.ctx.getCoreSession();
        session.removeDocument((DocumentRef)new IdRef(id));
        session.save();
        return this.getConfigPage(language);
    }

    @POST
    @Path(value="/addGlobalFeed")
    public Object addGlobalFeed(@FormParam(value="feedId") String feedId, @QueryParam(value="language") String language) throws Exception {
        CoreSession session = this.ctx.getCoreSession();
        RSSFeedService rssFeedService = (RSSFeedService)Framework.getLocalService(RSSFeedService.class);
        DocumentModelList userFeeds = rssFeedService.getCurrentUserRssFeedDocumentModelList(session);
        if (userFeeds != null && userFeeds.size() >= rssFeedService.getMaximumFeedsCount(session)) {
            return this.getConfigPage(language);
        }
        String userFeedsContainer = rssFeedService.getCurrentUserRssFeedsContainer(session).getPathAsString();
        session.copy((DocumentRef)new IdRef(feedId), (DocumentRef)new PathRef(userFeedsContainer), null);
        return this.getConfigPage(language);
    }

    @POST
    @Path(value="/addNewFeed")
    public Object addGlobalFeed(@FormParam(value="feedName") String feedName, @FormParam(value="feedLink") String url, @QueryParam(value="language") String language) throws Exception {
        CoreSession session = this.ctx.getCoreSession();
        RSSFeedService rssFeedService = (RSSFeedService)Framework.getLocalService(RSSFeedService.class);
        DocumentModelList userFeeds = rssFeedService.getCurrentUserRssFeedDocumentModelList(session);
        if (userFeeds != null && userFeeds.size() >= rssFeedService.getMaximumFeedsCount(session)) {
            return this.getConfigPage(language);
        }
        String userFeedsContainerPath = rssFeedService.getCurrentUserRssFeedsContainer(session).getPathAsString();
        DocumentModel feed = session.createDocumentModel(userFeedsContainerPath, feedName, "RssFeed");
        feed.setPropertyValue("dc:title", (Serializable)((Object)feedName));
        feed.setPropertyValue("rf:rss_address", (Serializable)((Object)url));
        feed = session.createDocument(feed);
        session.save();
        return this.getConfigPage(language);
    }
}

