/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.rss.reader.service;

import java.util.ArrayList;
import java.util.List;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.PathRef;
import org.nuxeo.ecm.platform.userworkspace.api.UserWorkspaceService;
import org.nuxeo.rss.reader.runner.UnrestrictedRssReaderManagementRootGenerator;
import org.nuxeo.rss.reader.service.RSSFeedService;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.DefaultComponent;

public class RSSFeedComponent
extends DefaultComponent
implements RSSFeedService {
    @Override
    public DocumentModel getRssReaderManagementContainer(CoreSession session) throws ClientException {
        if (!session.exists((DocumentRef)new PathRef("/management/rssFeeds"))) {
            new UnrestrictedRssReaderManagementRootGenerator(session, "/management").runUnrestricted();
        }
        return session.getDocument((DocumentRef)new PathRef("/management/rssFeeds"));
    }

    @Override
    public DocumentModel getCurrentUserRssFeedsContainer(CoreSession session) throws ClientException {
        String userWorkspace = this.getCurrentUserWorkspace(session);
        String userRssFeedPath = userWorkspace + "/" + "rssFeeds";
        if (!session.exists((DocumentRef)new PathRef(userRssFeedPath))) {
            new UnrestrictedRssReaderManagementRootGenerator(session, userWorkspace).willSetRightsForAdminitrators(false).runUnrestricted();
            session.copy(this.getDefaultRssFeedModels(session), (DocumentRef)new PathRef(userRssFeedPath));
        }
        return session.getDocument((DocumentRef)new PathRef(userRssFeedPath));
    }

    protected String getCurrentUserWorkspace(CoreSession session) throws ClientException {
        UserWorkspaceService uws;
        try {
            uws = (UserWorkspaceService)Framework.getService(UserWorkspaceService.class);
        }
        catch (Exception e) {
            throw new ClientException("Can't fetch the UserWorkspace service, please check", (Throwable)e);
        }
        String userWorkspace = uws.getCurrentUserPersonalWorkspace(session, null).getPathAsString();
        return userWorkspace;
    }

    @Override
    public int getDisplayedArticleCount(CoreSession session) throws ClientException {
        DocumentModel adminContainer = this.getRssReaderManagementContainer(session);
        return ((Long)adminContainer.getPropertyValue("rg:article_count")).intValue();
    }

    @Override
    public int getMaximumFeedsCount(CoreSession session) throws ClientException {
        DocumentModel adminContainer = this.getRssReaderManagementContainer(session);
        return ((Long)adminContainer.getPropertyValue("rg:max_feed_count")).intValue();
    }

    @Override
    public DocumentModelList getGlobalFeedsDocumentModelList(CoreSession session) throws ClientException {
        String query = "SELECT * FROM Document where ecm:primaryType = '%s' AND ecm:parentId = '%s' AND ecm:currentLifeCycleState != 'deleted'";
        return session.query(String.format(query, "RssFeed", this.getRssReaderManagementContainer(session).getRef()));
    }

    @Override
    public DocumentModelList getCurrentUserRssFeedDocumentModelList(CoreSession session) throws ClientException {
        String query = "SELECT * FROM Document where ecm:primaryType = '%s' AND ecm:parentId = '%s' AND ecm:currentLifeCycleState != 'deleted'";
        return session.query(String.format(query, "RssFeed", this.getCurrentUserRssFeedsContainer(session).getRef()));
    }

    @Override
    public List<String> getCurrentUserRssFeedAddresses(CoreSession session) throws ClientException {
        ArrayList<String> addresses = new ArrayList<String>();
        for (DocumentModel dc : this.getCurrentUserRssFeedDocumentModelList(session)) {
            addresses.add(dc.getPropertyValue("rf:rss_address").toString());
        }
        return addresses;
    }

    protected List<DocumentRef> getDefaultRssFeedModels(CoreSession session) throws ClientException {
        ArrayList<DocumentRef> defaultFeeds = new ArrayList<DocumentRef>();
        DocumentModelList docs = this.getGlobalFeedsDocumentModelList(session);
        for (DocumentModel doc : docs) {
            if (!Boolean.TRUE.equals(doc.getPropertyValue("rf:is_default_feed"))) continue;
            defaultFeeds.add(doc.getRef());
        }
        return defaultFeeds;
    }
}

